/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.SQLExceptionFactory;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;

public class ClientCallableStatement
extends ClientPreparedStatement
implements PreparedStatement,
CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    @Override
    public void reset(boolean bl) throws SqlException {
        if (bl) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(bl);
        }
        this.wasNull_ = 0;
    }

    public ClientCallableStatement(Agent agent, ClientConnection clientConnection, String string, int n2, int n3, int n4, ClientPooledConnection clientPooledConnection) throws SqlException {
        super(agent, clientConnection, string, n2, n3, n4, 2, null, null, clientPooledConnection);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, ClientConnection clientConnection, String string, int n2, int n3, int n4) throws SqlException {
        super.resetPreparedStatement(agent, clientConnection, string, n2, n3, n4, 2, null, null);
        this.initCallableStatement();
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize", new Object[0]);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters", new Object[0]);
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n2, n3);
                }
                this.registerOutParameterX(n2, n3);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void registerOutParameterX(int n2, int n3) throws SqlException {
        super.checkForClosedStatement();
        int n4 = 0;
        this.registerOutParameterX(n2, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n2, n3, n4);
                }
                super.checkForClosedStatement();
                this.registerOutParameterX(n2, n3, n4);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private void registerOutParameterX(int n2, int n3, int n4) throws SqlException {
        super.checkForValidParameterIndex(n2);
        this.agent_.checkForSupportedDataType(n3);
        this.checkForValidScale(n4);
        this.outputRegistered_ = true;
        this.parameterRegistered_[n2 - 1] = true;
    }

    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", n2, n3, string);
        }
        this.registerOutParameter(n2, n3);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull", new Object[0]);
            }
            boolean bl = this.wasNullX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", bl);
            }
            return bl;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"), new Object[0]);
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                boolean bl;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBoolean", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                boolean bl2 = bl = this.wasNullX() ? false : this.singletonRowData_.getBoolean(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", bl);
                }
                return bl;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                byte by;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getByte", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                byte by2 = by = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", by);
                }
                return by;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                short s2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getShort", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                short s3 = s2 = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", s2);
                }
                return s2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getInt", n2);
                }
                int n3 = this.getIntX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getInt", n3);
                }
                return n3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    int getIntX(int n2) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n2);
        this.setWasNull(n2);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getLong", n2);
                }
                long l2 = this.getLongX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    long getLongX(int n2) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n2);
        this.setWasNull(n2);
        return this.wasNullX() ? 0L : this.singletonRowData_.getLong(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                float f2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getFloat", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                float f3 = f2 = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", Float.valueOf(f2));
                }
                return f2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                double d2;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDouble", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                double d3 = d2 = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", d2);
                }
                return d2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException, ArithmeticException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedEntry(this, "getBigDecimal", n2, n3);
                }
                super.checkForClosedStatement();
                this.checkForValidScale(n3);
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n2);
                if (bigDecimal != null) {
                    bigDecimal = bigDecimal.setScale(n3, 1);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit(this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                BigDecimal bigDecimal;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBigDecimal", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                BigDecimal bigDecimal2 = bigDecimal = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", bigDecimal);
                }
                return bigDecimal;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Date date;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getDate", n2, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n2);
                Date date2 = date = this.wasNullX() ? null : this.singletonRowData_.getDate(n2, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDate", date);
                }
                return date;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.getDate(n2, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Time time;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTime", n2, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n2);
                Time time2 = time = this.wasNullX() ? null : this.singletonRowData_.getTime(n2, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTime", time);
                }
                return time;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.getTime(n2, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Timestamp timestamp;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTimestamp", n2, calendar);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                if (calendar == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S"), new Object[0]);
                }
                this.setWasNull(n2);
                Timestamp timestamp2 = timestamp = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(n2, calendar);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", timestamp);
                }
                return timestamp;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getString", n2);
                }
                String string = this.getStringX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getString", string);
                }
                return string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    String getStringX(int n2) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n2);
        this.setWasNull(n2);
        return this.wasNullX() ? null : this.singletonRowData_.getString(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBytes", n2);
                }
                byte[] byArray = this.getBytesX(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", byArray);
                }
                return byArray;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    byte[] getBytesX(int n2) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(n2);
        this.setWasNull(n2);
        return this.wasNullX() ? null : this.singletonRowData_.getBytes(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Blob blob;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getBlob", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Blob blob2 = blob = this.wasNullX() ? null : this.singletonRowData_.getBlob(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBlob", blob);
                }
                return blob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Clob clob;
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Clob clob2 = clob = this.wasNullX() ? null : this.singletonRowData_.getClob(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getClob", clob);
                }
                return clob;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getArray", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Array array = this.wasNullX() ? null : this.singletonRowData_.getArray(n2);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getRef", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Ref ref = this.wasNullX() ? null : this.singletonRowData_.getRef(n2);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                Object object;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Object object2 = object = this.wasNullX() ? null : this.singletonRowData_.getObject(n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", object);
                }
                return object;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public Object getObject(int n2, Map map) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getObject", n2, map);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]);
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public void registerOutParameter(String string, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n2, n3);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "registerOutParameter", string, n2, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setURL", string, uRL);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", string, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBoolean", string, bl);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setByte", string, by);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setShort", string, s2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setInt", string, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setLong", string, l2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setFloat", string, Float.valueOf(f2));
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDouble", string, d2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBigDecimal", string, bigDecimal);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setString", string, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBytes", string, byArray);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", string, date);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", string, time);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", string, timestamp);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setAsciiStream", string, inputStream, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setBinaryStream", string, inputStream, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object, n2, n3);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setObject", string, object);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setCharacterStream", string, reader, n2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setDate", string, date, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTime", string, time, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setTimestamp", string, timestamp, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "setNull", string, n2, string2);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public String getString(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getString", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBoolean", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getByte", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public short getShort(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getShort", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public int getInt(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getInt", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public long getLong(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getLong", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getFloat", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDouble", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBytes", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBigDecimal", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getObject", string, map);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getRef", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getBlob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getClob", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getArray", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getDate", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTime", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getTimestamp", string, calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "getURL", string);
        }
        throw this.jdbcMethodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            ClientConnection clientConnection = this.connection_;
            synchronized (clientConnection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream", n2);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(n2);
                this.setWasNull(n2);
                Reader reader = null;
                if (this.wasNull_ == 2) {
                    reader = this.singletonRowData_.getCharacterStream(n2);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream,long)");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream,long)");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader,long)");
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getCharacterStream(String)");
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(int)");
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNCharacterStream(String)");
    }

    @Override
    public String getNString(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(int)");
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getNString(String)");
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (int)");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getRowId (String)");
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setRowId (String, RowId)");
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String, Blob)");
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String, Clob)");
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, String)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNString (String, Reader, long)");
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, NClob)");
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob (String, Reader, long)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob (String, InputStream, long)");
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String, Reader, long)");
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (int)");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob (String)");
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setSQLXML (String, SQLXML)");
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (int)");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw SQLExceptionFactory.notImplemented("getSQLXML (String)");
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setAsciiStream(String,InputStream)");
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBinaryStream(String,InputStream)");
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setBlob(String,InputStream)");
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setCharacterStream(String,Reader)");
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setClob(String,Reader)");
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNCharacterStream(String,Reader)");
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw SQLExceptionFactory.notImplemented("setNClob(String,Reader)");
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw this.mismatchException("NULL", n2);
        }
        Object object = String.class.equals(clazz) ? this.getString(n2) : (BigDecimal.class.equals(clazz) ? this.getBigDecimal(n2) : (Boolean.class.equals(clazz) ? Boolean.valueOf(this.getBoolean(n2)) : (Byte.class.equals(clazz) ? Byte.valueOf(this.getByte(n2)) : (Short.class.equals(clazz) ? Short.valueOf(this.getShort(n2)) : (Integer.class.equals(clazz) ? Integer.valueOf(this.getInt(n2)) : (Long.class.equals(clazz) ? Long.valueOf(this.getLong(n2)) : (Float.class.equals(clazz) ? Float.valueOf(this.getFloat(n2)) : (Double.class.equals(clazz) ? Double.valueOf(this.getDouble(n2)) : (Date.class.equals(clazz) ? this.getDate(n2) : (Time.class.equals(clazz) ? this.getTime(n2) : (Timestamp.class.equals(clazz) ? this.getTimestamp(n2) : (Blob.class.equals(clazz) ? this.getBlob(n2) : (Clob.class.equals(clazz) ? this.getClob(n2) : (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(n2) : this.getObject(n2)))))))))))))));
        if (this.wasNull()) {
            object = null;
        }
        if (object == null || clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw this.mismatchException(clazz.getName(), n2);
    }

    private SQLException mismatchException(String string, int n2) throws SQLException {
        String string2 = this.getParameterMetaData().getParameterTypeName(n2);
        ClientMessageId clientMessageId = new ClientMessageId("22005");
        SqlException sqlException = new SqlException(this.agent_.logWriter_, clientMessageId, string, string2);
        return sqlException.getSQLException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw this.jdbcMethodNotImplemented();
    }

    @Override
    public void completeExecuteCall(Sqlca sqlca, Cursor cursor) {
        super.completeExecuteCall(sqlca, cursor);
        if (cursor == null) {
            return;
        }
        if (this.parameterMetaData_ == null) {
            return;
        }
        int n2 = cursor.columns_;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            if (this.parameterMetaData_.sqlxParmmode_[i2] != 2) continue;
            int n3 = i2 + 1;
            try {
                object = cursor.isNull_[i2] ? null : cursor.getObject(n3);
            }
            catch (SqlException sqlException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(sqlException.getMessage());
                illegalArgumentException.initCause(sqlException);
                throw illegalArgumentException;
            }
            if (this.parameterMetaData_.types_[i2] == 5 && object instanceof Integer) {
                object = ((Integer)object).shortValue();
            }
            this.setInput(n3, object);
        }
    }

    @Override
    protected String getJdbcStatementInterfaceName() {
        return "java.sql.CallableStatement";
    }

    private void checkGetterPreconditions(int n2) throws SqlException {
        super.checkForValidParameterIndex(n2);
        this.checkForValidOutParameter(n2);
    }

    private void checkForValidOutParameter(int n2) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[n2 - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ091.S"), n2);
        }
    }

    private void setWasNull(int n2) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[n2 - 1] ? 1 : 2);
    }

    SQLException jdbcMethodNotImplemented() throws SQLException {
        try {
            super.checkForClosedStatement();
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"), new Object[0]).getSQLException();
    }
}

