/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.SqlException;

class ClobOutputStream
extends OutputStream {
    private ClientClob clob_;
    private long offset_;

    ClobOutputStream(ClientClob clientClob, long l2) throws SqlException {
        this.clob_ = clientClob;
        this.offset_ = l2;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.writeBytes(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.writeBytes(byArray2);
    }

    private void writeBytes(byte[] byArray) throws IOException {
        String string = new String(byArray, "ISO-8859-1");
        this.clob_.reInitForNonLocator(this.clob_.string_.substring(0, (int)this.offset_ - 1).concat(string));
        this.offset_ += (long)byArray.length;
    }
}

