/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.Typdef;

public class DateTime {
    private static final int dateRepresentationLength = 10;
    private static final int timeRepresentationLength = 8;
    private static final int timestampRepresentationLength = 29;

    private DateTime() {
    }

    static final java.sql.Date dateBytesToDate(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 10, charset);
        if (string.charAt(4) != '-') {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("22018", new Object[0]));
        }
        int n3 = 0;
        int n4 = 5;
        int n5 = 8;
        int n6 = 48;
        int n7 = 1000 * (string.charAt(n3) - n6) + 100 * (string.charAt(n3 + 1) - n6) + 10 * (string.charAt(n3 + 2) - n6) + (string.charAt(n3 + 3) - n6);
        int n8 = 10 * (string.charAt(n4) - n6) + (string.charAt(n4 + 1) - n6) - 1;
        int n9 = 10 * (string.charAt(n5) - n6) + (string.charAt(n5 + 1) - n6);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n7, n8, n9);
        return new java.sql.Date(calendar2.getTimeInMillis());
    }

    static final Time timeBytesToTime(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 8, charset);
        int n3 = 48;
        int n4 = 10 * (string.charAt(0) - n3) + (string.charAt(1) - n3);
        int n5 = 10 * (string.charAt(3) - n3) + (string.charAt(4) - n3);
        int n6 = 10 * (string.charAt(6) - n3) + (string.charAt(7) - n3);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(1970, 0, 1, n4, n5, n6);
        return new Time(calendar2.getTimeInMillis());
    }

    static final Timestamp timestampBytesToTimestamp(byte[] byArray, int n2, Calendar calendar, Charset charset, boolean bl) {
        String string = new String(byArray, n2, DateTime.getTimestampLength(bl), charset);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        int n3 = DateTime.parseTimestampString(string, calendar2, bl);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(n3);
        return timestamp;
    }

    private static int parseTimestampString(String string, Calendar calendar, boolean bl) {
        int n2 = 48;
        calendar.set(1, 1000 * (string.charAt(0) - n2) + 100 * (string.charAt(1) - n2) + 10 * (string.charAt(2) - n2) + (string.charAt(3) - n2));
        calendar.set(2, 10 * (string.charAt(5) - n2) + (string.charAt(6) - n2) - 1);
        calendar.set(5, 10 * (string.charAt(8) - n2) + (string.charAt(9) - n2));
        calendar.set(10, 10 * (string.charAt(11) - n2) + (string.charAt(12) - n2));
        calendar.set(12, 10 * (string.charAt(14) - n2) + (string.charAt(15) - n2));
        calendar.set(13, 10 * (string.charAt(17) - n2) + (string.charAt(18) - n2));
        int n3 = 100000000 * (string.charAt(20) - n2) + 10000000 * (string.charAt(21) - n2) + 1000000 * (string.charAt(22) - n2) + 100000 * (string.charAt(23) - n2) + 10000 * (string.charAt(24) - n2) + 1000 * (string.charAt(25) - n2);
        if (bl) {
            n3 += 100 * (string.charAt(26) - n2);
            n3 += 10 * (string.charAt(27) - n2);
            n3 += string.charAt(28) - n2;
        }
        calendar.set(14, n3 / 1000000);
        return n3;
    }

    public static final int dateToDateBytes(byte[] byArray, int n2, DateTimeValue dateTimeValue) throws SqlException {
        int n3 = dateTimeValue.getYear();
        if (n3 > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), n3, "9999");
        }
        int n4 = dateTimeValue.getMonth() + 1;
        int n5 = dateTimeValue.getDayOfMonth();
        char[] cArray = new char[10];
        int n6 = 48;
        cArray[0] = (char)(n3 / 1000 + n6);
        cArray[1] = (char)(n3 % 1000 / 100 + n6);
        cArray[2] = (char)(n3 % 100 / 10 + n6);
        cArray[3] = (char)(n3 % 10 + n6);
        cArray[4] = 45;
        cArray[5] = (char)(n4 / 10 + n6);
        cArray[6] = (char)(n4 % 10 + n6);
        cArray[7] = 45;
        cArray[8] = (char)(n5 / 10 + n6);
        cArray[9] = (char)(n5 % 10 + n6);
        byte[] byArray2 = new String(cArray).getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(byArray2, 0, byArray, n2, 10);
        return 10;
    }

    public static final int timeToTimeBytes(byte[] byArray, int n2, DateTimeValue dateTimeValue) {
        int n3 = dateTimeValue.getHours();
        int n4 = dateTimeValue.getMinutes();
        int n5 = dateTimeValue.getSeconds();
        char[] cArray = new char[8];
        int n6 = 48;
        cArray[0] = (char)(n3 / 10 + n6);
        cArray[1] = (char)(n3 % 10 + n6);
        cArray[2] = 58;
        cArray[3] = (char)(n4 / 10 + n6);
        cArray[4] = (char)(n4 % 10 + n6);
        cArray[5] = 58;
        cArray[6] = (char)(n5 / 10 + n6);
        cArray[7] = (char)(n5 % 10 + n6);
        byte[] byArray2 = new String(cArray).getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(byArray2, 0, byArray, n2, 8);
        return 8;
    }

    public static final int timestampToTimestampBytes(byte[] byArray, int n2, DateTimeValue dateTimeValue, boolean bl) throws SqlException {
        int n3 = dateTimeValue.getYear();
        if (n3 > 9999) {
            throw new SqlException(null, new ClientMessageId("22003.S.1"), n3, "9999");
        }
        int n4 = dateTimeValue.getMonth() + 1;
        int n5 = dateTimeValue.getDayOfMonth();
        int n6 = dateTimeValue.getHours();
        int n7 = dateTimeValue.getMinutes();
        int n8 = dateTimeValue.getSeconds();
        int n9 = dateTimeValue.getNanos() / 1000;
        int n10 = DateTime.getTimestampLength(bl);
        char[] cArray = new char[n10];
        int n11 = 48;
        cArray[0] = (char)(n3 / 1000 + n11);
        cArray[1] = (char)(n3 % 1000 / 100 + n11);
        cArray[2] = (char)(n3 % 100 / 10 + n11);
        cArray[3] = (char)(n3 % 10 + n11);
        cArray[4] = 45;
        cArray[5] = (char)(n4 / 10 + n11);
        cArray[6] = (char)(n4 % 10 + n11);
        cArray[7] = 45;
        cArray[8] = (char)(n5 / 10 + n11);
        cArray[9] = (char)(n5 % 10 + n11);
        cArray[10] = 45;
        cArray[11] = (char)(n6 / 10 + n11);
        cArray[12] = (char)(n6 % 10 + n11);
        cArray[13] = 46;
        cArray[14] = (char)(n7 / 10 + n11);
        cArray[15] = (char)(n7 % 10 + n11);
        cArray[16] = 46;
        cArray[17] = (char)(n8 / 10 + n11);
        cArray[18] = (char)(n8 % 10 + n11);
        cArray[19] = 46;
        cArray[20] = (char)(n9 / 100000 + n11);
        cArray[21] = (char)(n9 % 100000 / 10000 + n11);
        cArray[22] = (char)(n9 % 10000 / 1000 + n11);
        cArray[23] = (char)(n9 % 1000 / 100 + n11);
        cArray[24] = (char)(n9 % 100 / 10 + n11);
        cArray[25] = (char)(n9 % 10 + n11);
        if (bl) {
            int n12 = dateTimeValue.getNanos() % 1000;
            cArray[26] = (char)(n12 / 100 + n11);
            cArray[27] = (char)(n12 % 100 / 10 + n11);
            cArray[28] = (char)(n12 % 10 + n11);
        }
        String string = new String(cArray);
        byte[] byArray2 = string.getBytes(Typdef.UTF8ENCODING);
        System.arraycopy(byArray2, 0, byArray, n2, n10);
        return n10;
    }

    static final Timestamp dateBytesToTimestamp(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 10, charset);
        int n3 = 0;
        int n4 = 5;
        int n5 = 8;
        int n6 = 48;
        int n7 = 1000 * (string.charAt(n3) - n6) + 100 * (string.charAt(n3 + 1) - n6) + 10 * (string.charAt(n3 + 2) - n6) + (string.charAt(n3 + 3) - n6);
        int n8 = 10 * (string.charAt(n4) - n6) + (string.charAt(n4 + 1) - n6) - 1;
        int n9 = 10 * (string.charAt(n5) - n6) + (string.charAt(n5 + 1) - n6);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n7, n8, n9, 0, 0, 0);
        Timestamp timestamp = new Timestamp(calendar2.getTimeInMillis());
        timestamp.setNanos(0);
        return timestamp;
    }

    static final Timestamp timeBytesToTimestamp(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 8, charset);
        int n3 = 48;
        int n4 = 10 * (string.charAt(0) - n3) + (string.charAt(1) - n3);
        int n5 = 10 * (string.charAt(3) - n3) + (string.charAt(4) - n3);
        int n6 = 10 * (string.charAt(6) - n3) + (string.charAt(7) - n3);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.setTime(new Date());
        calendar2.set(11, n4);
        calendar2.set(12, n5);
        calendar2.set(13, n6);
        calendar2.set(14, 0);
        return new Timestamp(calendar2.getTimeInMillis());
    }

    static final java.sql.Date timestampBytesToDate(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 29, charset);
        int n3 = 48;
        int n4 = 1000 * (string.charAt(0) - n3) + 100 * (string.charAt(1) - n3) + 10 * (string.charAt(2) - n3) + (string.charAt(3) - n3);
        int n5 = 10 * (string.charAt(5) - n3) + (string.charAt(6) - n3) - 1;
        int n6 = 10 * (string.charAt(8) - n3) + (string.charAt(9) - n3);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        calendar2.set(n4, n5, n6);
        return new java.sql.Date(calendar2.getTimeInMillis());
    }

    static final Time timestampBytesToTime(byte[] byArray, int n2, Calendar calendar, Charset charset) {
        String string = new String(byArray, n2, 29, charset);
        Calendar calendar2 = DateTime.getCleanCalendar(calendar);
        DateTime.parseTimestampString(string, calendar2, false);
        calendar2.set(1970, 0, 1);
        return new Time(calendar2.getTimeInMillis());
    }

    private static Calendar getCleanCalendar(Calendar calendar) {
        if (calendar != null) {
            calendar.clear();
            return calendar;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        return gregorianCalendar;
    }

    public static int getTimestampLength(boolean bl) {
        return bl ? 29 : 26;
    }
}

