/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;

public final class Utils {
    private static byte[][] tenRadixArr = new byte[][]{{1}, {10}, {100}, {3, -24}, {39, 16}, {1, -122, -96}, {15, 66, 64}, {-104, -106, -128}, {5, -11, -31, 0}, {59, -102, -54, 0}, {2, 84, 11, -28, 0}, {23, 72, 118, -24, 0}, {-24, -44, -91, 16, 0}, {9, 24, 78, 114, -96, 0}, {90, -13, 16, 122, 64, 0}, {3, -115, 126, -92, -58, -128, 0}, {35, -122, -14, 111, -63, 0, 0}, {1, 99, 69, 120, 93, -118, 0, 0}, {13, -32, -74, -77, -89, 100, 0, 0}, {-118, -57, 35, 4, -119, -24, 0, 0}, {5, 107, -57, 94, 45, 99, 16, 0, 0}, {54, 53, -55, -83, -59, -34, -96, 0, 0}, {2, 30, 25, -32, -55, -70, -78, 64, 0, 0}, {21, 45, 2, -57, -31, 74, -10, -128, 0, 0}, {-45, -62, 27, -50, -52, -19, -95, 0, 0, 0}, {8, 69, -107, 22, 20, 1, 72, 74, 0, 0, 0}, {82, -73, -46, -36, -56, 12, -46, -28, 0, 0, 0}, {3, 59, 46, 60, -97, -48, -128, 60, -24, 0, 0, 0}, {32, 79, -50, 94, 62, 37, 2, 97, 16, 0, 0, 0}, {1, 67, 30, 15, -82, 109, 114, 23, -54, -96, 0, 0, 0}, {12, -97, 44, -100, -48, 70, 116, -19, -22, 64, 0, 0, 0}, {126, 55, -66, 32, 34, -64, -111, 75, 38, -128, 0, 0, 0}};

    static String quoteSqlIdentifier(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuffer.append('\"');
            }
            stringBuffer.append(c2);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    static String getStringFromBytes(byte[] byArray) {
        if (byArray == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 6 + 4);
        stringBuffer.append("{ ");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(byArray[i2] & 0xFF));
            if (i2 == byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    static String getStringFromInts(int[] nArray) {
        if (nArray == null) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuffer.append(String.valueOf(nArray[i2]));
            if (i2 == nArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static int computeBigDecimalPrecision(BigDecimal bigDecimal) {
        byte[] byArray = bigDecimal.unscaledValue().abs().toByteArray();
        if (Utils.byteArrayCmp(byArray, tenRadixArr[tenRadixArr.length - 1]) >= 0) {
            throw new IllegalArgumentException(SqlException.getMessageUtil().getTextMessage("J105", new Object[0]));
        }
        int n2 = 0;
        int n3 = tenRadixArr.length - 1;
        int n4 = (n3 + n2) / 2;
        do {
            int n5;
            if ((n5 = Utils.byteArrayCmp(byArray, tenRadixArr[n4])) == 1) {
                n2 = n4;
                continue;
            }
            if (n5 != -1) break;
            n3 = n4;
        } while ((n4 = (n3 + n2) / 2) != n2);
        return n4 + 1;
    }

    private static int byteArrayCmp(byte[] byArray, byte[] byArray2) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (byArray.length > byArray2.length) {
            n5 = byArray.length - byArray2.length;
            for (n4 = 0; n4 < n5; ++n4) {
                if (byArray[n4] == 0) continue;
                return 1;
            }
            n3 = byArray2.length;
        } else if (byArray.length < byArray2.length) {
            n5 = byArray2.length - byArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                if (byArray2[n2] == 0) continue;
                return -1;
            }
            n3 = byArray.length;
        } else {
            n3 = byArray.length;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            int n6 = byArray[n4 + n5] & 0xFF;
            int n7 = byArray2[n2 + n5] & 0xFF;
            if (n6 > n7) {
                return 1;
            }
            if (n6 >= n7) continue;
            return -1;
        }
        return 0;
    }

    public static int getSqlcodeFromSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        return sqlca.getSqlCode();
    }

    public static int[] squashLongs(long[] lArray) {
        int n2 = lArray == null ? 0 : lArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = (int)lArray[i2];
        }
        return nArray;
    }

    public static SQLException accumulateSQLException(SQLException sQLException, SQLException sQLException2) {
        if (sQLException2 == null) {
            return sQLException;
        }
        sQLException2.setNextException(sQLException);
        return sQLException2;
    }

    public static SqlException accumulateSQLException(SqlException sqlException, SqlException sqlException2) {
        if (sqlException2 == null) {
            return sqlException;
        }
        sqlException2.setNextException(sqlException);
        return sqlException2;
    }

    public static boolean isSqlTypeNullable(int n2) {
        return (n2 | 1) == n2;
    }

    static int getNonNullableSqlType(int n2) {
        return n2 & 0xFFFFFFFE;
    }
}

