/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.derby.client.net.PublicBufferOutputStream;

public final class EncodedInputStream
extends InputStream {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    private static final int BUFFERED_CHAR_LEN = 1024;
    private static final ByteArrayInputStream suspendMarker = new ByteArrayInputStream(new byte[0]);
    private Reader reader_;
    private final char[] decodedBuffer_;
    private OutputStreamWriter encodedStreamWriter_;
    private PublicBufferOutputStream encodedOutputStream_;
    private ByteArrayInputStream encodedInputStream_;

    public static EncodedInputStream createUTF8Stream(Reader reader) {
        return new EncodedInputStream(reader, UTF_8, 1024, 3072);
    }

    static EncodedInputStream createUTF16BEStream(Reader reader) {
        return new EncodedInputStream(reader, UTF_16BE, 1024, 2048);
    }

    private EncodedInputStream(Reader reader, Charset charset, int n2, int n3) {
        this.reader_ = reader;
        this.decodedBuffer_ = new char[n2];
        this.encodedOutputStream_ = new PublicBufferOutputStream(n3);
        this.encodedStreamWriter_ = new OutputStreamWriter((OutputStream)this.encodedOutputStream_, charset);
        this.encodedInputStream_ = suspendMarker;
    }

    private ByteArrayInputStream reEncode(Reader reader) throws IOException {
        int n2;
        while ((n2 = reader.read(this.decodedBuffer_, 0, this.decodedBuffer_.length)) == 0) {
        }
        if (n2 < 0) {
            return null;
        }
        this.encodedOutputStream_.reset();
        this.encodedStreamWriter_.write(this.decodedBuffer_, 0, n2);
        this.encodedStreamWriter_.flush();
        int n3 = this.encodedOutputStream_.size();
        return new ByteArrayInputStream(this.encodedOutputStream_.getBuffer(), 0, n3);
    }

    @Override
    public int available() throws IOException {
        if (this.encodedInputStream_ == suspendMarker) {
            this.encodedInputStream_ = this.reEncode(this.reader_);
        }
        if (this.encodedInputStream_ == null) {
            return 0;
        }
        return this.encodedInputStream_.available();
    }

    @Override
    public void close() throws IOException {
        if (this.encodedInputStream_ != null) {
            this.encodedInputStream_.close();
            this.encodedInputStream_ = null;
        }
        if (this.reader_ != null) {
            this.reader_.close();
            this.reader_ = null;
        }
        if (this.encodedStreamWriter_ != null) {
            this.encodedStreamWriter_.close();
            this.encodedStreamWriter_ = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.encodedInputStream_ == suspendMarker) {
            this.encodedInputStream_ = this.reEncode(this.reader_);
        }
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        int n2 = this.encodedInputStream_.read();
        if (n2 > -1) {
            return n2;
        }
        this.encodedInputStream_ = this.reEncode(this.reader_);
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        return this.encodedInputStream_.read();
    }
}

