/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.ConnectionRequestInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.Request;
import org.apache.derby.client.net.Typdef;

class NetConnectionRequest
extends Request
implements ConnectionRequestInterface {
    NetConnectionRequest(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    void writeExchangeServerAttributes(String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) throws SqlException {
        this.buildEXCSAT(string, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    void writeAccessSecurity(int n2, String string, byte[] byArray) throws SqlException {
        this.buildACCSEC(n2, string, byArray);
    }

    void writeSecurityCheck(int n2, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SqlException {
        this.buildSECCHK(n2, string, string2, string3, byArray, byArray2);
    }

    void writeAccessDatabase(String string, boolean bl, byte[] byArray, byte[] byArray2, Typdef typdef) throws SqlException {
        this.buildACCRDB(string, bl, byArray, byArray2, typdef);
    }

    @Override
    public void writeCommitSubstitute(NetConnection netConnection) throws SqlException {
        this.buildDummyEXCSAT();
    }

    @Override
    public void writeLocalCommit(NetConnection netConnection) throws SqlException {
        this.buildRDBCMM();
    }

    @Override
    public void writeLocalRollback(NetConnection netConnection) throws SqlException {
        this.buildRDBRLLBCK();
    }

    @Override
    public void writeLocalXAStart(NetConnection netConnection) throws SqlException {
    }

    @Override
    public void writeLocalXACommit(NetConnection netConnection) throws SqlException {
    }

    @Override
    public void writeLocalXARollback(NetConnection netConnection) throws SqlException {
    }

    public void writeXaStartUnitOfWork(NetConnection netConnection) throws SqlException {
    }

    public void writeXaEndUnitOfWork(NetConnection netConnection) throws SqlException {
    }

    protected void writeXaPrepare(NetConnection netConnection) throws SqlException {
    }

    protected void writeXaCommit(NetConnection netConnection, Xid xid) throws SqlException {
    }

    protected void writeXaRollback(NetConnection netConnection, Xid xid) throws SqlException {
    }

    protected void writeXaRecover(NetConnection netConnection, int n2) throws SqlException {
    }

    protected void writeXaForget(NetConnection netConnection, Xid xid) throws SqlException {
    }

    public void writeSYNCType(int n2, int n3) {
        this.writeScalar1Byte(n2, n3);
    }

    public void writeForget(int n2, int n3) {
    }

    public void writeReleaseConversation(int n2, int n3) {
    }

    void writeNullXID(int n2) {
    }

    void writeXID(int n2, Xid xid) throws SqlException {
    }

    void writeXAFlags(int n2, int n3) {
    }

    void writeXATimeout(int n2, long l2) {
    }

    private void buildRDBCMM() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8206);
    }

    private void buildRDBRLLBCK() throws SqlException {
        this.createCommand();
        this.writeLengthCodePoint(4, 8207);
    }

    private void buildEXCSAT(String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.buildEXTNAM(string);
        this.buildSRVNAM("Derby");
        this.buildSRVRLSLV();
        this.buildMGRLVLLS(n2, n3, n4, n5, n8, n9, n10, n11);
        this.buildSRVCLSNM();
        this.updateLengthBytes();
    }

    private void buildDummyEXCSAT() throws SqlException {
        this.createCommand();
        this.markLengthBytes(4161);
        this.updateLengthBytes();
    }

    private void buildACCSEC(int n2, String string, byte[] byArray) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4205);
        this.buildSECMEC(n2);
        this.buildRDBNAM(string, true);
        if (byArray != null) {
            this.buildSECTKN(byArray);
        }
        this.updateLengthBytes();
    }

    private void buildSECCHK(int n2, String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4206);
        this.buildSECMEC(n2);
        this.buildRDBNAM(string, false);
        if (string2 != null) {
            this.buildUSRID(string2);
        }
        if (string3 != null) {
            this.buildPASSWORD(string3);
        }
        if (byArray != null) {
            this.buildSECTKN(byArray);
        }
        if (byArray2 != null) {
            this.buildSECTKN(byArray2);
        }
        this.updateLengthBytes();
    }

    private void buildACCRDB(String string, boolean bl, byte[] byArray, byte[] byArray2, Typdef typdef) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8193);
        this.buildRDBNAM(string, true);
        this.buildRDBACCCL();
        this.buildPRDID();
        this.buildPRDDTA(byArray2);
        this.buildTYPDEFNAM(typdef.getTypdefnam());
        if (byArray == null) {
            this.netAgent_.netConnection_.constructCrrtkn();
        }
        this.buildCRRTKN(this.netAgent_.netConnection_.crrtkn_);
        this.buildTYPDEFOVR(typdef.isCcsidSbcSet(), typdef.getCcsidSbc(), typdef.isCcsidDbcSet(), typdef.getCcsidDbc(), typdef.isCcsidMbcSet(), typdef.getCcsidMbc());
        this.buildRDBALWUPD(bl);
        this.updateLengthBytes();
    }

    void buildSYNCCTLMigrate() throws SqlException {
    }

    void buildSYNCCTLCommit(int n2, Xid xid) throws SqlException {
    }

    void buildSYNCCTLRollback(int n2) throws SqlException {
    }

    private void buildEXTNAM(String string) throws SqlException {
        int n2 = Math.min(string.length(), 255);
        this.writeScalarString(4446, string.substring(0, n2), 0, 255, "08001.C.13");
    }

    private void buildSRVNAM(String string) throws SqlException {
        int n2 = Math.min(string.length(), 255);
        this.writeScalarString(4461, string.substring(0, n2), 0, 255, "08001.C.14");
    }

    private void buildSRVRLSLV() throws SqlException {
        this.writeScalarString(4442, NetConfiguration.SRVRLSLV);
    }

    private void buildSRVCLSNM() throws SqlException {
        this.writeScalarString(4423, "QDERBY/JVM");
    }

    private void buildSECMEC(int n2) throws SqlException {
        this.writeScalar2Bytes(4514, n2);
    }

    private void buildRDBNAM(String string, boolean bl) throws SqlException {
        if (bl) {
            try {
                this.netAgent_.getCurrentCcsidManager().convertFromJavaString(string, this.netAgent_);
            }
            catch (SqlException sqlException) {
                this.netAgent_.exceptionConvertingRdbnam = sqlException;
                return;
            }
        }
        int n2 = 1024;
        this.writeScalarString(8464, string, 18, n2, "08001.C.9");
    }

    private void buildSECTKN(byte[] byArray) throws SqlException {
        if (byArray.length > 32763) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.10"), new Object[0]);
        }
        this.writeScalarBytes(4572, byArray);
    }

    private void buildUSRID(String string) throws SqlException {
        this.writeScalarString(4512, string, 0, 255, "08001.C.11");
    }

    private void buildPASSWORD(String string) throws SqlException {
        int n2 = string.length();
        if (n2 == 0) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.12"), new Object[0]);
        }
        if (this.netAgent_.logWriter_ != null) {
            this.passwordIncluded_ = true;
            this.passwordStart_ = this.buffer.position() + 4;
        }
        this.writeScalarString(4513, string, 0, 255, "08001.C.12");
        if (this.netAgent_.logWriter_ != null) {
            this.passwordLength_ = this.buffer.position() - this.passwordStart_;
        }
    }

    private void buildRDBACCCL() throws SqlException {
        this.writeScalar2Bytes(8463, 9223);
    }

    private void buildPRDID() throws SqlException {
        this.writeScalarString(4398, NetConfiguration.PRDID);
    }

    private void buildPRDDTA(byte[] byArray) throws SqlException {
        int n2 = (byArray[0] & 0xFF) + 1;
        this.writeScalarBytes(8452, byArray, 0, n2);
    }

    private void buildTYPDEFNAM(String string) throws SqlException {
        this.writeScalarString(47, string);
    }

    private void buildTYPDEFOVR(boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4) throws SqlException {
        this.markLengthBytes(53);
        if (bl) {
            this.writeScalar2Bytes(4508, n2);
        }
        if (bl2) {
            this.writeScalar2Bytes(4509, n3);
        }
        if (bl3) {
            this.writeScalar2Bytes(4510, n4);
        }
        this.updateLengthBytes();
    }

    private void buildMGRLVLLS(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws SqlException {
        this.markLengthBytes(5124);
        this.writeCodePoint4Bytes(5123, n2);
        this.writeCodePoint4Bytes(9223, n3);
        this.writeCodePoint4Bytes(9231, n4);
        this.writeCodePoint4Bytes(5184, n5);
        this.writeCodePoint4Bytes(7176, n9);
        if (this.netAgent_.netConnection_.isXAConnection()) {
            if (n6 != 0) {
                this.writeCodePoint4Bytes(7169, n6);
            }
            if (n7 != 0) {
                this.writeCodePoint4Bytes(5312, n7);
            }
            if (n8 != 0) {
                this.writeCodePoint4Bytes(5313, n8);
            }
        }
        this.updateLengthBytes();
    }

    private void buildCRRTKN(byte[] byArray) throws SqlException {
        this.writeScalarBytes(8501, byArray);
    }

    private void buildRDBALWUPD(boolean bl) throws SqlException {
        if (bl) {
            this.writeScalar1Byte(8474, -16);
        }
    }
}

