/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;

public final class ArrayInputStream
extends InputStream
implements LimitObjectInput {
    private byte[] pageData;
    private int start;
    private int end;
    private int position;
    private ErrorObjectInput oi;

    public ArrayInputStream() {
        this(ArrayUtil.EMPTY_BYTE_ARRAY);
    }

    public ArrayInputStream(byte[] byArray) {
        this.setData(byArray);
        this.oi = new FormatIdInputStream(this);
    }

    public void setData(byte[] byArray) {
        this.pageData = byArray;
        this.position = 0;
        this.start = 0;
        this.end = byArray.length;
    }

    public byte[] getData() {
        return this.pageData;
    }

    @Override
    public int read() throws IOException {
        if (this.position == this.end) {
            return -1;
        }
        return this.pageData[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.available();
        if (n3 > n4) {
            if (n4 == 0) {
                return -1;
            }
            n3 = n4;
        }
        System.arraycopy(this.pageData, this.position, byArray, n2, n3);
        this.position += n3;
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = Math.min(l2, (long)this.available());
        this.position = (int)((long)this.position + l3);
        return l3;
    }

    public int getPosition() {
        return this.position;
    }

    public final void setPosition(int n2) throws IOException {
        if (n2 < this.start || n2 >= this.end) {
            throw new EOFException();
        }
        this.position = n2;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.position;
    }

    public void setLimit(int n2, int n3) throws IOException {
        this.start = n2;
        this.end = n2 + n3;
        this.position = this.start;
        if (n2 < 0 || n3 < 0 || this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    @Override
    public final void setLimit(int n2) throws IOException {
        this.start = this.position;
        this.end = this.position + n2;
        if (this.end > this.pageData.length) {
            this.position = 0;
            this.end = 0;
            this.start = 0;
            throw new EOFException();
        }
    }

    @Override
    public final int clearLimit() {
        this.start = 0;
        int n2 = this.end - this.position;
        this.end = this.pageData.length;
        return n2;
    }

    @Override
    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > this.available()) {
            throw new EOFException();
        }
        System.arraycopy(this.pageData, this.position, byArray, n2, n3);
        this.position += n3;
    }

    @Override
    public final int skipBytes(int n2) throws IOException {
        return (int)this.skip(n2);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++];
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        if (this.position == this.end) {
            throw new EOFException();
        }
        return this.pageData[this.position++] & 0xFF;
    }

    @Override
    public final short readShort() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        if (n2 >= this.end - 1) {
            throw new EOFException();
        }
        int n3 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.position = n2;
        return (short)n3;
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        if (n2 >= this.end - 1) {
            throw new EOFException();
        }
        int n3 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.position = n2;
        return n3;
    }

    @Override
    public final char readChar() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        if (n2 >= this.end - 1) {
            throw new EOFException();
        }
        int n3 = (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.position = n2;
        return (char)n3;
    }

    @Override
    public final int readInt() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        if (n2 >= this.end - 3) {
            throw new EOFException();
        }
        int n3 = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        this.position = n2;
        return n3;
    }

    @Override
    public final long readLong() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        if (n2 >= this.end - 7) {
            throw new EOFException();
        }
        long l2 = (long)(byArray[n2++] & 0xFF) << 56 | (long)(byArray[n2++] & 0xFF) << 48 | (long)(byArray[n2++] & 0xFF) << 40 | (long)(byArray[n2++] & 0xFF) << 32 | (long)(byArray[n2++] & 0xFF) << 24 | (long)(byArray[n2++] & 0xFF) << 16 | (long)(byArray[n2++] & 0xFF) << 8 | (long)(byArray[n2++] & 0xFF);
        this.position = n2;
        return l2;
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final String readLine() throws IOException {
        return this.oi.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.oi.readUTF();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int readDerbyUTF(char[][] cArray, int n2) throws IOException {
        int n3;
        byte[] byArray = this.pageData;
        int n4 = this.end;
        int n5 = this.position;
        if (n2 != 0) {
            if (n2 > n4 - n5) throw new EOFException();
            n3 = n2;
        } else {
            n3 = n4 - n5;
        }
        char[] cArray2 = cArray[0];
        if (cArray2 == null || n3 > cArray2.length) {
            cArray2 = new char[n3];
            cArray[0] = cArray2;
        }
        n4 = n5 + n3;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            int n8;
            if (((n8 = byArray[n5++] & 0xFF) & 0x80) == 0) {
                cArray2[n6++] = (char)n8;
                continue;
            }
            if ((n8 & 0x60) == 64) {
                if (n5 >= n4) {
                    throw new UTFDataFormatException();
                }
                if (((n7 = byArray[n5++] & 0xFF) & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                cArray2[n6++] = (char)((n8 & 0x1F) << 6 | n7 & 0x3F);
                continue;
            }
            if ((n8 & 0x70) != 96) throw new UTFDataFormatException();
            if (n5 + 1 >= n4) {
                throw new UTFDataFormatException();
            }
            n7 = byArray[n5++] & 0xFF;
            int n9 = byArray[n5++] & 0xFF;
            if (n8 == 224 && n7 == 0 && n9 == 0 && n2 == 0) break;
            if ((n7 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                throw new UTFDataFormatException();
            }
            cArray2[n6++] = (char)((n8 & 0xF) << 12 | (n7 & 0x3F) << 6 | (n9 & 0x3F) << 0);
        }
        this.position = n5;
        return n6;
    }

    public final int readCompressedInt() throws IOException {
        int n2 = this.position;
        byte[] byArray = this.pageData;
        try {
            int n3 = byArray[n2++];
            if ((n3 & 0xFFFFFFC0) != 0) {
                n3 = (n3 & 0x80) == 0 ? (n3 & 0x3F) << 8 | byArray[n2++] & 0xFF : (n3 & 0x7F) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            }
            this.position = n2;
            return n3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }

    public final long readCompressedLong() throws IOException {
        try {
            int n2 = this.position;
            byte[] byArray = this.pageData;
            byte by = byArray[n2++];
            long l2 = (by & 0xFFFFFFC0) == 0 ? (long)(by << 8 | byArray[n2++] & 0xFF) : ((by & 0x80) == 0 ? (long)((by & 0x3F) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF) : (long)(by & 0x7F) << 56 | (long)(byArray[n2++] & 0xFF) << 48 | (long)(byArray[n2++] & 0xFF) << 40 | (long)(byArray[n2++] & 0xFF) << 32 | (long)(byArray[n2++] & 0xFF) << 24 | (long)(byArray[n2++] & 0xFF) << 16 | (long)(byArray[n2++] & 0xFF) << 8 | (long)(byArray[n2++] & 0xFF));
            this.position = n2;
            return l2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        return this.oi.readObject();
    }

    @Override
    public String getErrorInfo() {
        return this.oi.getErrorInfo();
    }

    @Override
    public Exception getNestedException() {
        return this.oi.getNestedException();
    }
}

