/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ApplicationObjectInputStream;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.services.io.ErrorInfo;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.Resetable;

public final class FormatIdInputStream
extends DataInputStream
implements ErrorObjectInput,
Resetable,
CloneableStream {
    protected ClassFactory cf;
    private ErrorInfo errorInfo;
    private Exception myNestedException;

    public FormatIdInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        this.setErrorInfo(null);
        int n2 = FormatIdUtil.readFormatIdInteger(this);
        if (n2 == 0) {
            return null;
        }
        if (n2 == 1) {
            return this.readUTF();
        }
        try {
            if (n2 == 2) {
                ObjectInputStream objectInputStream = this.getObjectStream();
                try {
                    Object object = objectInputStream.readObject();
                    return object;
                }
                catch (IOException iOException) {
                    throw this.handleReadError(iOException, objectInputStream);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw this.handleReadError(classNotFoundException, objectInputStream);
                }
                catch (LinkageError linkageError) {
                    throw this.handleReadError(linkageError, objectInputStream);
                }
                catch (ClassCastException classCastException) {
                    throw this.handleReadError(classCastException, objectInputStream);
                }
            }
            try {
                boolean bl;
                Formatable formatable = (Formatable)Monitor.newInstanceFromIdentifier(n2);
                if (formatable instanceof Storable && (bl = this.readBoolean())) {
                    Storable storable = (Storable)formatable;
                    storable.restoreToNull();
                    return storable;
                }
                formatable.readExternal(this);
                return formatable;
            }
            catch (StandardException standardException) {
                throw new ClassNotFoundException(standardException.toString());
            }
        }
        catch (ClassCastException classCastException) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(classCastException.toString());
            streamCorruptedException.initCause(classCastException);
            throw streamCorruptedException;
        }
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public String getErrorInfo() {
        if (this.errorInfo == null) {
            return "";
        }
        return this.errorInfo.getErrorInfo();
    }

    @Override
    public Exception getNestedException() {
        if (this.myNestedException != null) {
            return null;
        }
        if (this.errorInfo == null) {
            return null;
        }
        return this.errorInfo.getNestedException();
    }

    private void setErrorInfo(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
    }

    private <T extends Throwable> T handleReadError(T t2, ObjectInputStream objectInputStream) {
        if (objectInputStream instanceof ErrorInfo) {
            this.setErrorInfo((ErrorInfo)((Object)objectInputStream));
        }
        return t2;
    }

    ClassFactory getClassFactory() {
        ClassFactoryContext classFactoryContext;
        if (this.cf == null && (classFactoryContext = (ClassFactoryContext)FormatIdInputStream.getContextOrNull("ClassFactoryContext")) != null) {
            this.cf = classFactoryContext.getClassFactory();
        }
        return this.cf;
    }

    private ObjectInputStream getObjectStream() throws IOException {
        return this.getClassFactory() == null ? new ObjectInputStream(this) : new ApplicationObjectInputStream(this, this.cf);
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.in)).resetStream();
    }

    @Override
    public void initStream() throws StandardException {
        ((Resetable)((Object)this.in)).initStream();
    }

    @Override
    public void closeStream() {
        ((Resetable)((Object)this.in)).closeStream();
    }

    @Override
    public InputStream cloneStream() {
        InputStream inputStream = ((CloneableStream)((Object)this.in)).cloneStream();
        return new FormatIdInputStream(inputStream);
    }

    private static Context getContextOrNull(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }
}

