/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;

public final class FormatableBitSet
implements Formatable,
Cloneable {
    private byte[] value;
    private byte bitsInLastByte;
    private transient int lengthAsBits;

    private final void checkPosition(int n2) {
        if (n2 < 0 || this.lengthAsBits <= n2) {
            throw new IllegalArgumentException("Bit position " + n2 + " is outside the legal range");
        }
    }

    private static int udiv8(int n2) {
        return n2 >> 3;
    }

    private static byte umod8(int n2) {
        return (byte)(n2 & 7);
    }

    private static int umul8(int n2) {
        return n2 << 3;
    }

    public FormatableBitSet() {
        this.value = ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public FormatableBitSet(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bit set size " + n2 + " is not allowed");
        }
        this.initializeBits(n2);
    }

    private void initializeBits(int n2) {
        int n3 = FormatableBitSet.numBytesFromBits(n2);
        this.value = new byte[n3];
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n2);
        this.lengthAsBits = n2;
    }

    public FormatableBitSet(byte[] byArray) {
        this.value = ArrayUtil.copy(byArray);
        this.bitsInLastByte = (byte)8;
        this.lengthAsBits = this.calculateLength(byArray.length);
    }

    public FormatableBitSet(FormatableBitSet formatableBitSet) {
        this.bitsInLastByte = formatableBitSet.bitsInLastByte;
        this.lengthAsBits = formatableBitSet.lengthAsBits;
        int n2 = FormatableBitSet.numBytesFromBits(formatableBitSet.lengthAsBits);
        this.value = new byte[n2];
        if (n2 > 0) {
            System.arraycopy(formatableBitSet.value, 0, this.value, 0, n2);
        }
    }

    public Object clone() {
        return new FormatableBitSet(this);
    }

    public boolean invariantHolds() {
        int n2 = this.value.length * 8;
        if (this.lengthAsBits > n2) {
            return false;
        }
        int n3 = (this.lengthAsBits - 1) / 8;
        if (this.bitsInLastByte != this.lengthAsBits - 8 * n3) {
            return false;
        }
        if (this.value.length == 0) {
            return true;
        }
        byte by = this.value[n3];
        by = (byte)(by << this.bitsInLastByte);
        for (int i2 = n3 + 1; i2 < this.value.length; ++i2) {
            by = (byte)(by | this.value[i2]);
        }
        return by == 0;
    }

    public int getLengthInBytes() {
        return FormatableBitSet.numBytesFromBits(this.lengthAsBits);
    }

    public int getLength() {
        return this.lengthAsBits;
    }

    private int calculateLength(int n2) {
        if (n2 == 0) {
            return 0;
        }
        return (n2 - 1) * 8 + this.bitsInLastByte;
    }

    public int size() {
        return this.getLength();
    }

    public byte[] getByteArray() {
        int n2 = this.getLengthInBytes();
        if (this.value.length != n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.value, 0, byArray, 0, n2);
            this.value = byArray;
        }
        return ArrayUtil.copy(this.value);
    }

    public void grow(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bit set cannot grow from " + this.lengthAsBits + " to " + n2 + " bits");
        }
        if (n2 <= this.lengthAsBits) {
            return;
        }
        int n3 = FormatableBitSet.numBytesFromBits(n2);
        if (n3 > this.value.length) {
            byte[] byArray = new byte[n3];
            int n4 = this.getLengthInBytes();
            System.arraycopy(this.value, 0, byArray, 0, n4);
            this.value = byArray;
        }
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n2);
        this.lengthAsBits = n2;
    }

    public void shrink(int n2) {
        if (n2 < 0 || n2 > this.lengthAsBits) {
            throw new IllegalArgumentException("Bit set cannot shrink from " + this.lengthAsBits + " to " + n2 + " bits");
        }
        int n3 = FormatableBitSet.numBytesFromBits(n2);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n2);
        this.lengthAsBits = n2;
        for (int i2 = n3; i2 < this.value.length; ++i2) {
            this.value[i2] = 0;
        }
        if (n3 > 0) {
            int n4 = n3 - 1;
            this.value[n4] = (byte)(this.value[n4] & 65280 >> this.bitsInLastByte);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof FormatableBitSet) {
            FormatableBitSet formatableBitSet = (FormatableBitSet)object;
            if (this.getLength() != formatableBitSet.getLength()) {
                return false;
            }
            return this.compare(formatableBitSet) == 0;
        }
        return false;
    }

    public int compare(FormatableBitSet formatableBitSet) {
        int n2;
        byte[] byArray = formatableBitSet.value;
        int n3 = formatableBitSet.getLengthInBytes();
        int n4 = this.getLengthInBytes();
        int n5 = 0;
        for (n2 = 0; n5 < n3 && n2 < n4 && byArray[n5] == this.value[n2]; ++n5, ++n2) {
        }
        if (n5 == n3 && n2 == n4) {
            if (this.getLength() == formatableBitSet.getLength()) {
                return 0;
            }
            return formatableBitSet.getLength() < this.getLength() ? 1 : -1;
        }
        if (n5 == n3) {
            return 1;
        }
        if (n2 == n4) {
            return -1;
        }
        int n6 = byArray[n5];
        int n7 = this.value[n2];
        return (n7 &= 0xFF) > (n6 &= 0xFF) ? 1 : -1;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getLengthInBytes();
        for (int i2 = 0; i2 < n4; ++i2) {
            n2 ^= (this.value[i2] & 0xFF) << n3;
            if (32 > (n3 += 8)) continue;
            n3 = 0;
        }
        return n2;
    }

    public final boolean isSet(int n2) {
        this.checkPosition(n2);
        int n3 = FormatableBitSet.udiv8(n2);
        byte by = FormatableBitSet.umod8(n2);
        return (this.value[n3] & 128 >> by) != 0;
    }

    public final boolean get(int n2) {
        return this.isSet(n2);
    }

    public void set(int n2) {
        this.checkPosition(n2);
        int n3 = FormatableBitSet.udiv8(n2);
        byte by = FormatableBitSet.umod8(n2);
        int n4 = n3;
        this.value[n4] = (byte)(this.value[n4] | 128 >> by);
    }

    public void clear(int n2) {
        this.checkPosition(n2);
        int n3 = FormatableBitSet.udiv8(n2);
        byte by = FormatableBitSet.umod8(n2);
        int n4 = n3;
        this.value[n4] = (byte)(this.value[n4] & ~(128 >> by));
    }

    public void clear() {
        int n2 = this.getLengthInBytes();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.value[i2] = 0;
        }
    }

    private static int numBytesFromBits(int n2) {
        return n2 + 7 >> 3;
    }

    private static byte numBitsInLastByte(int n2) {
        if (n2 == 0) {
            return 0;
        }
        byte by = FormatableBitSet.umod8(n2);
        return by != 0 ? by : (byte)8;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getLength() * 8 * 3);
        stringBuffer.append("{");
        boolean bl = true;
        for (int i2 = 0; i2 < this.getLength(); ++i2) {
            if (!this.isSet(i2)) continue;
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(i2);
        }
        stringBuffer.append("}");
        return new String(stringBuffer);
    }

    public static int maxBitsForSpace(int n2) {
        return (n2 - 4) * 8;
    }

    private static byte firstSet(byte by) {
        if ((by & 0x80) != 0) {
            return 0;
        }
        if ((by & 0x40) != 0) {
            return 1;
        }
        if ((by & 0x20) != 0) {
            return 2;
        }
        if ((by & 0x10) != 0) {
            return 3;
        }
        if ((by & 8) != 0) {
            return 4;
        }
        if ((by & 4) != 0) {
            return 5;
        }
        if ((by & 2) != 0) {
            return 6;
        }
        return 7;
    }

    public int anySetBit() {
        int n2 = this.getLengthInBytes();
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = this.value[i2];
            if (by == 0) continue;
            return FormatableBitSet.umul8(i2) + FormatableBitSet.firstSet(by);
        }
        return -1;
    }

    public int anySetBit(int n2) {
        if (++n2 >= this.lengthAsBits) {
            return -1;
        }
        int n3 = FormatableBitSet.udiv8(n2);
        byte by = (byte)(this.value[n3] << FormatableBitSet.umod8(n2));
        if (by != 0) {
            return n2 + FormatableBitSet.firstSet(by);
        }
        int n4 = this.getLengthInBytes();
        ++n3;
        while (n3 < n4) {
            by = this.value[n3];
            if (by != 0) {
                return FormatableBitSet.umul8(n3) + FormatableBitSet.firstSet(by);
            }
            ++n3;
        }
        return -1;
    }

    public void or(FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return;
        }
        int n2 = formatableBitSet.getLength();
        if (n2 > this.getLength()) {
            this.grow(n2);
        }
        int n3 = formatableBitSet.getLengthInBytes();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.value[n4] = (byte)(this.value[n4] | formatableBitSet.value[i2]);
        }
    }

    public void copyFrom(FormatableBitSet formatableBitSet) {
        System.arraycopy(formatableBitSet.getByteArray(), 0, this.value, 0, formatableBitSet.getLengthInBytes());
    }

    public void and(FormatableBitSet formatableBitSet) {
        int n2;
        if (formatableBitSet == null) {
            this.clear();
            return;
        }
        int n3 = formatableBitSet.getLength();
        if (n3 > this.getLength()) {
            this.grow(n3);
        }
        int n4 = formatableBitSet.getLengthInBytes();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = n2;
            this.value[n5] = (byte)(this.value[n5] & formatableBitSet.value[n2]);
        }
        n4 = this.getLengthInBytes();
        while (n2 < n4) {
            this.value[n2] = 0;
            ++n2;
        }
    }

    public void xor(FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return;
        }
        int n2 = formatableBitSet.getLength();
        if (n2 > this.getLength()) {
            this.grow(n2);
        }
        int n3 = formatableBitSet.getLengthInBytes();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2;
            this.value[n4] = (byte)(this.value[n4] ^ formatableBitSet.value[i2]);
        }
    }

    public int getNumBitsSet() {
        int n2 = 0;
        int n3 = this.getLengthInBytes();
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = this.value[i2];
            by = (byte)(by - (by >> 1 & 0x55));
            by = (byte)((by & 0x33) + (by >> 2 & 0x33));
            by = (byte)((by & 7) + (by >> 4));
            n2 += by;
        }
        return n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.getLength());
        int n2 = this.getLengthInBytes();
        if (n2 > 0) {
            objectOutput.write(this.value, 0, n2);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readInt();
        int n3 = FormatableBitSet.numBytesFromBits(n2);
        this.value = new byte[n3];
        objectInput.readFully(this.value);
        this.bitsInLastByte = FormatableBitSet.numBitsInLastByte(n2);
        this.lengthAsBits = n2;
    }

    @Override
    public int getTypeFormatId() {
        return 269;
    }
}

