/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.io.FormatableLongHolder;

public class FormatableHashtable
extends Hashtable<Object, Object>
implements Formatable {
    @Override
    public Object put(Object object, Object object2) {
        if (object2 == null) {
            return this.remove(object);
        }
        return super.put(object, object2);
    }

    public void putInt(Object object, int n2) {
        super.put(object, new FormatableIntHolder(n2));
    }

    public int getInt(Object object) {
        return ((FormatableIntHolder)this.get(object)).getInt();
    }

    public void putLong(Object object, long l2) {
        super.put(object, new FormatableLongHolder(l2));
    }

    public long getLong(Object object) {
        return ((FormatableLongHolder)this.get(object)).getLong();
    }

    public void putBoolean(Object object, boolean bl) {
        this.putInt(object, bl ? 1 : 0);
    }

    public boolean getBoolean(Object object) {
        return this.getInt(object) != 0;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.size());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            objectOutput.writeObject(k2);
            objectOutput.writeObject(this.get(k2));
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        for (int i2 = objectInput.readInt(); i2 > 0; --i2) {
            super.put(objectInput.readObject(), objectInput.readObject());
        }
    }

    @Override
    public int getTypeFormatId() {
        return 313;
    }
}

