/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public final class ColumnDescriptor
extends TupleDescriptor {
    private DefaultInfo columnDefaultInfo;
    private TableDescriptor table;
    private String columnName;
    private int columnPosition;
    private DataTypeDescriptor columnType;
    private DataValueDescriptor columnDefault;
    private UUID uuid;
    private UUID defaultUUID;
    private long autoincStart;
    private long autoincInc;
    private long autoincValue;
    private boolean autoincCycle;
    long autoinc_create_or_modify_Start_Increment = -1L;

    public ColumnDescriptor(String string, int n2, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, TableDescriptor tableDescriptor, UUID uUID, long l2, long l3, long l4, boolean bl) {
        this(string, n2, dataTypeDescriptor, dataValueDescriptor, defaultInfo, tableDescriptor, uUID, l2, l3, bl);
        this.autoinc_create_or_modify_Start_Increment = l4;
    }

    public ColumnDescriptor(String string, int n2, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, TableDescriptor tableDescriptor, UUID uUID, long l2, long l3, boolean bl) {
        this.columnName = string;
        this.columnPosition = n2;
        this.columnType = dataTypeDescriptor;
        this.columnDefault = dataValueDescriptor;
        this.columnDefaultInfo = defaultInfo;
        this.defaultUUID = uUID;
        if (tableDescriptor != null) {
            this.table = tableDescriptor;
            this.uuid = tableDescriptor.getUUID();
        }
        ColumnDescriptor.assertAutoinc(l3 != 0L, l3, defaultInfo);
        this.autoincStart = l2;
        this.autoincValue = l2;
        this.autoincInc = l3;
        this.autoincCycle = bl;
    }

    public ColumnDescriptor(String string, int n2, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, UUID uUID, UUID uUID2, long l2, long l3, long l4, boolean bl) {
        this.columnName = string;
        this.columnPosition = n2;
        this.columnType = dataTypeDescriptor;
        this.columnDefault = dataValueDescriptor;
        this.columnDefaultInfo = defaultInfo;
        this.uuid = uUID;
        this.defaultUUID = uUID2;
        ColumnDescriptor.assertAutoinc(l3 != 0L, l3, defaultInfo);
        this.autoincStart = l2;
        this.autoincValue = l4;
        this.autoincInc = l3;
        this.autoincCycle = bl;
    }

    public UUID getReferencingUUID() {
        return this.uuid;
    }

    public TableDescriptor getTableDescriptor() {
        return this.table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public void setTableDescriptor(TableDescriptor tableDescriptor) {
        this.table = tableDescriptor;
    }

    public int getPosition() {
        return this.columnPosition;
    }

    public DataTypeDescriptor getType() {
        return this.columnType;
    }

    public boolean hasNonNullDefault() {
        if (this.columnDefault != null && !this.columnDefault.isNull()) {
            return true;
        }
        return this.columnDefaultInfo != null;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.columnDefault;
    }

    public DefaultInfo getDefaultInfo() {
        return this.columnDefaultInfo;
    }

    public UUID getDefaultUUID() {
        return this.defaultUUID;
    }

    public DefaultDescriptor getDefaultDescriptor(DataDictionary dataDictionary) {
        DefaultDescriptor defaultDescriptor = null;
        if (this.defaultUUID != null) {
            defaultDescriptor = new DefaultDescriptor(dataDictionary, this.defaultUUID, this.uuid, this.columnPosition);
        }
        return defaultDescriptor;
    }

    public boolean isAutoincrement() {
        return this.autoincInc != 0L;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public boolean hasGenerationClause() {
        if (this.columnDefaultInfo == null) {
            return false;
        }
        return this.columnDefaultInfo.isGeneratedColumn();
    }

    public boolean isAutoincAlways() {
        return this.columnDefaultInfo == null && this.isAutoincrement();
    }

    public long getAutoincStart() {
        return this.autoincStart;
    }

    public boolean getAutoincCycle() {
        return this.autoincCycle;
    }

    public long getAutoincInc() {
        return this.autoincInc;
    }

    public long getAutoincValue() {
        return this.autoincValue;
    }

    public long getAutoinc_create_or_modify_Start_Increment() {
        return this.autoinc_create_or_modify_Start_Increment;
    }

    public void setAutoinc_create_or_modify_Start_Increment(int n2) {
        this.autoinc_create_or_modify_Start_Increment = n2;
    }

    public void setPosition(int n2) {
        this.columnPosition = n2;
    }

    public String toString() {
        return "";
    }

    @Override
    public String getDescriptorName() {
        return this.columnName;
    }

    @Override
    public String getDescriptorType() {
        return "Column";
    }

    private static void assertAutoinc(boolean bl, long l2, DefaultInfo defaultInfo) {
    }
}

