/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.tools.i18n;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;

public final class LocalizedResource
implements PrivilegedAction<String> {
    private ResourceBundle res;
    private Locale locale;
    private String encode;
    private static final String MESSAGE_FILE = "org.apache.derby.loc.toolsmessages";
    public static final String ENV_CODESET = "derby.ui.codeset";
    public static final String ENV_LOCALE = "derby.ui.locale";
    private String messageFileName;
    private String resourceKey;
    private LocalizedOutput out;
    private LocalizedInput in;
    private boolean enableLocalized;
    private static LocalizedResource local;
    private int dateSize;
    private int timeSize;
    private int timestampSize;
    private DateFormat formatDate;
    private DateFormat formatTime;
    private DateFormat formatTimestamp;
    private NumberFormat formatNumber;
    private DecimalFormat formatDecimal;

    private LocalizedResource() {
        this.init();
    }

    public LocalizedResource(String string) {
        this.init(null, null, string, true);
    }

    public LocalizedResource(String string, String string2, String string3) {
        this.init(string, string2, string3, false);
    }

    public static LocalizedResource getInstance() {
        if (local == null) {
            local = new LocalizedResource();
        }
        return local;
    }

    public static void resetLocalizedResourceCache() {
        local = null;
    }

    public void init() {
        this.init(null, null, null);
    }

    public void init(String string, String string2, String string3) {
        this.init(string, string2, string3, true);
    }

    private void init(String string, String string2, String string3, boolean bl) {
        String string4;
        if (string != null) {
            this.encode = string;
        }
        if (this.encode == null && bl && (string4 = this.getEnvProperty(ENV_CODESET)) != null) {
            this.encode = string4;
        }
        this.locale = this.getNewLocale(string2);
        if (this.locale == null && bl) {
            string4 = this.getEnvProperty(ENV_LOCALE);
            this.locale = this.getNewLocale(string4);
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.messageFileName = string3 != null ? string3 : MESSAGE_FILE;
        this.out = this.getNewOutput(System.out);
        this.in = this.getNewInput(System.in);
        if (this.enableLocalized && this.locale != null) {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.formatNumber = NumberFormat.getInstance(this.locale);
            this.formatDate = DateFormat.getDateInstance(1, this.locale);
            this.formatTime = DateFormat.getTimeInstance(1, this.locale);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1, this.locale);
        } else {
            this.formatDecimal = (DecimalFormat)DecimalFormat.getInstance();
            this.formatNumber = NumberFormat.getInstance();
            this.formatDate = DateFormat.getDateInstance(1);
            this.formatTime = DateFormat.getTimeInstance(1);
            this.formatTimestamp = DateFormat.getDateTimeInstance(1, 1);
        }
        this.initMaxSizes2();
    }

    private void setResource() {
        if (this.res != null) {
            return;
        }
        if (this.locale == null || this.locale.toString().equals("none")) {
            this.res = ResourceBundle.getBundle(this.messageFileName);
        } else {
            try {
                this.res = ResourceBundle.getBundle(this.messageFileName, this.locale);
            }
            catch (MissingResourceException missingResourceException) {
                this.res = ResourceBundle.getBundle(this.messageFileName, Locale.ENGLISH);
            }
        }
    }

    private void initMaxSizes2() {
        int n2;
        int n3;
        this.dateSize = 0;
        this.timeSize = 0;
        this.timestampSize = 0;
        java.util.Date date = new java.util.Date(60907276800000L);
        Timestamp timestamp = new Timestamp(date.getTime());
        for (n3 = 0; n3 <= 11; ++n3) {
            n2 = this.getDateAsString(date).length();
            if (n2 > this.dateSize) {
                this.dateSize = n2;
            }
            timestamp.setTime(date.getTime() + 79199L);
            n2 = this.getTimestampAsString(timestamp).length();
            if (n2 > this.timestampSize) {
                this.timestampSize = n2;
            }
            date.setTime(date.getTime() + 2592000000L);
        }
        n2 = 18;
        for (n3 = 0; n3 < 24; ++n3) {
            long l2 = (long)n3 * 3600L + 3540L + 59L;
            long l3 = l2 * 1000L;
            java.util.Date date2 = new java.util.Date(l3);
            String string = this.formatTime.format(date2);
            if (string.length() <= n2) continue;
            n2 = string.length();
        }
        this.timeSize = n2;
    }

    public LocalizedInput getNewInput(InputStream inputStream) {
        try {
            if (this.encode != null) {
                return new LocalizedInput(inputStream, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedInput(inputStream);
    }

    public LocalizedInput getNewEncodedInput(InputStream inputStream, String string) {
        try {
            return new LocalizedInput(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new LocalizedInput(inputStream);
        }
    }

    public LocalizedOutput getNewOutput(OutputStream outputStream) {
        try {
            if (this.encode != null) {
                return new LocalizedOutput(outputStream, this.encode);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new LocalizedOutput(outputStream);
    }

    public LocalizedOutput getNewEncodedOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.out = new LocalizedOutput(outputStream, string);
        return this.out;
    }

    private Locale getNewLocale(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        try {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
            }
            return new Locale(string2, string3, string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTextMessage(String string, Object ... objectArray) {
        if (this.res == null) {
            this.setResource();
        }
        try {
            return MessageFormat.format(this.res.getString(string), objectArray);
        }
        catch (Exception exception) {
            String string2 = string;
            for (int i2 = 0; objectArray != null && i2 < objectArray.length; ++i2) {
                string2 = string2 + ", <{" + i2 + "}>";
            }
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getLocalizedString(ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        if (!this.enableLocalized) {
            return resultSet.getString(n2);
        }
        int n3 = resultSetMetaData.getColumnType(n2);
        if (n3 == 91) {
            return this.getDateAsString(resultSet.getDate(n2));
        }
        if (n3 == 4 || n3 == 5 || n3 == -5 || n3 == -6) {
            return this.getNumberAsString(resultSet.getLong(n2));
        }
        if (n3 == 7 || n3 == 6 || n3 == 8) {
            return this.getNumberAsString(resultSet.getDouble(n2));
        }
        if (n3 == 2 || n3 == 3) {
            return this.getNumberAsString(resultSet.getBigDecimal(n2));
        }
        if (n3 == 92) {
            return this.getTimeAsString(resultSet.getTime(n2));
        }
        if (n3 == 93) {
            return this.getTimestampAsString(resultSet.getTimestamp(n2));
        }
        return resultSet.getString(n2);
    }

    public String getDateAsString(java.util.Date date) {
        if (!this.enableLocalized) {
            return date.toString();
        }
        return this.formatDate.format(date);
    }

    public String getTimeAsString(java.util.Date date) {
        if (!this.enableLocalized) {
            return date.toString();
        }
        return this.formatTime.format(date, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public String getNumberAsString(int n2) {
        if (this.enableLocalized) {
            return this.formatNumber.format(n2);
        }
        return String.valueOf(n2);
    }

    public String getNumberAsString(long l2) {
        if (this.enableLocalized) {
            return this.formatNumber.format(l2);
        }
        return String.valueOf(l2);
    }

    public String getNumberAsString(Object object) {
        if (this.enableLocalized) {
            return this.formatNumber.format(object, new StringBuffer(), new FieldPosition(0)).toString();
        }
        return object.toString();
    }

    public String getNumberAsString(double d2) {
        if (!this.enableLocalized) {
            return String.valueOf(d2);
        }
        return this.formatDecimal.format(d2);
    }

    public String getTimestampAsString(Timestamp timestamp) {
        if (!this.enableLocalized) {
            return timestamp.toString();
        }
        return this.formatTimestamp.format(timestamp, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public int getColumnDisplaySize(ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        if (!this.enableLocalized) {
            return resultSetMetaData.getColumnDisplaySize(n2);
        }
        int n3 = resultSetMetaData.getColumnType(n2);
        if (n3 == 91) {
            return this.dateSize;
        }
        if (n3 == 92) {
            return this.timeSize;
        }
        if (n3 == 93) {
            return this.timestampSize;
        }
        return resultSetMetaData.getColumnDisplaySize(n2);
    }

    public String getStringFromDate(String string) throws ParseException {
        if (!this.enableLocalized) {
            return string;
        }
        java.util.Date date = this.formatDate.parse(string);
        return new Date(date.getTime()).toString();
    }

    public String getStringFromTime(String string) throws ParseException {
        if (!this.enableLocalized) {
            return string;
        }
        java.util.Date date = this.formatTime.parse(string);
        return new Time(date.getTime()).toString();
    }

    public String getStringFromValue(String string) throws ParseException {
        if (!this.enableLocalized) {
            return string;
        }
        return this.formatNumber.parse(string).toString();
    }

    public String getStringFromTimestamp(String string) throws ParseException {
        if (!this.enableLocalized) {
            return string;
        }
        java.util.Date date = this.formatTimestamp.parse(string);
        return new Timestamp(date.getTime()).toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    private final synchronized String getEnvProperty(String string) {
        String string2;
        try {
            this.resourceKey = string;
            string2 = AccessController.doPrivileged(this);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public final String run() {
        String string = System.getProperty(this.resourceKey);
        return string;
    }

    public static boolean enableLocalization(boolean bl) {
        LocalizedResource.getInstance().enableLocalized = bl;
        LocalizedResource.getInstance().init();
        return bl;
    }

    public boolean isLocalized() {
        return LocalizedResource.getInstance().enableLocalized;
    }

    public static String getMessage(String string, Object ... objectArray) {
        return LocalizedResource.getInstance().getTextMessage(string, objectArray);
    }

    public static LocalizedOutput OutputWriter() {
        return LocalizedResource.getInstance().out;
    }

    public static LocalizedInput InputReader() {
        return LocalizedResource.getInstance().in;
    }

    public static String getNumber(long l2) {
        return LocalizedResource.getInstance().getNumberAsString(l2);
    }

    public static String getNumber(int n2) {
        return LocalizedResource.getInstance().getNumberAsString(n2);
    }

    public String toString() {
        String string = "toString(){\nlocale=" + (this.locale == null ? "null" : this.locale.toString()) + "\nencode=" + this.encode + "\nmessageFile=" + this.messageFileName + "\nresourceKey=" + this.resourceKey + "\nenableLocalized=" + this.enableLocalized + " \ndateSize=" + this.dateSize + "\ntimeSize=" + this.timeSize + "\ntimestampSize=" + this.timestampSize + "\n}";
        return string;
    }
}

