/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Timestamp;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public abstract class DataTypeUtilities {
    public static Timestamp clone(Timestamp timestamp) {
        return timestamp == null ? null : (Timestamp)timestamp.clone();
    }

    public static int getPrecision(DataTypeDescriptor dataTypeDescriptor) {
        int n2 = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        switch (n2) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: 
            case 2009: {
                return dataTypeDescriptor.getMaximumWidth();
            }
            case 5: {
                return 5;
            }
            case 16: {
                return 1;
            }
        }
        return dataTypeDescriptor.getPrecision();
    }

    public static int getDigitPrecision(DataTypeDescriptor dataTypeDescriptor) {
        int n2 = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        switch (n2) {
            case 6: 
            case 8: {
                return 15;
            }
            case 7: {
                return 7;
            }
        }
        return DataTypeUtilities.getPrecision(dataTypeDescriptor);
    }

    public static boolean isCaseSensitive(DataTypeDescriptor dataTypeDescriptor) {
        int n2 = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        return n2 == 1 || n2 == 12 || n2 == 2005 || n2 == -1 || n2 == 2009;
    }

    public static int isNullable(DataTypeDescriptor dataTypeDescriptor) {
        return dataTypeDescriptor.isNullable() ? 1 : 0;
    }

    public static boolean isSigned(DataTypeDescriptor dataTypeDescriptor) {
        int n2 = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        return n2 == 4 || n2 == 6 || n2 == 3 || n2 == 5 || n2 == -5 || n2 == -6 || n2 == 2 || n2 == 7 || n2 == 8;
    }

    public static int getColumnDisplaySize(DataTypeDescriptor dataTypeDescriptor) {
        int n2 = dataTypeDescriptor.getTypeId().getJDBCTypeId();
        int n3 = dataTypeDescriptor.getMaximumWidth();
        return DataTypeUtilities.getColumnDisplaySize(n2, n3);
    }

    public static int getColumnDisplaySize(int n2, int n3) {
        int n4;
        switch (n2) {
            case 93: {
                n4 = 29;
                break;
            }
            case 91: {
                n4 = 10;
                break;
            }
            case 92: {
                n4 = 8;
                break;
            }
            case 4: {
                n4 = 11;
                break;
            }
            case 5: {
                n4 = 6;
                break;
            }
            case 6: 
            case 7: {
                n4 = 15;
                break;
            }
            case 8: {
                n4 = 24;
                break;
            }
            case -6: {
                n4 = 15;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n4 = 2 * n3;
                if (n4 >= 0) break;
                n4 = Integer.MAX_VALUE;
                break;
            }
            case -5: {
                n4 = 20;
                break;
            }
            case -7: 
            case 16: {
                n4 = 5;
                break;
            }
            default: {
                int n5 = n3;
                n4 = n5 > 0 ? n5 : 15;
            }
        }
        return n4;
    }

    public static int computeMaxWidth(int n2, int n3) {
        return n3 == 0 ? n2 + 1 : (n3 == n2 ? n2 + 3 : n2 + 2);
    }
}

