/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;

public abstract class NumberDataType
extends DataType
implements NumberDataValue {
    static final BigDecimal MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    static final BigDecimal MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);

    @Override
    public final NumberDataValue absolute(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNegative()) {
            return this.minus(numberDataValue);
        }
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        numberDataValue.setValue(this);
        return numberDataValue;
    }

    @Override
    public NumberDataValue sqrt(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = (NumberDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        double d2 = this.getDouble();
        if (this.isNegative()) {
            if (d2 == -0.0) {
                d2 = 0.0;
            } else {
                throw StandardException.newException("22013", this);
            }
        }
        numberDataValue.setValue(Math.sqrt(d2));
        return numberDataValue;
    }

    @Override
    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n2 = numberDataValue.getInt();
        int n3 = numberDataValue2.getInt();
        int n4 = n2 + n3;
        if (n2 < 0 == n3 < 0 && n2 < 0 != n4 < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n4);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n2 = numberDataValue.getInt() - numberDataValue2.getInt();
        if (numberDataValue.getInt() < 0 != numberDataValue2.getInt() < 0 && numberDataValue.getInt() < 0 != n2 < 0) {
            throw this.outOfRange();
        }
        numberDataValue3.setValue(n2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = (NumberDataValue)this.getNewNull();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        int n2 = numberDataValue2.getInt();
        if (n2 == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        numberDataValue3.setValue(numberDataValue.getInt() / n2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n2) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3);
    }

    @Override
    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return null;
    }

    @Override
    public final int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        return this.typeCompare(dataValueDescriptor);
    }

    protected abstract int typeCompare(DataValueDescriptor var1) throws StandardException;

    @Override
    public final boolean compare(int n2, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n2, dataValueDescriptor, bl, bl2);
    }

    protected abstract boolean isNegative();

    @Override
    public void setValue(short s2) throws StandardException {
        this.setValue((int)s2);
    }

    @Override
    public void setValue(byte by) throws StandardException {
        this.setValue((int)by);
    }

    @Override
    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.intValue());
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue((Integer)object);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        if (bigDecimal.compareTo(MINLONG_MINUS_ONE) != 1 || bigDecimal.compareTo(MAXLONG_PLUS_ONE) != -1) {
            throw StandardException.newException("22003", this.getTypeName());
        }
        this.setValue(bigDecimal.longValue());
    }

    @Override
    public int typeToBigDecimal() {
        return -5;
    }

    protected final boolean objectNull(Object object) {
        if (object == null) {
            this.restoreToNull();
            return true;
        }
        return false;
    }

    public static float normalizeREAL(float f2) throws StandardException {
        boolean bl;
        boolean bl2 = bl = Float.isNaN(f2) || Float.isInfinite(f2);
        if ((f2 < -3.402E38f || f2 > 3.402E38f || f2 > 0.0f && f2 < 1.175E-37f || f2 < 0.0f && f2 > -1.175E-37f) && NumberDataType.useDB2Limits()) {
            bl = true;
        }
        if (bl) {
            throw StandardException.newException("22003", "REAL");
        }
        if (f2 == -0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    public static float normalizeREAL(double d2) throws StandardException {
        boolean bl;
        float f2 = (float)d2;
        boolean bl2 = bl = Double.isNaN(d2) || Double.isInfinite(d2) || f2 == 0.0f && d2 != 0.0;
        if ((d2 < (double)-3.402E38f || d2 > (double)3.402E38f || d2 > 0.0 && d2 < (double)1.175E-37f || d2 < 0.0 && d2 > (double)-1.175E-37f) && NumberDataType.useDB2Limits()) {
            bl = true;
        }
        if (bl) {
            throw StandardException.newException("22003", "REAL");
        }
        if (f2 == -0.0f) {
            f2 = 0.0f;
        }
        return f2;
    }

    public static double normalizeDOUBLE(double d2) throws StandardException {
        boolean bl;
        boolean bl2 = bl = Double.isNaN(d2) || Double.isInfinite(d2);
        if ((d2 < -1.79769E308 || d2 > 1.79769E308 || d2 > 0.0 && d2 < 2.225E-307 || d2 < 0.0 && d2 > -2.225E-307) && NumberDataType.useDB2Limits()) {
            bl = true;
        }
        if (bl) {
            throw StandardException.newException("22003", "DOUBLE");
        }
        if (d2 == -0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    private static boolean useDB2Limits() throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)NumberDataType.getContextOrNull("LanguageConnectionContext");
        if (languageConnectionContext != null) {
            return !languageConnectionContext.getDataDictionary().checkVersion(220, null);
        }
        return false;
    }

    private static Context getContextOrNull(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }
}

