/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CounterOutputStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.ConcatableDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.iapi.util.UTF8Util;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    private static final char PAD = ' ';
    protected static final int RETURN_SPACE_THRESHOLD = 4096;
    private static final int GROWBY_FOR_CHAR = 64;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLChar.class);
    private static final char[] BLANKS = new char[40];
    protected static final StreamHeaderGenerator CHAR_HEADER_GENERATOR;
    private String value;
    private char[] rawData;
    private int rawLength = -1;
    private CollationKey cKey;
    protected Clob _clobValue;
    InputStream stream;
    private LocaleFinder localeFinder;
    char[][] arg_passer = new char[1][];

    public SQLChar() {
    }

    public SQLChar(String string) {
        this.value = string;
    }

    public SQLChar(Clob clob) {
        this.setValue(clob);
    }

    public SQLChar(char[] cArray) {
        if (cArray == null) {
            this.value = null;
        } else {
            int n2 = cArray.length;
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            this.copyState(null, cArray2, n2, null, null, null, null);
        }
    }

    private static void appendBlanks(char[] cArray, int n2, int n3) {
        while (n3 > 0) {
            int n4 = n3 > BLANKS.length ? BLANKS.length : n3;
            System.arraycopy(BLANKS, 0, cArray, n2, n4);
            n3 -= n4;
            n2 += n4;
        }
    }

    public char[] getRawDataAndZeroIt() {
        if (this.rawData == null) {
            return null;
        }
        int n2 = this.rawData.length;
        char[] cArray = new char[n2];
        System.arraycopy(this.rawData, 0, cArray, 0, n2);
        this.zeroRawData();
        return cArray;
    }

    public void zeroRawData() {
        if (this.rawData == null) {
            return;
        }
        Arrays.fill(this.rawData, '\u0000');
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String string = this.getString().trim();
        return !string.equals("0") && !string.equals("false");
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "byte");
        }
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "short");
        }
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "int");
        }
    }

    @Override
    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "long");
        }
    }

    @Override
    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "float");
        }
    }

    @Override
    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("22018", "double");
        }
    }

    @Override
    public Date getDate(Calendar calendar) throws StandardException {
        return SQLChar.getDate(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLDate sQLDate = new SQLDate(string, false, localeFinder);
        return sQLDate.getDate(calendar);
    }

    @Override
    public Time getTime(Calendar calendar) throws StandardException {
        return SQLChar.getTime(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTime sQLTime = new SQLTime(string, false, localeFinder, calendar);
        return sQLTime.getTime(calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        return SQLChar.getTimestamp(calendar, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar calendar, String string, LocaleFinder localeFinder) throws StandardException {
        if (string == null) {
            return null;
        }
        SQLTimestamp sQLTimestamp = new SQLTimestamp(string, false, localeFinder, calendar);
        return sQLTimestamp.getTimestamp(calendar);
    }

    @Override
    public InputStream returnStream() {
        return this.stream;
    }

    @Override
    public void setStream(InputStream inputStream) {
        this.value = null;
        this.rawLength = -1;
        this.stream = inputStream;
        this.cKey = null;
        this._clobValue = null;
    }

    @Override
    public void loadStream() throws StandardException {
        this.getString();
    }

    @Override
    public Object getObject() throws StandardException {
        return this.getString();
    }

    @Override
    public InputStream getStream() throws StandardException {
        if (!this.hasStream()) {
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        return this.stream;
    }

    @Override
    public CharacterStreamDescriptor getStreamWithDescriptor() throws StandardException {
        throw StandardException.newException("42Z12.U", this.getTypeName());
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        return 1;
    }

    @Override
    public int getLength() throws StandardException {
        String string;
        if (this._clobValue != null) {
            return this.getClobLength();
        }
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        if (this.stream != null && this.stream instanceof Resetable && this.stream instanceof ObjectInput) {
            try {
                InputStreamUtil.skipFully(this.stream, 2L);
                int n2 = (int)UTF8Util.skipUntilEOF(this.stream);
                return n2;
            }
            catch (IOException iOException) {
                this.throwStreamingIOException(iOException);
            }
            finally {
                try {
                    ((Resetable)((Object)this.stream)).resetStream();
                }
                catch (IOException iOException) {
                    this.throwStreamingIOException(iOException);
                }
            }
        }
        if ((string = this.getString()) == null) {
            return 0;
        }
        int n3 = string.length();
        return n3;
    }

    protected void throwStreamingIOException(IOException iOException) throws StandardException {
        throw StandardException.newException("XCL30.S", iOException, this.getTypeName());
    }

    @Override
    public String getTypeName() {
        return "CHAR";
    }

    @Override
    public String getString() throws StandardException {
        if (this.value == null) {
            int n2 = this.rawLength;
            if (n2 != -1) {
                this.value = new String(this.rawData, 0, n2);
                if (n2 > 4096) {
                    this.rawData = null;
                    this.rawLength = -1;
                    this.cKey = null;
                }
            } else if (this._clobValue != null) {
                try {
                    this.value = this._clobValue.getSubString(1L, this.getClobLength());
                    this._clobValue = null;
                }
                catch (SQLException sQLException) {
                    throw StandardException.plainWrapException(sQLException);
                }
            } else if (this.stream != null) {
                try {
                    if (this.stream instanceof FormatIdInputStream) {
                        this.readExternal((FormatIdInputStream)this.stream);
                    } else {
                        this.readExternal(new FormatIdInputStream(this.stream));
                    }
                    this.stream = null;
                    return this.getString();
                }
                catch (IOException iOException) {
                    throw StandardException.newException("XCL30.S", iOException, String.class.getName());
                }
            }
        }
        return this.value;
    }

    @Override
    public char[] getCharArray() throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (this.rawLength != -1) {
            return this.rawData;
        }
        this.getString();
        this.rawData = this.value.toCharArray();
        this.rawLength = this.rawData.length;
        this.cKey = null;
        return this.rawData;
    }

    @Override
    public int getTypeFormatId() {
        return 78;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawLength == -1 && this.stream == null && this._clobValue == null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        boolean bl;
        if (this._clobValue != null) {
            this.writeClobUTF(objectOutput);
            return;
        }
        String string = null;
        char[] cArray = null;
        int n2 = this.rawLength;
        if (n2 < 0) {
            string = this.value;
            n2 = string.length();
            bl = false;
        } else {
            cArray = this.rawData;
            bl = true;
        }
        int n3 = n2;
        for (int i2 = 0; i2 < n2 && n3 <= 65535; ++i2) {
            char c2;
            char c3 = c2 = bl ? cArray[i2] : string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') continue;
            if (c2 > '\u07ff') {
                n3 += 2;
                continue;
            }
            ++n3;
        }
        StreamHeaderGenerator streamHeaderGenerator = this.getStreamHeaderGenerator();
        streamHeaderGenerator.generateInto(objectOutput, n3);
        this.writeUTF(objectOutput, n2, bl, null);
        streamHeaderGenerator.writeEOF(objectOutput, n3);
    }

    private final void writeUTF(ObjectOutput objectOutput, int n2, boolean bl, Reader reader) throws IOException {
        char[] cArray = bl ? this.rawData : null;
        String string = bl ? null : this.value;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = reader != null ? reader.read() : (bl ? cArray[i2] : string.charAt(i2));
            SQLChar.writeUTF(objectOutput, n3);
        }
    }

    private static void writeUTF(ObjectOutput objectOutput, int n2) throws IOException {
        if (n2 >= 1 && n2 <= 127) {
            objectOutput.write(n2);
        } else if (n2 > 2047) {
            objectOutput.write(0xE0 | n2 >> 12 & 0xF);
            objectOutput.write(0x80 | n2 >> 6 & 0x3F);
            objectOutput.write(0x80 | n2 >> 0 & 0x3F);
        } else {
            objectOutput.write(0xC0 | n2 >> 6 & 0x1F);
            objectOutput.write(0x80 | n2 >> 0 & 0x3F);
        }
    }

    protected final void writeClobUTF(ObjectOutput objectOutput) throws IOException {
        boolean bl = this._clobValue != null;
        try {
            StreamHeaderGenerator streamHeaderGenerator;
            boolean bl2 = this.rawLength >= 0;
            int n2 = this.rawLength;
            if (!bl2) {
                n2 = bl ? this.rawGetClobLength() : this.value.length();
            }
            int n3 = (streamHeaderGenerator = this.getStreamHeaderGenerator()).expectsCharCount() ? n2 : -1;
            streamHeaderGenerator.generateInto(objectOutput, n3);
            Reader reader = null;
            if (bl) {
                reader = this._clobValue.getCharacterStream();
            }
            this.writeUTF(objectOutput, n2, bl2, reader);
            streamHeaderGenerator.writeEOF(objectOutput, n3);
            if (bl) {
                reader.close();
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.getMessage());
            iOException.initCause(sQLException);
            throw iOException;
        }
    }

    @Override
    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.resetForMaterialization();
        int n2 = (arrayInputStream.read() & 0xFF) << 8 | arrayInputStream.read() & 0xFF;
        if (this.rawData == null || this.rawData.length < n2) {
            this.rawData = new char[n2];
        }
        this.arg_passer[0] = this.rawData;
        this.rawLength = arrayInputStream.readDerbyUTF(this.arg_passer, n2);
        this.rawData = this.arg_passer[0];
    }

    protected void readExternalClobFromArray(ArrayInputStream arrayInputStream, int n2) throws IOException {
        this.resetForMaterialization();
        if (this.rawData == null || this.rawData.length < n2) {
            this.rawData = new char[n2];
        }
        this.arg_passer[0] = this.rawData;
        this.rawLength = arrayInputStream.readDerbyUTF(this.arg_passer, 0);
        this.rawData = this.arg_passer[0];
    }

    private void resetForMaterialization() {
        this.value = null;
        this.stream = null;
        this.cKey = null;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2 = objectInput.readUnsignedShort();
        this.readExternal(objectInput, n2, 0);
    }

    protected void readExternal(ObjectInput objectInput, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.growBy();
        if (n2 != 0) {
            n4 = n2;
        } else {
            n4 = objectInput.available();
            if (n4 < n5) {
                n4 = n5;
            }
        }
        char[] cArray = this.rawData == null || n4 > this.rawData.length ? new char[n4] : this.rawData;
        int n6 = cArray.length;
        this.rawData = null;
        this.resetForMaterialization();
        int n7 = 0;
        int n8 = 0;
        while (!(n8 >= n3 && n3 != 0 || n7 >= n2 && n2 != 0)) {
            char c2;
            int n9;
            int n10;
            int n11;
            try {
                n11 = objectInput.readUnsignedByte();
            }
            catch (EOFException eOFException) {
                if (n2 == 0) break;
                throw new EOFException();
            }
            if (n8 >= n6) {
                n10 = objectInput.available();
                if (n10 < n5) {
                    n10 = n5;
                }
                n9 = n6 + n10;
                char[] cArray2 = cArray;
                cArray = new char[n9];
                System.arraycopy(cArray2, 0, cArray, 0, n6);
                n6 = n9;
            }
            if ((n11 & 0x80) == 0) {
                ++n7;
                c2 = (char)n11;
            } else if ((n11 & 0x60) == 64) {
                if (n2 != 0 && (n7 += 2) > n2) {
                    throw new UTFDataFormatException();
                }
                n10 = objectInput.readUnsignedByte();
                if ((n10 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c2 = (char)((n11 & 0x1F) << 6 | n10 & 0x3F);
            } else if ((n11 & 0x70) == 96) {
                if (n2 != 0 && (n7 += 3) > n2) {
                    throw new UTFDataFormatException();
                }
                n10 = objectInput.readUnsignedByte();
                n9 = objectInput.readUnsignedByte();
                if (n11 == 224 && n10 == 0 && n9 == 0 && n2 == 0) break;
                if ((n10 & 0xC0) != 128 || (n9 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c2 = (char)((n11 & 0xF) << 12 | (n10 & 0x3F) << 6 | (n9 & 0x3F) << 0);
            } else {
                throw new UTFDataFormatException("Invalid code point: " + Integer.toHexString(n11));
            }
            cArray[n8++] = c2;
        }
        this.rawData = cArray;
        this.rawLength = n8;
    }

    protected int growBy() {
        return 64;
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this._clobValue = null;
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
    }

    @Override
    public boolean compare(int n2, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        if (!(dataValueDescriptor instanceof SQLChar)) {
            return dataValueDescriptor.compare(SQLChar.flip(n2), this, bl, bl2);
        }
        return super.compare(n2, dataValueDescriptor, bl, bl2);
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        return this.stringCompare(this, (SQLChar)dataValueDescriptor);
    }

    @Override
    public DataValueDescriptor cloneHolder() {
        if (this.stream == null && this._clobValue == null) {
            return this.cloneValue(false);
        }
        SQLChar sQLChar = (SQLChar)this.getNewNull();
        sQLChar.copyState(this);
        return sQLChar;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLChar collatorSQLChar = new CollatorSQLChar(ruleBasedCollator);
        collatorSQLChar.copyState(this);
        return collatorSQLChar;
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl) throws SQLException {
        this.setValue(resultSet.getString(n2));
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n2) throws SQLException, StandardException {
        preparedStatement.setString(n2, this.getString());
    }

    @Override
    public void setValue(Clob clob) {
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
        this.value = null;
        this._clobValue = clob;
    }

    @Override
    public void setValue(String string) {
        this.stream = null;
        this.rawLength = -1;
        this.cKey = null;
        this._clobValue = null;
        this.value = string;
    }

    @Override
    public void setValue(boolean bl) throws StandardException {
        this.setValue(Boolean.toString(bl));
    }

    @Override
    public void setValue(int n2) throws StandardException {
        this.setValue(Integer.toString(n2));
    }

    @Override
    public void setValue(double d2) throws StandardException {
        this.setValue(Double.toString(d2));
    }

    @Override
    public void setValue(float f2) throws StandardException {
        this.setValue(Float.toString(f2));
    }

    @Override
    public void setValue(short s2) throws StandardException {
        this.setValue(Short.toString(s2));
    }

    @Override
    public void setValue(long l2) throws StandardException {
        this.setValue(Long.toString(l2));
    }

    @Override
    public void setValue(byte by) throws StandardException {
        this.setValue(Byte.toString(by));
    }

    @Override
    public void setValue(byte[] byArray) throws StandardException {
        if (byArray == null) {
            this.restoreToNull();
            return;
        }
        int n2 = byArray.length % 2;
        int n3 = byArray.length / 2 + n2;
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = 0;
        if (n2 == 1) {
            cArray[--n3] = (char)(byArray[byArray.length - 1] << 8);
        }
        while (n4 < n3) {
            cArray[n4] = (char)(byArray[n5] << 8 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
            ++n4;
        }
        this.setValue(new String(cArray));
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        if (bigDecimal == null) {
            this.setToNull();
        } else {
            this.setValue(bigDecimal.toString());
        }
    }

    @Override
    public void setValue(Date date, Calendar calendar) throws StandardException {
        String string = null;
        if (date != null) {
            if (calendar == null) {
                string = date.toString();
            } else {
                calendar.setTime(date);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    @Override
    public void setValue(Time time, Calendar calendar) throws StandardException {
        String string = null;
        if (time != null) {
            if (calendar == null) {
                string = time.toString();
            } else {
                calendar.setTime(time);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCTime(calendar, stringBuffer);
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    @Override
    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        String string = null;
        if (timestamp != null) {
            if (calendar == null) {
                string = timestamp.toString();
            } else {
                calendar.setTime(timestamp);
                StringBuffer stringBuffer = new StringBuffer();
                this.formatJDBCDate(calendar, stringBuffer);
                stringBuffer.append(' ');
                this.formatJDBCTime(calendar, stringBuffer);
                stringBuffer.append('.');
                int n2 = timestamp.getNanos();
                if (n2 == 0) {
                    stringBuffer.append('0');
                } else if (n2 > 0) {
                    int n3;
                    String string2 = Integer.toString(n2);
                    for (int i2 = n3 = string2.length(); i2 < 9; ++i2) {
                        stringBuffer.append('0');
                    }
                    while (string2.charAt(n3 - 1) == '0') {
                        --n3;
                    }
                    stringBuffer.append(string2.substring(0, n3));
                }
                string = stringBuffer.toString();
            }
        }
        this.setValue(string);
    }

    private void formatJDBCDate(Calendar calendar, StringBuffer stringBuffer) {
        SQLDate.dateToString(calendar.get(1), calendar.get(2) - 0 + 1, calendar.get(5), stringBuffer);
    }

    private void formatJDBCTime(Calendar calendar, StringBuffer stringBuffer) {
        SQLTime.timeToString(calendar.get(11), calendar.get(12), calendar.get(13), stringBuffer);
    }

    @Override
    public final void setValue(InputStream inputStream, int n2) {
        this.setStream(inputStream);
    }

    @Override
    public void setObjectForCast(Object object, boolean bl, String string) throws StandardException {
        if (object == null) {
            this.setToNull();
            return;
        }
        if ("java.lang.String".equals(string)) {
            this.setValue(object.toString());
        } else {
            super.setObjectForCast(object, bl, string);
        }
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLChar) {
            SQLChar sQLChar = (SQLChar)dataValueDescriptor;
            if (sQLChar._clobValue != null) {
                this.setValue(sQLChar._clobValue);
                return;
            }
        }
        this.setValue(dataValueDescriptor.getString());
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        int n2 = dataTypeDescriptor.getMaximumWidth();
        int n3 = string.length();
        if (n3 == n2) {
            this.setValue(string);
            return;
        }
        if (n3 < n2) {
            char[] cArray;
            this.setToNull();
            if (this.rawData == null || n2 > this.rawData.length) {
                this.rawData = new char[n2];
                cArray = this.rawData;
            } else {
                cArray = this.rawData;
            }
            string.getChars(0, n3, cArray, 0);
            SQLChar.appendBlanks(cArray, n3, n2 - n3);
            this.rawLength = n2;
            return;
        }
        this.hasNonBlankChars(string, n2, n3);
        String string2 = string.substring(0, n2);
        this.setValue(string2);
    }

    protected final void hasNonBlankChars(String string, int n2, int n3) throws StandardException {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (string.charAt(i2) == ' ') continue;
            throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(string), String.valueOf(n2));
        }
    }

    @Override
    public void setWidth(int n2, int n3, boolean bl) throws StandardException {
        if (this._clobValue == null && this.getString() == null) {
            return;
        }
        int n4 = this.getLength();
        if (n4 < n2) {
            if (!(this instanceof SQLVarchar)) {
                StringBuffer stringBuffer = new StringBuffer(this.getString());
                while (n4 < n2) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                this.setValue(new String(stringBuffer));
            }
        } else if (n4 > n2 && n2 > 0) {
            try {
                this.hasNonBlankChars(this.getString(), n2, n4);
            }
            catch (StandardException standardException) {
                if (bl) {
                    throw standardException;
                }
                String string = this.getString();
                int n5 = this.getUTF8Length(string, 0, n2);
                int n6 = n5 + this.getUTF8Length(string, n2, string.length());
                DataTruncation dataTruncation = new DataTruncation(-1, false, true, n6, n5);
                dataTruncation.initCause(standardException);
                StatementContext statementContext = (StatementContext)DataValueFactoryImpl.getContext("StatementContext");
                statementContext.getActivation().getResultSet().addWarning(dataTruncation);
            }
            this.setValue(this.getString().substring(0, n2));
        }
    }

    private int getUTF8Length(String string, int n2, int n3) throws StandardException {
        CounterOutputStream counterOutputStream = new CounterOutputStream();
        try {
            FormatIdOutputStream formatIdOutputStream = new FormatIdOutputStream(counterOutputStream);
            for (int i2 = n2; i2 < n3; ++i2) {
                SQLChar.writeUTF(formatIdOutputStream, string.charAt(i2));
            }
            formatIdOutputStream.close();
        }
        catch (IOException iOException) {
            throw StandardException.newException("X0X63.S", iOException, iOException.toString());
        }
        return counterOutputStream.getCount();
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) == 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) == 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) != 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) != 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) < 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) < 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) > 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) > 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) <= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) <= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        boolean bl = dataValueDescriptor instanceof SQLChar && dataValueDescriptor2 instanceof SQLChar ? this.stringCompare((SQLChar)dataValueDescriptor, (SQLChar)dataValueDescriptor2) >= 0 : SQLChar.stringCompare(dataValueDescriptor.getString(), dataValueDescriptor2.getString()) >= 0;
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, bl);
    }

    @Override
    public NumberDataValue charLength(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setValue(this.getLength());
        return numberDataValue;
    }

    @Override
    public StringDataValue concatenate(StringDataValue stringDataValue, StringDataValue stringDataValue2, StringDataValue stringDataValue3) throws StandardException {
        if (stringDataValue3 == null) {
            stringDataValue3 = (StringDataValue)this.getNewNull();
        }
        if (stringDataValue.isNull() || stringDataValue.getString() == null || stringDataValue2.isNull() || stringDataValue2.getString() == null) {
            stringDataValue3.setToNull();
            return stringDataValue3;
        }
        stringDataValue3.setValue(stringDataValue.getString().concat(stringDataValue2.getString()));
        return stringDataValue3;
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor) throws StandardException {
        char[] cArray = this.getCharArray();
        char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
        Boolean bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength(), null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        if (dataValueDescriptor2.isNull()) {
            throw StandardException.newException("22501", new Object[0]);
        }
        char[] cArray = this.getCharArray();
        char[] cArray2 = ((SQLChar)dataValueDescriptor).getCharArray();
        char[] cArray3 = ((SQLChar)dataValueDescriptor2).getCharArray();
        int n2 = dataValueDescriptor2.getLength();
        if (cArray3 != null && n2 != 1) {
            throw StandardException.newException("22019", new String(cArray3));
        }
        Boolean bl = Like.like(cArray, this.getLength(), cArray2, dataValueDescriptor.getLength(), cArray3, n2, null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, dataValueDescriptor, bl);
    }

    @Override
    public NumberDataValue locate(StringDataValue stringDataValue, NumberDataValue numberDataValue, NumberDataValue numberDataValue2) throws StandardException {
        if (numberDataValue2 == null) {
            numberDataValue2 = new SQLInteger();
        }
        int n2 = numberDataValue.isNull() ? 1 : numberDataValue.getInt();
        if (this.isNull() || stringDataValue.isNull()) {
            numberDataValue2.setToNull();
            return numberDataValue2;
        }
        String string = stringDataValue.getString();
        String string2 = this.getString();
        if (n2 < 1) {
            throw StandardException.newException("22014", this.getString(), string, n2);
        }
        if (string2.length() == 0) {
            numberDataValue2.setValue(n2);
            return numberDataValue2;
        }
        numberDataValue2.setValue(string.indexOf(string2, n2 - 1) + 1);
        return numberDataValue2;
    }

    @Override
    public ConcatableDataValue substring(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, ConcatableDataValue concatableDataValue, int n2) throws StandardException {
        if (concatableDataValue == null) {
            concatableDataValue = this.getNewVarchar();
        }
        StringDataValue stringDataValue = (StringDataValue)concatableDataValue;
        if (this.isNull() || numberDataValue.isNull() || numberDataValue2 != null && numberDataValue2.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        int n3 = numberDataValue.getInt();
        int n4 = numberDataValue2 != null ? numberDataValue2.getInt() : n2 - n3 + 1;
        if (n3 <= 0 || n4 < 0 || n3 > n2 || n4 > n2 - n3 + 1) {
            throw StandardException.newException("22011", new Object[0]);
        }
        if (n4 < 0) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        if (n3 < 0) {
            if (n3 + this.getLength() < 0 && n3 + this.getLength() + n4 <= 0) {
                stringDataValue.setValue("");
                return stringDataValue;
            }
            n3 += this.getLength();
            while (n3 < 0) {
                ++n3;
                --n4;
            }
        } else if (n3 > 0) {
            --n3;
        }
        if (n4 == 0 || n4 <= 0 - n3 || n3 > this.getLength()) {
            stringDataValue.setValue("");
            return stringDataValue;
        }
        if (n4 >= this.getLength() - n3) {
            stringDataValue.setValue(this.getString().substring(n3));
        } else {
            stringDataValue.setValue(this.getString().substring(n3, n3 + n4));
        }
        return stringDataValue;
    }

    private String trimInternal(int n2, char c2, String string) {
        int n3;
        int n4;
        if (string == null) {
            return null;
        }
        int n5 = string.length();
        if (n2 == 2 || n2 == 0) {
            for (n4 = 0; n4 < n5 && c2 == string.charAt(n4); ++n4) {
            }
        }
        if (n4 == n5) {
            return "";
        }
        if (n2 == 1 || n2 == 0) {
            for (n3 = n5 - 1; n3 >= 0 && c2 == string.charAt(n3); --n3) {
            }
        }
        if (n3 == -1) {
            return "";
        }
        return string.substring(n4, n3 + 1);
    }

    @Override
    public StringDataValue ansiTrim(int n2, StringDataValue stringDataValue, StringDataValue stringDataValue2) throws StandardException {
        if (stringDataValue2 == null) {
            stringDataValue2 = this.getNewVarchar();
        }
        if (stringDataValue == null || stringDataValue.getString() == null) {
            stringDataValue2.setToNull();
            return stringDataValue2;
        }
        if (stringDataValue.getString().length() != 1) {
            throw StandardException.newException("22020", stringDataValue.getString());
        }
        char c2 = stringDataValue.getString().charAt(0);
        stringDataValue2.setValue(this.trimInternal(n2, c2, this.getString()));
        return stringDataValue2;
    }

    @Override
    public StringDataValue upper(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toUpperCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    @Override
    public StringDataValue lower(StringDataValue stringDataValue) throws StandardException {
        if (stringDataValue == null) {
            stringDataValue = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        String string = this.getString();
        string = string.toLowerCase(this.getLocale());
        stringDataValue.setValue(string);
        return stringDataValue;
    }

    @Override
    public int typePrecedence() {
        return 0;
    }

    protected static int stringCompare(String string, String string2) {
        int n2;
        String string3;
        int n3;
        int n4;
        int n5;
        if (string == null || string2 == null) {
            if (string != null) {
                return -1;
            }
            if (string2 != null) {
                return 1;
            }
            return 0;
        }
        int n6 = string.length();
        int n7 = n6 < (n5 = string2.length()) ? n6 : n5;
        for (n4 = 0; n4 < n7; ++n4) {
            char c2;
            char c3 = string.charAt(n4);
            if (c3 == (c2 = string2.charAt(n4))) continue;
            if (c3 < c2) {
                return -1;
            }
            return 1;
        }
        if (n6 == n5) {
            return 0;
        }
        if (n6 > n5) {
            n3 = -1;
            string3 = string;
            n4 = n5;
            n2 = n6;
        } else {
            n3 = 1;
            string3 = string2;
            n4 = n6;
            n2 = n5;
        }
        while (n4 < n2) {
            char c4 = string3.charAt(n4);
            if (c4 < ' ') {
                return n3;
            }
            if (c4 > ' ') {
                return -n3;
            }
            ++n4;
        }
        return 0;
    }

    protected int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        return SQLChar.stringCompare(sQLChar.getCharArray(), sQLChar.getLength(), sQLChar2.getCharArray(), sQLChar2.getLength());
    }

    protected static int stringCompare(char[] cArray, int n2, char[] cArray2, int n3) {
        int n4;
        char[] cArray3;
        int n5;
        int n6;
        if (cArray == null || cArray2 == null) {
            if (cArray != null) {
                return -1;
            }
            if (cArray2 != null) {
                return 1;
            }
            return 0;
        }
        int n7 = n2 < n3 ? n2 : n3;
        for (n6 = 0; n6 < n7; ++n6) {
            char c2 = cArray[n6];
            char c3 = cArray2[n6];
            if (c2 == c3) continue;
            if (c2 < c3) {
                return -1;
            }
            return 1;
        }
        if (n2 == n3) {
            return 0;
        }
        if (n2 > n3) {
            n5 = -1;
            cArray3 = cArray;
            n6 = n3;
            n4 = n2;
        } else {
            n5 = 1;
            cArray3 = cArray2;
            n6 = n2;
            n4 = n3;
        }
        while (n6 < n4) {
            char c4 = cArray3[n6];
            if (c4 < ' ') {
                return n5;
            }
            if (c4 > ' ') {
                return -n5;
            }
            ++n6;
        }
        return 0;
    }

    protected CollationKey getCollationKey() throws StandardException {
        int n2;
        char[] cArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (cArray = this.getCharArray()) == null) {
            return null;
        }
        for (n2 = this.rawLength; n2 > 0 && this.rawData[n2 - 1] == ' '; --n2) {
        }
        RuleBasedCollator ruleBasedCollator = this.getCollatorForCollation();
        this.cKey = ruleBasedCollator.getCollationKey(new String(this.rawData, 0, n2));
        return this.cKey;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value == null && this.rawLength != -1) {
            return new String(this.rawData, 0, this.rawLength);
        }
        if (this.stream != null) {
            try {
                return this.getString();
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        return this.value;
    }

    public int hashCode() {
        int n2;
        try {
            if (this.getString() == null) {
                return 0;
            }
        }
        catch (StandardException standardException) {
            return 0;
        }
        String string = this.value;
        for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == ' '; --n2) {
        }
        int n3 = 0;
        for (int i2 = 0; i2 <= n2; ++i2) {
            n3 = n3 * 31 + string.charAt(i2);
        }
        return n3;
    }

    int hashCodeForCollation() {
        CollationKey collationKey = null;
        try {
            collationKey = this.getCollationKey();
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return collationKey == null ? 0 : collationKey.hashCode();
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    protected void setLocaleFinder(LocaleFinder localeFinder) {
        this.localeFinder = localeFinder;
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected RuleBasedCollator getCollatorForCollation() throws StandardException {
        return null;
    }

    protected LocaleFinder getLocaleFinder() {
        DatabaseContext databaseContext;
        if (this.localeFinder == null && (databaseContext = (DatabaseContext)DataValueFactoryImpl.getContext("Database")) != null) {
            this.localeFinder = databaseContext.getDatabase();
        }
        return this.localeFinder;
    }

    @Override
    public int estimateMemoryUsage() {
        int n2 = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (null != this.rawData) {
            n2 += 2 * this.rawData.length;
        }
        return n2;
    }

    protected void copyState(SQLChar sQLChar) {
        this.copyState(sQLChar.value, sQLChar.rawData, sQLChar.rawLength, sQLChar.cKey, sQLChar.stream, sQLChar._clobValue, sQLChar.localeFinder);
    }

    private void copyState(String string, char[] cArray, int n2, CollationKey collationKey, InputStream inputStream, Clob clob, LocaleFinder localeFinder) {
        this.value = string;
        this.rawData = cArray;
        this.rawLength = n2;
        this.cKey = collationKey;
        this.stream = inputStream;
        this._clobValue = clob;
        this.localeFinder = localeFinder;
    }

    @Override
    public String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        return this.toString();
    }

    @Override
    public StreamHeaderGenerator getStreamHeaderGenerator() {
        return CHAR_HEADER_GENERATOR;
    }

    @Override
    public void setStreamHeaderFormat(Boolean bl) {
    }

    private int getClobLength() throws StandardException {
        try {
            return this.rawGetClobLength();
        }
        catch (SQLException sQLException) {
            throw StandardException.plainWrapException(sQLException);
        }
    }

    private int rawGetClobLength() throws SQLException {
        long l2 = Integer.MAX_VALUE;
        long l3 = this._clobValue.length();
        if (l3 > Integer.MAX_VALUE) {
            StandardException standardException = StandardException.newException("XJ093.S", Long.toString(l3), Long.toString(l2));
            throw new SQLException(standardException.getMessage());
        }
        return (int)l3;
    }

    static {
        for (int i2 = 0; i2 < BLANKS.length; ++i2) {
            SQLChar.BLANKS[i2] = 32;
        }
        CHAR_HEADER_GENERATOR = new CharStreamHeaderGenerator();
    }
}

