/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.Locale;

public class StringUtil {
    private static char[] hex_table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String formatForPrint(String string) {
        if (string.length() > 60) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, 60));
            stringBuffer.append("&");
            string = stringBuffer.toString();
        }
        return string;
    }

    public static String[] toStringArray(Object[] objectArray) {
        int n2 = objectArray.length;
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = objectArray[i2].toString();
        }
        return stringArray;
    }

    public static byte[] getAsciiBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            byArray[i2] = (byte)(cArray[i2] & 0x7F);
        }
        return byArray;
    }

    public static String trimTrailing(String string) {
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return string.substring(0, n2);
    }

    public static String truncate(String string, int n2) {
        if (string != null && string.length() > n2) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static String slice(String string, int n2, int n3, boolean bl) {
        String string2 = string.substring(n2, n3 + 1);
        if (bl) {
            string2 = string2.trim();
        }
        return string2;
    }

    public static String toHexString(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n5 = (byArray[i2] & 0xF0) >>> 4;
            int n6 = byArray[i2] & 0xF;
            stringBuffer.append(hex_table[n5]);
            stringBuffer.append(hex_table[n6]);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromHexString(String string, int n2, int n3) {
        if (n3 % 2 != 0) {
            return null;
        }
        byte[] byArray = new byte[n3 / 2];
        int n4 = 0;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; i2 += 2) {
            int n6 = Character.digit(string.charAt(i2), 16);
            int n7 = Character.digit(string.charAt(i2 + 1), 16);
            if (n6 == -1 || n7 == -1) {
                return null;
            }
            byArray[n4++] = (byte)(n6 << 4 & 0xF0 | n7 & 0xF);
        }
        return byArray;
    }

    public static String hexDump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        stringBuffer.append("Hex dump:\n");
        for (int i2 = 0; i2 < byArray.length; i2 += 16) {
            char c2;
            int n2;
            String string = Integer.toHexString(i2);
            for (n2 = string.length(); n2 < 8; ++n2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            stringBuffer.append(":");
            for (n2 = 0; n2 < 16 && i2 + n2 < byArray.length; ++n2) {
                byte by = byArray[i2 + n2];
                if (n2 % 2 == 0) {
                    stringBuffer.append(" ");
                }
                c2 = (char)((by & 0xF0) >>> 4);
                byte by2 = (byte)(by & 0xF);
                stringBuffer.append(hex_table[c2]);
                stringBuffer.append(hex_table[by2]);
            }
            stringBuffer.append("  ");
            for (n2 = 0; n2 < 16 && i2 + n2 < byArray.length; ++n2) {
                c2 = (char)byArray[i2 + n2];
                if (Character.isLetterOrDigit(c2)) {
                    stringBuffer.append(String.valueOf(c2));
                    continue;
                }
                stringBuffer.append(".");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String SQLToUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static boolean SQLEqualsIgnoreCase(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        return StringUtil.SQLToUpperCase(string).equals(StringUtil.SQLToUpperCase(string2));
    }

    public static String normalizeSQLIdentifier(String string) {
        if (string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.length() >= 3 && string.charAt(string.length() - 1) == '\"') {
            return StringUtil.compressQuotes(string.substring(1, string.length() - 1), "\"\"");
        }
        return StringUtil.SQLToUpperCase(string);
    }

    public static String compressQuotes(String string, String string2) {
        String string3 = string;
        int n2 = string3.indexOf(string2);
        while (n2 != -1) {
            string3 = string3.substring(0, n2 + 1) + string3.substring(n2 + 2);
            n2 = string3.indexOf(string2, n2 + 1);
        }
        return string3;
    }

    static String quoteString(String string, char c2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append(c2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) {
                stringBuffer.append(c2);
            }
            stringBuffer.append(c3);
        }
        stringBuffer.append(c2);
        return stringBuffer.toString();
    }

    public static String quoteStringLiteral(String string) {
        return StringUtil.quoteString(string, '\'');
    }

    public static String ensureIndent(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n2-- > 0) {
            stringBuffer.append("\t");
        }
        if (string == null) {
            return stringBuffer.toString() + "null";
        }
        string = StringUtil.doRegExpA(string, stringBuffer.toString());
        string = StringUtil.doRegExpB(string);
        string = StringUtil.doRegExpC(string, stringBuffer.toString());
        return string;
    }

    private static String doRegExpA(String string, String string2) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < string.length() && string.charAt(n2) == '\t'; ++n2) {
        }
        stringBuffer.append(string2);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static String doRegExpB(String string) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = string.length() - 1; n2 >= 0 && string.charAt(n2) == '\n'; --n2) {
        }
        stringBuffer.append(string.substring(0, n2 + 1));
        return stringBuffer.toString();
    }

    private static String doRegExpC(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\n') {
                int n3;
                stringBuffer.append(c2);
                for (n3 = n2 + 1; n3 < string.length() && string.charAt(n3) == '\t'; ++n3) {
                }
                stringBuffer.append(string2);
                n2 = n3;
                continue;
            }
            stringBuffer.append(c2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String shortDBName(String string, char c2) {
        int n2 = string.lastIndexOf(c2);
        return string.substring(n2 + 1);
    }
}

