/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public final class UTF8Util {
    private UTF8Util() {
    }

    public static final long skipUntilEOF(InputStream inputStream) throws IOException {
        return UTF8Util.internalSkip(inputStream, Long.MAX_VALUE).charsSkipped();
    }

    public static final long skipFully(InputStream inputStream, long l2) throws EOFException, IOException {
        SkipCount skipCount = UTF8Util.internalSkip(inputStream, l2);
        if (skipCount.charsSkipped() != l2) {
            throw new EOFException("Reached end-of-stream prematurely at character/byte position " + skipCount.charsSkipped() + "/" + skipCount.bytesSkipped() + ", trying to skip " + l2);
        }
        return skipCount.bytesSkipped();
    }

    private static final SkipCount internalSkip(InputStream inputStream, long l2) throws IOException {
        int n2;
        long l3 = 0L;
        long l4 = 0L;
        while (l3 < l2 && (n2 = inputStream.read()) != -1) {
            ++l3;
            if ((n2 & 0x80) == 0) {
                ++l4;
                continue;
            }
            if ((n2 & 0x60) == 64) {
                if (InputStreamUtil.skipPersistent(inputStream, 1L) != 1L) {
                    throw new UTFDataFormatException("Second byte in two byte character missing; byte pos " + l4 + " ; char pos " + l3);
                }
                l4 += 2L;
                continue;
            }
            if ((n2 & 0x70) == 96) {
                int n3 = 0;
                if (n2 == 224) {
                    int n4 = inputStream.read();
                    int n5 = inputStream.read();
                    if (n4 == 0 && n5 == 0) {
                        --l3;
                        break;
                    }
                    if (n4 != -1 && n5 != -1) {
                        n3 = 2;
                    }
                } else {
                    n3 = (int)InputStreamUtil.skipPersistent(inputStream, 2L);
                }
                if (n3 != 2) {
                    throw new UTFDataFormatException("Second or third byte in three byte character missing; byte pos " + l4 + " ; char pos " + l3);
                }
                l4 += 3L;
                continue;
            }
            throw new UTFDataFormatException("Invalid UTF-8 encoding encountered: (decimal) " + n2);
        }
        return new SkipCount(l3, l4);
    }

    private static final class SkipCount {
        private final long byteCount;
        private final long charCount;

        SkipCount(long l2, long l3) {
            if (l3 < 0L || l2 < 0L) {
                throw new IllegalArgumentException("charCount/byteCount cannot be negative: " + l2 + "/" + l3);
            }
            if (l3 < l2) {
                throw new IllegalArgumentException("Number of bytes cannot beless than number of chars: " + l3 + " < " + l2);
            }
            this.byteCount = l3;
            this.charCount = l2;
        }

        long charsSkipped() {
            return this.charCount;
        }

        long bytesSkipped() {
            return this.byteCount;
        }
    }
}

