/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.impl.io.CPStorageFactory;
import org.apache.derby.impl.io.InputStreamFile;
import org.apache.derby.io.StorageFile;

class CPFile
extends InputStreamFile<CPStorageFactory> {
    CPFile(CPStorageFactory cPStorageFactory, String string) {
        super(cPStorageFactory, string);
    }

    CPFile(CPStorageFactory cPStorageFactory, String string, String string2) {
        super(cPStorageFactory, string, string2);
    }

    CPFile(CPFile cPFile, String string) {
        super(cPFile, string);
    }

    private CPFile(CPStorageFactory cPStorageFactory, String string, int n2) {
        super(cPStorageFactory, string, n2);
    }

    @Override
    public boolean exists() {
        return this.getURL() != null;
    }

    @Override
    StorageFile getParentDir(int n2) {
        return new CPFile((CPStorageFactory)this.storageFactory, this.path, n2);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = null;
        ClassLoader classLoader = CPFile.getContextClassLoader(Thread.currentThread());
        if (classLoader != null) {
            inputStream = CPFile.getResourceAsStream(classLoader, this.path);
        }
        if (inputStream == null) {
            classLoader = this.getClass().getClassLoader();
            inputStream = classLoader != null ? CPFile.getResourceAsStream(classLoader, this.path) : CPFile.getSystemResourceAsStream(this.path);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(this.toString());
        }
        return inputStream;
    }

    private URL getURL() {
        URL uRL;
        ClassLoader classLoader = CPFile.getContextClassLoader(Thread.currentThread());
        if (classLoader != null && (uRL = CPFile.getResource(classLoader, this.path)) != null) {
            return uRL;
        }
        classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            return CPFile.getResource(classLoader, this.path);
        }
        return CPFile.getSystemResource(this.path);
    }

    private static ClassLoader getContextClassLoader(final Thread thread) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return thread.getContextClassLoader();
            }
        });
    }

    private static URL getResource(final ClassLoader classLoader, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return classLoader.getResource(string);
            }
        });
    }

    private static URL getSystemResource(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassLoader.getSystemResource(string);
            }
        });
    }

    private static InputStream getResourceAsStream(final ClassLoader classLoader, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return classLoader.getResourceAsStream(string);
            }
        });
    }

    private static InputStream getSystemResourceAsStream(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return ClassLoader.getSystemResourceAsStream(string);
            }
        });
    }
}

