/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayInputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArrayOutputStream;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.io.StorageRandomAccessFile;

public class VirtualRandomAccessFile
implements StorageRandomAccessFile {
    private final DataStoreEntry entry;
    private final boolean _readOnly;
    private long fp;
    private final BlockedByteArrayInputStream bIn;
    private final DataInputStream dIs;
    private final BlockedByteArrayOutputStream bOut;
    private final DataOutputStream dOs;

    public VirtualRandomAccessFile(DataStoreEntry dataStoreEntry, boolean bl) throws FileNotFoundException {
        this.entry = dataStoreEntry;
        this._readOnly = bl;
        this.bIn = dataStoreEntry.getInputStream();
        this.bIn.setPosition(0L);
        this.dIs = new DataInputStream(this.bIn);
        if (bl) {
            this.bOut = null;
            this.dOs = null;
        } else {
            this.bOut = dataStoreEntry.getOutputStream(true);
            this.bOut.setPosition(0L);
            this.dOs = new DataOutputStream(this.bOut);
        }
    }

    @Override
    public VirtualRandomAccessFile clone() {
        try {
            return new VirtualRandomAccessFile(this.entry, this._readOnly);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    @Override
    public void close() throws IOException {
        this.dIs.close();
        if (this.dOs != null) {
            this.dOs.close();
        }
        this.fp = Long.MIN_VALUE;
    }

    @Override
    public long getFilePointer() {
        return this.fp;
    }

    @Override
    public long length() {
        return this.entry.length();
    }

    @Override
    public void seek(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException("Negative position: " + l2);
        }
        this.fp = l2;
        this.bIn.setPosition(l2);
        if (this.bOut != null) {
            this.bOut.setPosition(l2);
        }
    }

    @Override
    public void setLength(long l2) {
        if (this.bOut == null) {
            throw new NullPointerException();
        }
        this.entry.setLength(l2);
        if (l2 < this.fp) {
            this.fp = l2;
        }
    }

    @Override
    public void sync() {
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bIn.read(byArray, n2, n3);
        this.fp = this.bIn.getPosition();
        return n4;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.dIs.readFully(byArray, n2, n3);
        this.fp = this.bIn.getPosition();
    }

    @Override
    public int skipBytes(int n2) {
        if (n2 <= 0) {
            return 0;
        }
        long l2 = Math.min((long)n2, this.entry.length() - this.fp);
        this.fp += l2;
        return (int)l2;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean bl = this.dIs.readBoolean();
        this.fp = this.bIn.getPosition();
        return bl;
    }

    @Override
    public byte readByte() throws IOException {
        byte by = this.dIs.readByte();
        this.fp = this.bIn.getPosition();
        return by;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int n2 = this.dIs.readUnsignedByte();
        this.fp = this.bIn.getPosition();
        return n2;
    }

    @Override
    public short readShort() throws IOException {
        short s2 = this.dIs.readShort();
        this.fp = this.bIn.getPosition();
        return s2;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int n2 = this.dIs.readUnsignedShort();
        this.fp = this.bIn.getPosition();
        return n2;
    }

    @Override
    public char readChar() throws IOException {
        char c2 = this.dIs.readChar();
        this.fp = this.bIn.getPosition();
        return c2;
    }

    @Override
    public int readInt() throws IOException {
        int n2 = this.dIs.readInt();
        this.fp = this.bIn.getPosition();
        return n2;
    }

    @Override
    public long readLong() throws IOException {
        long l2 = this.dIs.readLong();
        this.fp = this.bIn.getPosition();
        return l2;
    }

    @Override
    public float readFloat() throws IOException {
        float f2 = this.dIs.readFloat();
        this.fp = this.bIn.getPosition();
        return f2;
    }

    @Override
    public double readDouble() throws IOException {
        double d2 = this.dIs.readDouble();
        this.fp = this.bIn.getPosition();
        return d2;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    @Override
    public String readUTF() throws IOException {
        String string = this.dIs.readUTF();
        this.fp = this.bIn.getPosition();
        return string;
    }

    @Override
    public void write(int n2) throws IOException {
        this.dOs.write(n2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.dOs.write(byArray, n2, n3);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
        this.dOs.writeBoolean(bl);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeByte(int n2) throws IOException {
        this.dOs.writeByte(n2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeShort(int n2) throws IOException {
        this.dOs.writeShort(n2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeChar(int n2) throws IOException {
        this.dOs.writeChar(n2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.dOs.writeInt(n2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.dOs.writeLong(l2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeFloat(float f2) throws IOException {
        this.dOs.writeFloat(f2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeDouble(double d2) throws IOException {
        this.dOs.writeDouble(d2);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeBytes(String string) throws IOException {
        this.dOs.writeBytes(string);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeChars(String string) throws IOException {
        this.dOs.writeChars(string);
        this.fp = this.bOut.getPosition();
    }

    @Override
    public void writeUTF(String string) throws IOException {
        this.dOs.writeUTF(string);
        this.fp = this.bOut.getPosition();
    }
}

