/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;

public class LOBOutputStream
extends OutputStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;

    LOBOutputStream(LOBStreamControl lOBStreamControl, long l2) {
        this.control = lOBStreamControl;
        this.pos = l2;
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            this.pos = this.control.write(n2, this.pos);
        }
        catch (StandardException standardException) {
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            this.pos = this.control.write(byArray, n2, n3, this.pos);
        }
        catch (StandardException standardException) {
            if (standardException.getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(standardException.getMessage());
            }
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

