/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.iapi.types.Resetable;

public class PositionedStoreStream
extends InputStream
implements PositionedStream,
Resetable {
    private final InputStream stream;
    private long pos = 0L;

    public PositionedStoreStream(InputStream inputStream) throws IOException, StandardException {
        this.stream = inputStream;
        ((Resetable)((Object)inputStream)).initStream();
        ((Resetable)((Object)inputStream)).resetStream();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.stream.read(byArray, n2, n3);
        if (n4 > -1) {
            this.pos += (long)n4;
        }
        return n4;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.stream.read();
        if (n2 > -1) {
            ++this.pos;
        }
        return n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = this.stream.skip(l2);
        this.pos += l3;
        return l3;
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.stream)).resetStream();
        this.pos = 0L;
    }

    @Override
    public void initStream() throws StandardException {
        ((Resetable)((Object)this.stream)).initStream();
    }

    @Override
    public void closeStream() {
        ((Resetable)((Object)this.stream)).closeStream();
    }

    @Override
    public void reposition(long l2) throws IOException, StandardException {
        if (this.pos > l2) {
            this.resetStream();
        }
        if (this.pos < l2) {
            try {
                InputStreamUtil.skipFully(this.stream, l2 - this.pos);
            }
            catch (EOFException eOFException) {
                this.resetStream();
                throw eOFException;
            }
            this.pos = l2;
        }
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public InputStream asInputStream() {
        return this;
    }
}

