/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.Util;

public final class UTF8Reader
extends Reader {
    private static final String READER_CLOSED = "Reader closed";
    private static final int MAXIMUM_BUFFER_SIZE = 8192;
    private InputStream in;
    private final PositionedStream positionedIn;
    private long rawStreamPos = 0L;
    private long utfCount;
    private long readerCharCount;
    private final char[] buffer;
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;
    private final CharacterStreamDescriptor csd;

    public UTF8Reader(CharacterStreamDescriptor characterStreamDescriptor, ConnectionChild connectionChild, Object object) throws IOException {
        super(object);
        this.csd = characterStreamDescriptor;
        this.positionedIn = characterStreamDescriptor.isPositionAware() ? characterStreamDescriptor.getPositionedStream() : null;
        this.parent = connectionChild;
        int n2 = this.calculateBufferSize(characterStreamDescriptor);
        this.buffer = new char[n2];
        if (characterStreamDescriptor.isPositionAware()) {
            this.rawStreamPos = this.positionedIn.getPosition();
            if (this.rawStreamPos < characterStreamDescriptor.getDataOffset()) {
                this.rawStreamPos = characterStreamDescriptor.getDataOffset();
            }
        } else if (characterStreamDescriptor.getCurBytePos() < characterStreamDescriptor.getDataOffset()) {
            characterStreamDescriptor.getStream().skip(characterStreamDescriptor.getDataOffset() - characterStreamDescriptor.getCurBytePos());
        }
        this.in = characterStreamDescriptor.isBufferable() ? new BufferedInputStream(characterStreamDescriptor.getStream(), n2) : characterStreamDescriptor.getStream();
        this.utfCount = characterStreamDescriptor.getDataOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n4 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n3 > n4) {
                n3 = n4;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cArray, n2, n3);
            this.readPositionInBuffer += n3;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + l2);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return 0L;
            }
            int n2 = this.charactersInBuffer - this.readPositionInBuffer;
            if (l2 > (long)n2) {
                l2 = n2;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l2);
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuffer stringBuffer, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n3 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n2 > n3) {
                n2 = n3;
            }
            stringBuffer.append(this.buffer, this.readPositionInBuffer, n2);
            this.readPositionInBuffer += n2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] byArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n4 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n3 > n4) {
                n3 = n4;
            }
            char[] cArray = this.buffer;
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = cArray[this.readPositionInBuffer + i2];
                int n5 = c2 <= '\u00ff' ? (int)((byte)c2) : 63;
                byArray[n2 + i2] = n5;
            }
            this.readPositionInBuffer += n3;
            return n3;
        }
    }

    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String string) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        this.readPositionInBuffer = 0;
        try {
            try {
                int n2;
                this.parent.setupContextStack();
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException standardException) {
                        throw Util.generateCsSQLException(standardException);
                    }
                }
                long l2 = this.csd.getByteLength();
                long l3 = this.csd.getMaxCharLength();
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= l2 && l2 != 0L || l3 != 0L && this.readerCharCount >= l3)) {
                    int n3;
                    n2 = this.in.read();
                    if (n2 == -1) {
                        if (l2 != 0L) throw this.utfFormatException("Reached EOF prematurely, read " + this.utfCount + " out of " + l2 + " bytes");
                        if (this.csd.isPositionAware()) break;
                        this.closeIn();
                        break;
                    }
                    switch (n2 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            n3 = n2;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int n4 = this.in.read();
                            if (n4 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second byte in a two byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if ((n4 & 0xC0) != 128) {
                                throw this.utfFormatException("Second byte in a two bytecharacter encoding invalid: (int)" + n4 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n3 = (n2 & 0x1F) << 6 | n4 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int n4 = this.in.read();
                            int n5 = this.in.read();
                            if (n4 == -1) throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            if (n5 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if (n2 == 224 && n4 == 0 && n5 == 0) {
                                if (l2 != 0L) throw this.utfFormatException("Internal error: Derby-specific EOF marker read");
                                if (this.csd.isPositionAware()) break block13;
                                this.closeIn();
                                break block13;
                            }
                            if ((n4 & 0xC0) != 128) throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n4 + "/" + n5 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            if ((n5 & 0xC0) != 128) {
                                throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n4 + "/" + n5 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n3 = (n2 & 0xF) << 12 | (n4 & 0x3F) << 6 | (n5 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException("Invalid UTF encoding at byte/char position " + this.utfCount + "/" + this.readerCharCount + ": (int)" + n2);
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)n3;
                    ++this.readerCharCount;
                }
                if (l2 != 0L && this.utfCount > l2) {
                    throw this.utfFormatException("Incorrect encoded length in stream, expected " + l2 + ", have " + this.utfCount + " bytes");
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    n2 = 0;
                    return n2 != 0;
                }
                if (!this.csd.isPositionAware()) {
                    this.closeIn();
                }
                n2 = 1;
                return n2 != 0;
            }
            finally {
                ConnectionChild.restoreIntrFlagIfSeen(true, this.parent.getEmbedConnection());
                this.parent.restoreContextStack();
            }
        }
        catch (SQLException sQLException) {
            throw Util.newIOException(sQLException);
        }
    }

    private void resetUTF8Reader() throws IOException, StandardException {
        this.positionedIn.reposition(this.csd.getDataOffset());
        this.utfCount = this.rawStreamPos = this.positionedIn.getPosition();
        if (this.csd.isBufferable()) {
            this.in = new BufferedInputStream(this.csd.getStream(), this.buffer.length);
        }
        this.readerCharCount = 0L;
        this.readPositionInBuffer = 0;
        this.charactersInBuffer = 0;
    }

    void reposition(long l2) throws IOException, StandardException {
        long l3;
        long l4;
        if (l2 <= this.readerCharCount - (long)this.charactersInBuffer) {
            this.resetUTF8Reader();
        }
        if ((l4 = l2 - 1L - (l3 = this.readerCharCount - (long)this.charactersInBuffer + (long)this.readPositionInBuffer)) <= 0L) {
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l4);
        } else {
            this.persistentSkip(l4);
        }
    }

    private final int calculateBufferSize(CharacterStreamDescriptor characterStreamDescriptor) {
        int n2 = 8192;
        long l2 = characterStreamDescriptor.getCharLength();
        long l3 = characterStreamDescriptor.getMaxCharLength();
        if (l2 < 1L) {
            l2 = characterStreamDescriptor.getByteLength();
        }
        if (l2 > 0L && l2 < (long)n2) {
            n2 = (int)l2;
        }
        if (l3 > 0L && l3 < (long)n2) {
            n2 = (int)l3;
        }
        return n2;
    }

    private final void persistentSkip(long l2) throws IOException {
        long l3;
        for (long i2 = l2; i2 > 0L; i2 -= l3) {
            l3 = this.skip(i2);
            if (l3 != 0L) continue;
            throw new EOFException();
        }
    }
}

