/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.List;
import java.util.Map;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.LockControl;

class Lock
implements Latch,
Control {
    private final CompatibilitySpace space;
    private final Lockable ref;
    private final Object qualifier;
    int count;

    protected Lock(CompatibilitySpace compatibilitySpace, Lockable lockable, Object object) {
        this.space = compatibilitySpace;
        this.ref = lockable;
        this.qualifier = object;
    }

    @Override
    public final Lockable getLockable() {
        return this.ref;
    }

    @Override
    public final CompatibilitySpace getCompatabilitySpace() {
        return this.space;
    }

    @Override
    public final Object getQualifier() {
        return this.qualifier;
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    final Lock copy() {
        return new Lock(this.space, this.ref, this.qualifier);
    }

    void grant() {
        ++this.count;
        this.ref.lockEvent(this);
    }

    int unlock(int n2) {
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.count -= n2;
        if (this.count == 0) {
            this.ref.unlockEvent(this);
        }
        return n2;
    }

    public final int hashCode() {
        return this.ref.hashCode() ^ this.space.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof Lock) {
            Lock lock = (Lock)object;
            return this.space == lock.space && this.ref.equals(lock.ref) && this.qualifier == lock.qualifier;
        }
        return false;
    }

    @Override
    public LockControl getLockControl() {
        return new LockControl(this, this.ref);
    }

    @Override
    public Lock getLock(CompatibilitySpace compatibilitySpace, Object object) {
        if (this.space == compatibilitySpace && this.qualifier == object) {
            return this;
        }
        return null;
    }

    @Override
    public Control shallowClone() {
        return this;
    }

    @Override
    public ActiveLock firstWaiter() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean unlock(Latch latch, int n2) {
        if (n2 == 0) {
            n2 = latch.getCount();
        }
        this.unlock(n2);
        return false;
    }

    public void addWaiters(Map map) {
    }

    @Override
    public Lock getFirstGrant() {
        return this;
    }

    @Override
    public List getGranted() {
        return null;
    }

    @Override
    public List getWaiting() {
        return null;
    }

    @Override
    public boolean isGrantable(boolean bl, CompatibilitySpace compatibilitySpace, Object object) {
        if (this.space == compatibilitySpace && this.ref.lockerAlwaysCompatible()) {
            return true;
        }
        return this.ref.requestCompatible(object, this.qualifier);
    }
}

