/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericParameter;

final class GenericParameterValueSet
implements ParameterValueSet {
    private final GenericParameter[] parms;
    final ClassInspector ci;
    private final boolean hasReturnOutputParam;

    GenericParameterValueSet(ClassInspector classInspector, int n2, boolean bl) {
        this.ci = classInspector;
        this.hasReturnOutputParam = bl;
        this.parms = new GenericParameter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parms[i2] = new GenericParameter(this, bl && i2 == 0);
        }
    }

    private GenericParameterValueSet(int n2, GenericParameterValueSet genericParameterValueSet) {
        this.hasReturnOutputParam = genericParameterValueSet.hasReturnOutputParam;
        this.ci = genericParameterValueSet.ci;
        this.parms = new GenericParameter[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parms[i2] = genericParameterValueSet.getGenericParameter(i2).getClone(this);
        }
    }

    @Override
    public void initialize(DataTypeDescriptor[] dataTypeDescriptorArray) throws StandardException {
        for (int i2 = 0; i2 < this.parms.length; ++i2) {
            DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[i2];
            this.parms[i2].initialize(dataTypeDescriptor.getNull(), dataTypeDescriptor.getJDBCTypeId(), dataTypeDescriptor.getTypeId().getCorrespondingJavaTypeName());
        }
    }

    @Override
    public void setParameterMode(int n2, int n3) {
        this.parms[n2].parameterMode = (short)n3;
    }

    @Override
    public void clearParameters() {
        for (int i2 = 0; i2 < this.parms.length; ++i2) {
            this.parms[i2].clear();
        }
    }

    @Override
    public int getParameterCount() {
        return this.parms.length;
    }

    @Override
    public DataValueDescriptor getParameter(int n2) throws StandardException {
        try {
            return this.parms[n2].getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n2);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getParameterForSet(int n2) throws StandardException {
        try {
            GenericParameter genericParameter = this.parms[n2];
            if (genericParameter.parameterMode == 4) {
                throw StandardException.newException("XCL27.S", new Object[0]);
            }
            genericParameter.isSet = true;
            return genericParameter.getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n2);
            return null;
        }
    }

    @Override
    public DataValueDescriptor getParameterForGet(int n2) throws StandardException {
        try {
            GenericParameter genericParameter = this.parms[n2];
            switch (genericParameter.parameterMode) {
                case 0: 
                case 1: {
                    throw StandardException.newException("XCL26.S", Integer.toString(n2 + 1));
                }
            }
            return genericParameter.getValue();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.checkPosition(n2);
            return null;
        }
    }

    @Override
    public void setParameterAsObject(int n2, Object object) throws StandardException {
        UserDataValue userDataValue = (UserDataValue)this.getParameterForSet(n2);
        GenericParameter genericParameter = this.parms[n2];
        if (object != null) {
            boolean bl;
            ClassNotFoundException classNotFoundException = null;
            try {
                bl = !this.ci.instanceOf(genericParameter.declaredClassName, object);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                classNotFoundException = classNotFoundException2;
                bl = true;
            }
            if (bl) {
                throw StandardException.newException("XCL12.S", classNotFoundException, ClassInspector.readableClassName(object.getClass()), genericParameter.declaredClassName);
            }
        }
        userDataValue.setValue(object);
    }

    @Override
    public boolean allAreSet() {
        block4: for (int i2 = 0; i2 < this.parms.length; ++i2) {
            GenericParameter genericParameter = this.parms[i2];
            if (genericParameter.isSet) continue;
            switch (genericParameter.parameterMode) {
                case 4: {
                    continue block4;
                }
                case 0: 
                case 1: 
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void transferDataValues(ParameterValueSet parameterValueSet) throws StandardException {
        int n2;
        for (int i2 = n2 = parameterValueSet.hasReturnOutputParameter() ? 1 : 0; i2 < this.parms.length; ++i2) {
            GenericParameter genericParameter = this.parms[i2];
            if (genericParameter.registerOutType != 0) {
                parameterValueSet.registerOutParameter(i2, genericParameter.registerOutType, genericParameter.registerOutScale);
            }
            if (!genericParameter.isSet) continue;
            DataValueDescriptor dataValueDescriptor = genericParameter.getValue();
            Object var6_6 = null;
            if (dataValueDescriptor.hasStream()) {
                parameterValueSet.getParameterForSet(i2).setValue(dataValueDescriptor.getStream(), -1);
                continue;
            }
            parameterValueSet.getParameterForSet(i2).setValue(dataValueDescriptor);
        }
    }

    GenericParameter getGenericParameter(int n2) {
        return this.parms[n2];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.parms.length; ++i2) {
            stringBuffer.append("begin parameter #" + (i2 + 1) + ": ");
            stringBuffer.append(this.parms[i2].toString());
            stringBuffer.append(" :end parameter ");
        }
        return stringBuffer.toString();
    }

    private void checkPosition(int n2) throws StandardException {
        if (n2 < 0 || n2 >= this.parms.length) {
            if (this.parms.length == 0) {
                throw StandardException.newException("07009", new Object[0]);
            }
            throw StandardException.newException("XCL13.S", String.valueOf(n2 + 1), String.valueOf(this.parms.length));
        }
    }

    @Override
    public ParameterValueSet getClone() {
        return new GenericParameterValueSet(this.parms.length, this);
    }

    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws StandardException {
        this.checkPosition(n2);
        Util.checkSupportedRaiseStandard(n3);
        this.parms[n2].setOutParameter(n3, n4);
    }

    @Override
    public void validate() throws StandardException {
        for (int i2 = 0; i2 < this.parms.length; ++i2) {
            this.parms[i2].validate();
        }
    }

    public int getParameterNumber(GenericParameter genericParameter) {
        for (int i2 = 0; i2 < this.parms.length; ++i2) {
            if (this.parms[i2] != genericParameter) continue;
            return i2 + 1;
        }
        return 0;
    }

    @Override
    public boolean checkNoDeclaredOutputParameters() {
        boolean bl = false;
        block5: for (int i2 = 0; i2 < this.parms.length; ++i2) {
            GenericParameter genericParameter = this.parms[i2];
            switch (genericParameter.parameterMode) {
                case 1: {
                    continue block5;
                }
                case 2: 
                case 4: {
                    bl = true;
                    continue block5;
                }
                case 0: {
                    genericParameter.parameterMode = 1;
                }
            }
        }
        return bl;
    }

    @Override
    public short getParameterMode(int n2) {
        short s2 = this.parms[n2 - 1].parameterMode;
        return s2;
    }

    @Override
    public boolean hasReturnOutputParameter() {
        return this.hasReturnOutputParam;
    }

    @Override
    public DataValueDescriptor getReturnValueForSet() throws StandardException {
        this.checkPosition(0);
        return this.parms[0].getValue();
    }

    @Override
    public int getScale(int n2) {
        return this.parms[n2 - 1].getScale();
    }

    @Override
    public int getPrecision(int n2) {
        return this.parms[n2 - 1].getPrecision();
    }
}

