/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

class BaseTableNumbersVisitor
implements Visitor {
    private JBitSet tableMap;
    private int columnNumber;

    BaseTableNumbersVisitor(JBitSet jBitSet) {
        this.tableMap = jBitSet;
        this.columnNumber = -1;
    }

    protected void setTableMap(JBitSet jBitSet) {
        this.tableMap = jBitSet;
    }

    protected void reset() {
        this.tableMap.clearAll();
        this.columnNumber = -1;
    }

    protected int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public Visitable visit(Visitable visitable) throws StandardException {
        ResultColumn resultColumn = null;
        if (visitable instanceof ColumnReference) {
            resultColumn = ((ColumnReference)visitable).getSource();
            if (resultColumn == null) {
                return visitable;
            }
        } else if (visitable instanceof ResultColumn) {
            resultColumn = (ResultColumn)visitable;
        } else if (visitable instanceof SelectNode) {
            ((SelectNode)visitable).getFromList().accept(this);
        } else if (visitable instanceof FromBaseTable) {
            this.tableMap.set(((FromBaseTable)visitable).getTableNumber());
        }
        if (resultColumn != null) {
            int n2 = resultColumn.getTableNumber();
            if (n2 >= 0) {
                ValueNode valueNode = resultColumn.getExpression();
                while (valueNode instanceof VirtualColumnNode) {
                    resultColumn = ((VirtualColumnNode)valueNode).getSourceColumn();
                    valueNode = resultColumn.getExpression();
                }
                if (valueNode instanceof ColumnReference) {
                    valueNode.accept(this);
                } else {
                    this.tableMap.set(n2);
                    this.columnNumber = resultColumn.getColumnPosition();
                }
            } else if (visitable instanceof ColumnReference) {
                ColumnReference columnReference = (ColumnReference)visitable;
                columnReference.getTablesReferenced(this.tableMap);
                this.columnNumber = columnReference.getColumnNumber();
            }
        }
        return visitable;
    }

    @Override
    public boolean skipChildren(Visitable visitable) {
        return visitable instanceof FromBaseTable || visitable instanceof SelectNode || visitable instanceof PredicateList;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable visitable) {
        return false;
    }
}

