/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class BitConstantNode
extends ConstantNode {
    BitConstantNode(TypeId typeId, ContextManager contextManager) throws StandardException {
        super(typeId, true, 0, contextManager);
    }

    BitConstantNode(String string, int n2, ContextManager contextManager) throws StandardException {
        super(TypeId.getBuiltInTypeId(-2), false, n2, contextManager);
        byte[] byArray = StringUtil.fromHexString(string, 0, string.length());
        BitDataValue bitDataValue = this.getDataValueFactory().getBitDataValue(byArray);
        bitDataValue.setWidth(n2, 0, false);
        this.setValue(bitDataValue);
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        return this.value.getBytes();
    }

    @Override
    void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        byte[] byArray = this.value.getBytes();
        String string = StringUtil.toHexString(byArray, 0, byArray.length);
        methodBuilder.push(string);
        methodBuilder.push(0);
        methodBuilder.push(string.length());
        methodBuilder.callMethod((short)184, "org.apache.derby.iapi.util.StringUtil", "fromHexString", "byte[]", 3);
    }
}

