/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;

class CreateTableNode
extends DDLStatementNode {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private Properties properties;
    private TableElementList tableElementList;
    protected int tableType;
    private ResultColumnList resultColumns;
    private ResultSetNode queryExpression;

    CreateTableNode(TableName tableName, TableElementList tableElementList, Properties properties, char c2, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.tableType = 0;
        this.lockGranularity = c2;
        this.implicitCreateSchema = true;
        this.tableElementList = tableElementList;
        this.properties = properties;
    }

    CreateTableNode(TableName tableName, TableElementList tableElementList, Properties properties, boolean bl, boolean bl2, ContextManager contextManager) throws StandardException {
        super(CreateTableNode.tempTableSchemaNameCheck(tableName), contextManager);
        this.tableType = 3;
        this.onCommitDeleteRows = bl;
        this.onRollbackDeleteRows = bl2;
        this.tableElementList = tableElementList;
        this.properties = properties;
    }

    CreateTableNode(TableName tableName, ResultColumnList resultColumnList, ResultSetNode resultSetNode, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.tableType = 0;
        this.lockGranularity = (char)82;
        this.implicitCreateSchema = true;
        this.resultColumns = resultColumnList;
        this.queryExpression = resultSetNode;
    }

    private static TableName tempTableSchemaNameCheck(TableName tableName) throws StandardException {
        if (tableName != null) {
            if (tableName.getSchemaName() == null) {
                tableName.setSchemaName("SESSION");
            } else if (!CreateTableNode.isSessionSchema(tableName.getSchemaName())) {
                throw StandardException.newException("428EK", new Object[0]);
            }
        }
        return tableName;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    String statementToString() {
        if (this.tableType == 3) {
            return "DECLARE GLOBAL TEMPORARY TABLE";
        }
        return "CREATE TABLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        Object object;
        FromList fromList;
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.tableType != 3, true);
        if (this.queryExpression != null) {
            fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            object = this.getCompilerContext();
            ProviderList providerList = object.getCurrentAuxiliaryProviderList();
            ProviderList providerList2 = new ProviderList();
            try {
                object.setCurrentAuxiliaryProviderList(providerList2);
                object.pushCurrentPrivType(0);
                this.queryExpression = this.queryExpression.bindNonVTITables(dataDictionary, fromList);
                this.queryExpression = this.queryExpression.bindVTITables(fromList);
                this.queryExpression.bindExpressions(fromList);
                this.queryExpression.bindResultColumns(fromList);
                this.queryExpression.bindUntypedNullsToResultColumns(null);
            }
            finally {
                object.popCurrentPrivType();
                object.setCurrentAuxiliaryProviderList(providerList);
            }
            ResultColumnList resultColumnList = this.queryExpression.getResultColumns();
            if (this.resultColumns != null) {
                if (this.resultColumns.size() != resultColumnList.visibleSize()) {
                    throw StandardException.newException("42X70", this.getFullName());
                }
                resultColumnList.copyResultColumnNames(this.resultColumns);
            }
            int n2 = schemaDescriptor.getCollationType();
            this.tableElementList = new TableElementList(this.getContextManager());
            for (ResultColumn resultColumn : resultColumnList) {
                if (resultColumn.isGenerated()) continue;
                if (resultColumn.isNameGenerated()) {
                    throw StandardException.newException("42909", new Object[0]);
                }
                DataTypeDescriptor dataTypeDescriptor = resultColumn.getExpression().getTypeServices();
                if (dataTypeDescriptor != null && !dataTypeDescriptor.isUserCreatableType()) {
                    throw StandardException.newException("42X71", dataTypeDescriptor.getFullSQLTypeName(), resultColumn.getName());
                }
                if (dataTypeDescriptor.getTypeId().isStringTypeId() && dataTypeDescriptor.getCollationType() != n2) {
                    throw StandardException.newException("42ZA3", dataTypeDescriptor.getCollationName(), DataTypeDescriptor.getCollationName(n2));
                }
                ColumnDefinitionNode columnDefinitionNode = new ColumnDefinitionNode(resultColumn.getName(), null, resultColumn.getType(), null, this.getContextManager());
                this.tableElementList.addTableElement(columnDefinitionNode);
            }
        } else {
            this.tableElementList.setCollationTypesOnCharacterStringColumns(this.getSchemaDescriptor(this.tableType != 3, true));
        }
        this.tableElementList.validate(this, dataDictionary, null);
        if (this.tableElementList.countNumberOfColumns() > 1012) {
            throw StandardException.newException("54011", String.valueOf(this.tableElementList.countNumberOfColumns()), this.getRelativeName(), String.valueOf(1012));
        }
        int n3 = this.tableElementList.countConstraints(2);
        if (n3 > 1) {
            throw StandardException.newException("42X90", this.getRelativeName());
        }
        int n4 = this.tableElementList.countConstraints(4);
        int n5 = this.tableElementList.countConstraints(6);
        int n6 = this.tableElementList.countConstraints(3);
        int n7 = this.tableElementList.countGenerationClauses();
        if (this.tableType == 3 && (n3 > 0 || n4 > 0 || n5 > 0 || n6 > 0)) {
            throw StandardException.newException("42995", new Object[0]);
        }
        if (n3 + n5 + n6 > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(n3 + n5 + n6), this.getRelativeName(), String.valueOf(Short.MAX_VALUE));
        }
        if (n4 > 0 || n7 > 0 || n5 > 0) {
            fromList = this.makeFromList(null, this.tableElementList, true);
            object = new FormatableBitSet();
            if (n7 > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(schemaDescriptor, fromList, (FormatableBitSet)object, null);
            }
            if (n4 > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (n5 > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, (FormatableBitSet)object);
            }
        }
        if (n3 > 0) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.getSchemaDescriptor(this.tableType != 3, true));
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        TableElementList tableElementList = this.tableElementList;
        ColumnInfo[] columnInfoArray = new ColumnInfo[tableElementList.countNumberOfColumns()];
        int n2 = tableElementList.genColumnInfos(columnInfoArray);
        ConstraintConstantAction[] constraintConstantActionArray = null;
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.tableType != 3, true);
        if (n2 > 0) {
            constraintConstantActionArray = new CreateConstraintConstantAction[n2];
            tableElementList.genConstraintActions(true, constraintConstantActionArray, this.getRelativeName(), schemaDescriptor, this.getDataDictionary());
        }
        boolean bl = false;
        int n3 = 0;
        for (int i2 = 0; i2 < columnInfoArray.length; ++i2) {
            DataTypeDescriptor dataTypeDescriptor = columnInfoArray[i2].getDataType();
            if (dataTypeDescriptor.getTypeId().isLongConcatableTypeId()) {
                bl = true;
                break;
            }
            n3 += dataTypeDescriptor.getTypeId().getApproximateLengthInBytes(dataTypeDescriptor);
        }
        if (!(!bl && n3 <= 4096 || this.properties != null && this.properties.get("derby.storage.pageSize") != null || PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.storage.pageSize") != null)) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put("derby.storage.pageSize", "32768");
        }
        return this.getGenericConstantActionFactory().getCreateTableConstantAction(schemaDescriptor.getSchemaName(), this.getRelativeName(), this.tableType, columnInfoArray, (CreateConstraintConstantAction[])constraintConstantActionArray, this.properties, this.lockGranularity, this.onCommitDeleteRows, this.onRollbackDeleteRows);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableElementList != null) {
            this.tableElementList.accept(visitor);
        }
    }
}

