/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

class OrNode
extends BinaryLogicalOperatorNode {
    private boolean firstOr;

    OrNode(ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) {
        super(valueNode, valueNode2, "or", contextManager);
        this.shortCircuitValue = true;
    }

    void setFirstOr() {
        this.firstOr = true;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        this.postBindFixup();
        return this;
    }

    @Override
    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        super.preprocess(n2, fromList, subqueryList, predicateList);
        if (this.firstOr) {
            BinaryRelationalOperatorNode binaryRelationalOperatorNode;
            QueryTreeNode queryTreeNode;
            ValueNode valueNode;
            boolean bl = true;
            ColumnReference columnReference = null;
            int n3 = -1;
            int n4 = -1;
            ValueNode valueNode2 = this;
            while (valueNode2 instanceof OrNode && ((valueNode = ((BinaryOperatorNode)(queryTreeNode = valueNode2)).getLeftOperand()).isRelationalOperator() || (bl = valueNode instanceof BinaryRelationalOperatorNode))) {
                if (((RelationalOperator)((Object)valueNode)).getOperator() != 1) {
                    bl = false;
                    break;
                }
                binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)valueNode;
                if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
                    columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
                    if (n4 == -1) {
                        n4 = columnReference.getTableNumber();
                        n3 = columnReference.getColumnNumber();
                    } else if (n4 != columnReference.getTableNumber() || n3 != columnReference.getColumnNumber()) {
                        bl = false;
                        break;
                    }
                } else if (binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference) {
                    columnReference = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
                    if (n4 == -1) {
                        n4 = columnReference.getTableNumber();
                        n3 = columnReference.getColumnNumber();
                    } else if (n4 != columnReference.getTableNumber() || n3 != columnReference.getColumnNumber()) {
                        bl = false;
                        break;
                    }
                } else {
                    bl = false;
                    break;
                }
                valueNode2 = valueNode2.getRightOperand();
            }
            boolean bl2 = bl = bl && valueNode2.isBooleanFalse();
            if (bl) {
                queryTreeNode = new ValueNodeList(this.getContextManager());
                valueNode2 = this;
                while (valueNode2 instanceof OrNode) {
                    valueNode = valueNode2;
                    binaryRelationalOperatorNode = (BinaryRelationalOperatorNode)((BinaryOperatorNode)valueNode).getLeftOperand();
                    if (binaryRelationalOperatorNode.isInListProbeNode()) {
                        ((QueryTreeNodeVector)queryTreeNode).destructiveAppend(binaryRelationalOperatorNode.getInListOp().getRightOperandList());
                    } else if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
                        ((ValueNodeList)queryTreeNode).addValueNode(binaryRelationalOperatorNode.getRightOperand());
                    } else {
                        ((ValueNodeList)queryTreeNode).addValueNode(binaryRelationalOperatorNode.getLeftOperand());
                    }
                    valueNode2 = valueNode2.getRightOperand();
                }
                valueNode = new InListOperatorNode(columnReference, (ValueNodeList)queryTreeNode, this.getContextManager());
                valueNode.setType(this.getTypeServices());
                return ((InListOperatorNode)valueNode).preprocess(n2, fromList, subqueryList, predicateList);
            }
        }
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean bl) throws StandardException {
        this.leftOperand = this.leftOperand.eliminateNots(bl);
        this.rightOperand = this.rightOperand.eliminateNots(bl);
        if (!bl) {
            return this;
        }
        AndNode andNode = new AndNode(this.leftOperand, this.rightOperand, this.getContextManager());
        andNode.setType(this.getTypeServices());
        return andNode;
    }

    @Override
    ValueNode changeToCNF(boolean bl) throws StandardException {
        ValueNode valueNode;
        OrNode orNode = this;
        if (this.rightOperand instanceof AndNode) {
            valueNode = new BooleanConstantNode(false, this.getContextManager());
            this.rightOperand = new OrNode(this.rightOperand, valueNode, this.getContextManager());
            ((OrNode)this.rightOperand).postBindFixup();
        }
        while (orNode.getRightOperand() instanceof OrNode) {
            orNode = (OrNode)orNode.getRightOperand();
        }
        if (!orNode.getRightOperand().isBooleanFalse()) {
            valueNode = new BooleanConstantNode(false, this.getContextManager());
            orNode.setRightOperand(new OrNode(orNode.getRightOperand(), valueNode, this.getContextManager()));
            ((OrNode)orNode.getRightOperand()).postBindFixup();
        }
        while (this.leftOperand instanceof OrNode) {
            valueNode = ((OrNode)this.leftOperand).getLeftOperand();
            OrNode orNode2 = (OrNode)this.leftOperand;
            OrNode orNode3 = (OrNode)this.leftOperand;
            ValueNode valueNode2 = this.rightOperand;
            this.leftOperand = valueNode;
            this.rightOperand = orNode3;
            orNode3.setLeftOperand(orNode2.getRightOperand());
            orNode3.setRightOperand(valueNode2);
        }
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    @Override
    boolean verifyChangeToCNF() {
        boolean bl = true;
        return bl;
    }

    void postBindFixup() throws StandardException {
        this.setType(this.resolveLogicalBinaryOperator(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
    }
}

