/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class QueryTreeNodeVector<E extends QueryTreeNode>
extends QueryTreeNode
implements Iterable<E> {
    private final ArrayList<E> v = new ArrayList();
    final Class<E> eltClass;

    QueryTreeNodeVector(Class<E> clazz, ContextManager contextManager) {
        super(contextManager);
        this.eltClass = clazz;
    }

    public final int size() {
        return this.v.size();
    }

    final E elementAt(int n2) {
        return (E)((QueryTreeNode)this.v.get(n2));
    }

    void addElement(E e2) {
        this.v.add(e2);
    }

    final E removeElementAt(int n2) {
        return (E)((QueryTreeNode)this.v.remove(n2));
    }

    final void removeElement(E e2) {
        this.v.remove(e2);
    }

    final int indexOf(E e2) {
        return this.v.indexOf(e2);
    }

    final void setElementAt(E e2, int n2) {
        this.v.set(n2, e2);
    }

    final void destructiveAppend(QueryTreeNodeVector<E> queryTreeNodeVector) {
        this.nondestructiveAppend(queryTreeNodeVector);
        queryTreeNodeVector.removeAllElements();
    }

    final void nondestructiveAppend(QueryTreeNodeVector<E> queryTreeNodeVector) {
        this.v.addAll(queryTreeNodeVector.v);
    }

    final void removeAllElements() {
        this.v.clear();
    }

    final void insertElementAt(E e2, int n2) {
        this.v.add(n2, e2);
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Visitable visitable = ((QueryTreeNode)this.elementAt(i2)).accept(visitor);
            this.setElementAt((QueryTreeNode)this.eltClass.cast(visitable), i2);
        }
    }

    @Override
    public final Iterator<E> iterator() {
        return this.v.iterator();
    }
}

