/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

class ValueNodeList
extends QueryTreeNodeVector<ValueNode> {
    ValueNodeList(ContextManager contextManager) {
        super(ValueNode.class, contextManager);
    }

    void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    void bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            valueNode = valueNode.bindExpression(fromList, subqueryList, list);
            this.setElementAt(valueNode, i2);
        }
    }

    void genSQLJavaSQLTrees() throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            if (!valueNode.getTypeId().userType()) continue;
            this.setElementAt(valueNode.genSQLJavaSQLTree(), i2);
        }
    }

    DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            if (valueNode.requiresTypeFromContext() && valueNode.getTypeServices() == null) continue;
            DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
            if (dataTypeDescriptor2.getTypeId().isStringTypeId()) {
                if (n2 == -1) {
                    n2 = dataTypeDescriptor2.getCollationDerivation();
                    n3 = dataTypeDescriptor2.getCollationType();
                } else if (!bl) {
                    if (n2 != dataTypeDescriptor2.getCollationDerivation()) {
                        bl = true;
                    } else if (n3 != dataTypeDescriptor2.getCollationType()) {
                        bl = true;
                    }
                }
            }
            dataTypeDescriptor = dataTypeDescriptor == null ? dataTypeDescriptor2 : dataTypeDescriptor.getDominantType(dataTypeDescriptor2, this.getClassFactory());
        }
        if (n2 != -1 && bl) {
            dataTypeDescriptor = dataTypeDescriptor.getCollatedType(dataTypeDescriptor.getCollationType(), 0);
        }
        return dataTypeDescriptor;
    }

    DataTypeDescriptor getTypeServices() throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) continue;
            return dataTypeDescriptor;
        }
        return null;
    }

    boolean allSamePrecendence(int n2) {
        boolean bl = true;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) {
                return false;
            }
            if (n2 == dataTypeDescriptor.getTypeId().typePrecedence()) continue;
            return false;
        }
        return bl;
    }

    void compatible(ValueNode valueNode) throws StandardException {
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        for (ValueNode valueNode2 : this) {
            if (valueNode2.requiresTypeFromContext() || typeCompiler.compatible(valueNode2.getTypeId())) continue;
            throw StandardException.newException("42815.S.171", typeId.getSQLTypeName(), valueNode2.getTypeId().getSQLTypeName());
        }
    }

    void comparable(ValueNode valueNode) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(i2);
            if (valueNode.getTypeServices().comparable(valueNode2.getTypeServices(), false, this.getClassFactory())) continue;
            throw StandardException.newException("42818", valueNode.getTypeServices().getSQLTypeNameWithCollation(), valueNode2.getTypeServices().getSQLTypeNameWithCollation());
        }
    }

    boolean isNullable() throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((ValueNode)this.elementAt(i2)).getTypeServices().isNullable()) continue;
            return true;
        }
        return false;
    }

    boolean containsParameterNode() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!((ValueNode)this.elementAt(i2)).requiresTypeFromContext()) continue;
            return true;
        }
        return false;
    }

    boolean containsAllParameterNodes() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((ValueNode)this.elementAt(i2)).requiresTypeFromContext()) continue;
            return false;
        }
        return true;
    }

    boolean containsAllConstantNodes() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.elementAt(i2) instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyConstantAndParamNodes() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            if (valueNode.requiresTypeFromContext() || valueNode instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = this.size();
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i2 = 1; i2 < n2; ++i2) {
                ConstantNode constantNode = (ConstantNode)this.elementAt(i2);
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                ConstantNode constantNode2 = (ConstantNode)this.elementAt(i2 - 1);
                DataValueDescriptor dataValueDescriptor3 = constantNode2.getValue();
                if ((dataValueDescriptor != null || dataValueDescriptor3.compare(dataValueDescriptor2) <= 0) && (dataValueDescriptor == null || !dataValueDescriptor.greaterThan(dataValueDescriptor3, dataValueDescriptor2).equals(true))) continue;
                this.setElementAt(constantNode, i2 - 1);
                this.setElementAt(constantNode2, i2);
                bl = true;
            }
        }
    }

    void eliminateNots(boolean bl) throws StandardException {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setElementAt(((ValueNode)this.elementAt(i2)).eliminateNots(bl), i2);
        }
    }

    void setParameterDescriptor(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)this.elementAt(i2);
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(dataTypeDescriptor);
        }
    }

    void preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            ValueNode valueNode = ((ValueNode)this.elementAt(i2)).preprocess(n2, fromList, subqueryList, predicateList);
            this.setElementAt(valueNode, i2);
        }
    }

    ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setElementAt(((ValueNode)this.elementAt(i2)).remapColumnReferencesToExpressions(), i2);
        }
        return this;
    }

    boolean isEquivalent(ValueNodeList valueNodeList) throws StandardException {
        if (this.size() != valueNodeList.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            ValueNode valueNode;
            ValueNode valueNode2 = (ValueNode)this.elementAt(i2);
            if (valueNode2.isEquivalent(valueNode = (ValueNode)valueNodeList.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    boolean isConstantExpression() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = ((ValueNode)this.elementAt(i2)).isConstantExpression();
            if (bl) continue;
            return bl;
        }
        return true;
    }

    boolean constantExpression(PredicateList predicateList) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = ((ValueNode)this.elementAt(i2)).constantExpression(predicateList);
            if (bl) continue;
            return bl;
        }
        return true;
    }

    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = true;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            bl2 = ((ValueNode)this.elementAt(i2)).categorize(jBitSet, bl) && bl2;
        }
        return bl2;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n2 = 3;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = ((ValueNode)this.elementAt(i2)).getOrderableVariantType();
            n2 = Math.min(n2, n4);
        }
        return n2;
    }
}

