/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.db.TriggerExecutionContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.compile.ASTVisitor;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecutionStmtValidator;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.CompilerContextImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericAuthorizer;
import org.apache.derby.impl.sql.conn.GenericStatementContext;
import org.apache.derby.impl.sql.conn.SQLSessionContextImpl;
import org.apache.derby.impl.sql.conn.TempTableInfo;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;

public class GenericLanguageConnectionContext
extends ContextImpl
implements LanguageConnectionContext {
    private static final int NON_XA = 0;
    private static final int XA_ONE_PHASE = 1;
    private static final int XA_TWO_PHASE = 2;
    private final ArrayList<Activation> acts;
    private volatile boolean unusedActs = false;
    private int maxActsSize;
    protected int bindCount;
    private boolean ddWriteMode;
    private boolean runTimeStatisticsSetting;
    private boolean statisticsTiming;
    private boolean xplainOnlyMode = false;
    private String xplain_schema = null;
    private Map<Object, Object> xplain_statements = new HashMap<Object, Object>();
    private ArrayList<TempTableInfo> allDeclaredGlobalTempTables;
    private int currentSavepointLevel = 0;
    protected long nextCursorId;
    protected int nextSavepointId;
    private RunTimeStatistics runTimeStatisticsObject;
    private StringBuffer sb;
    private Database db;
    private final int instanceNumber;
    private String drdaID;
    private String dbname;
    private Object lastQueryTree;
    private final TransactionController tran;
    private TransactionController readOnlyNestedTransaction;
    private int queryNestingDepth;
    protected DataValueFactory dataFactory;
    protected LanguageFactory langFactory;
    protected TypeCompilerFactory tcf;
    protected OptimizerFactory of;
    protected LanguageConnectionFactory connFactory;
    private final StatementContext[] statementContexts = new StatementContext[2];
    private int statementDepth;
    protected int outermostTrigger = -1;
    protected Authorizer authorizer;
    protected String userName = null;
    private SQLSessionContext topLevelSSC;
    private SchemaDescriptor cachedInitialDefaultSchemaDescr = null;
    private int defaultIsolationLevel;
    protected int isolationLevel = this.defaultIsolationLevel = 2;
    private boolean isolationLevelExplicitlySet = false;
    private boolean isolationLevelSetUsingSQLorJDBC = false;
    protected int prepareIsolationLevel = 0;
    private boolean logStatementText;
    private boolean logQueryPlan;
    private HeaderPrintWriter istream;
    private int lockEscalationThreshold;
    private ArrayList<ExecutionStmtValidator> stmtValidators;
    private ArrayList<TriggerExecutionContext> triggerExecutionContexts;
    private ArrayList<TableDescriptor> triggerTables;
    private OptTrace optimizerTracer;
    private HashMap<String, Long> autoincrementHT;
    private boolean autoincrementUpdate;
    private long identityVal;
    private boolean identityNotNull;
    private HashMap<String, AutoincrementCounter> autoincrementCacheHashtable;
    private ASTVisitor astWalker;
    private StandardException interruptedException;
    private WeakHashMap<TableDescriptor, FormatableBitSet> referencedColumnMap;
    private HashMap<UUID, DeferredConstraintsMemory.ValidationInfo> deferredHashTables;
    private String sessionUser = null;
    Map<Object, Object> printedObjectsMap = null;

    public GenericLanguageConnectionContext(ContextManager contextManager, TransactionController transactionController, LanguageFactory languageFactory, LanguageConnectionFactory languageConnectionFactory, Database database, String string, int n2, String string2, String string3) throws StandardException {
        super(contextManager, "LanguageConnectionContext");
        this.acts = new ArrayList();
        this.tran = transactionController;
        this.dataFactory = languageConnectionFactory.getDataValueFactory();
        this.tcf = languageConnectionFactory.getTypeCompilerFactory();
        this.of = languageConnectionFactory.getOptimizerFactory();
        this.langFactory = languageFactory;
        this.connFactory = languageConnectionFactory;
        this.db = database;
        this.userName = string;
        this.instanceNumber = n2;
        this.drdaID = string2;
        this.dbname = string3;
        String string4 = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logStatementText");
        this.logStatementText = Boolean.valueOf(string4);
        String string5 = PropertyUtil.getServiceProperty(this.getTransactionCompile(), "derby.language.logQueryPlan");
        this.logQueryPlan = Boolean.valueOf(string5);
        this.setRunTimeStatisticsMode(this.logQueryPlan);
        this.lockEscalationThreshold = PropertyUtil.getServiceInt(transactionController, "derby.locks.escalationThreshold", 100, Integer.MAX_VALUE, 5000);
        this.stmtValidators = new ArrayList();
        this.triggerExecutionContexts = new ArrayList();
        this.triggerTables = new ArrayList();
    }

    @Override
    public void initialize() throws StandardException {
        this.interruptedException = null;
        this.sessionUser = IdUtil.getUserAuthorizationId(this.userName);
        this.authorizer = new GenericAuthorizer(this);
        this.setDefaultSchema(this.initDefaultSchemaDescriptor());
        this.referencedColumnMap = new WeakHashMap();
    }

    protected SchemaDescriptor initDefaultSchemaDescriptor() throws StandardException {
        if (this.cachedInitialDefaultSchemaDescr == null) {
            DataDictionary dataDictionary = this.getDataDictionary();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.getSessionUserId(), this.getTransactionCompile(), false);
            if (schemaDescriptor == null) {
                schemaDescriptor = new SchemaDescriptor(dataDictionary, this.getSessionUserId(), this.getSessionUserId(), null, false);
            }
            this.cachedInitialDefaultSchemaDescr = schemaDescriptor;
        }
        return this.cachedInitialDefaultSchemaDescr;
    }

    private SchemaDescriptor getInitialDefaultSchemaDescriptor() {
        return this.cachedInitialDefaultSchemaDescr;
    }

    @Override
    public boolean getLogStatementText() {
        return this.logStatementText;
    }

    @Override
    public void setLogStatementText(boolean bl) {
        this.logStatementText = bl;
    }

    @Override
    public boolean getLogQueryPlan() {
        return this.logQueryPlan;
    }

    @Override
    public boolean usesSqlAuthorization() {
        return this.getDataDictionary().usesSqlAuthorization();
    }

    @Override
    public int getLockEscalationThreshold() {
        return this.lockEscalationThreshold;
    }

    @Override
    public void addActivation(Activation activation) throws StandardException {
        this.acts.add(activation);
        if (this.acts.size() > this.maxActsSize) {
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public void closeUnusedActivations() throws StandardException {
        if (this.unusedActs && this.acts.size() > 20) {
            this.unusedActs = false;
            for (int i2 = this.acts.size() - 1; i2 >= 0; --i2) {
                Activation activation;
                if (i2 >= this.acts.size() || (activation = this.acts.get(i2)).isInUse()) continue;
                activation.close();
            }
        }
    }

    @Override
    public void notifyUnusedActivation() {
        this.unusedActs = true;
    }

    @Override
    public boolean checkIfAnyDeclaredGlobalTempTablesForThisConnection() {
        return this.allDeclaredGlobalTempTables != null;
    }

    @Override
    public void addDeclaredGlobalTempTable(TableDescriptor tableDescriptor) throws StandardException {
        if (this.findDeclaredGlobalTempTable(tableDescriptor.getName()) != null) {
            throw StandardException.newException("X0Y32.S", "Declared global temporary table", tableDescriptor.getName(), "Schema", "SESSION");
        }
        TempTableInfo tempTableInfo = new TempTableInfo(tableDescriptor, this.currentSavepointLevel);
        if (this.allDeclaredGlobalTempTables == null) {
            this.allDeclaredGlobalTempTables = new ArrayList();
        }
        this.allDeclaredGlobalTempTables.add(tempTableInfo);
    }

    @Override
    public boolean dropDeclaredGlobalTempTable(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        if (tempTableInfo != null) {
            if (tempTableInfo.getDeclaredInSavepointLevel() == this.currentSavepointLevel) {
                this.allDeclaredGlobalTempTables.remove(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo));
                if (this.allDeclaredGlobalTempTables.isEmpty()) {
                    this.allDeclaredGlobalTempTables = null;
                }
            } else {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            return true;
        }
        return false;
    }

    private void tempTablesReleaseSavepointLevels() {
        for (int i2 = 0; i2 < this.allDeclaredGlobalTempTables.size(); ++i2) {
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i2);
            if (tempTableInfo.getDroppedInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDroppedInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getDeclaredInSavepointLevel() > this.currentSavepointLevel) {
                tempTableInfo.setDeclaredInSavepointLevel(this.currentSavepointLevel);
            }
            if (tempTableInfo.getModifiedInSavepointLevel() <= this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
        }
    }

    private void tempTablesAndCommit(boolean bl) throws StandardException {
        Object object;
        int n2;
        for (n2 = this.allDeclaredGlobalTempTables.size() - 1; n2 >= 0; --n2) {
            object = this.allDeclaredGlobalTempTables.get(n2);
            if (((TempTableInfo)object).getDroppedInSavepointLevel() != -1) {
                this.allDeclaredGlobalTempTables.remove(n2);
                continue;
            }
            ((TempTableInfo)object).setDeclaredInSavepointLevel(-1);
            ((TempTableInfo)object).setModifiedInSavepointLevel(-1);
        }
        for (n2 = 0; n2 < this.allDeclaredGlobalTempTables.size(); ++n2) {
            object = this.allDeclaredGlobalTempTables.get(n2).getTableDescriptor();
            if (!((TableDescriptor)object).isOnCommitDeleteRows() || this.checkIfAnyActivationHasHoldCursor(((TableDescriptor)object).getName())) continue;
            this.getDataDictionary().getDependencyManager().invalidateFor((Provider)object, 1, this);
            if (bl) continue;
            this.cleanupTempTableOnCommitOrRollback((TableDescriptor)object, true);
        }
    }

    private void tempTablesXApostCommit() throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        for (int i2 = 0; i2 < this.allDeclaredGlobalTempTables.size(); ++i2) {
            TableDescriptor tableDescriptor = this.allDeclaredGlobalTempTables.get(i2).getTableDescriptor();
            transactionController.dropConglomerate(tableDescriptor.getHeapConglomerateId());
            this.allDeclaredGlobalTempTables.remove(i2);
        }
        transactionController.commit();
    }

    @Override
    public void resetFromPool() throws StandardException {
        this.interruptedException = null;
        this.identityNotNull = false;
        this.dropAllDeclaredGlobalTempTables();
        this.setDefaultSchema(null);
        this.getCurrentSQLSessionContext().setRole(null);
        this.getCurrentSQLSessionContext().setUser(this.getSessionUserId());
        this.referencedColumnMap = new WeakHashMap();
    }

    @Override
    public void setLastQueryTree(Object object) {
        this.lastQueryTree = object;
    }

    @Override
    public Object getLastQueryTree() {
        return this.lastQueryTree;
    }

    private void dropAllDeclaredGlobalTempTables() throws StandardException {
        if (this.allDeclaredGlobalTempTables == null) {
            return;
        }
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        StandardException standardException = null;
        for (int i2 = 0; i2 < this.allDeclaredGlobalTempTables.size(); ++i2) {
            try {
                TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i2);
                TableDescriptor tableDescriptor = tempTableInfo.getTableDescriptor();
                dependencyManager.invalidateFor(tableDescriptor, 1, this);
                this.tran.dropConglomerate(tableDescriptor.getHeapConglomerateId());
                continue;
            }
            catch (StandardException standardException2) {
                if (standardException == null) {
                    standardException = standardException2;
                    continue;
                }
                try {
                    standardException2.initCause(standardException);
                    standardException = standardException2;
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.allDeclaredGlobalTempTables = null;
        try {
            this.internalCommit(true);
        }
        catch (StandardException standardException3) {
            if (standardException == null) {
                standardException = standardException3;
            }
            try {
                standardException3.initCause(standardException);
                standardException = standardException3;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (standardException != null) {
            throw standardException;
        }
    }

    private void tempTablesAndRollback() throws StandardException {
        for (int i2 = this.allDeclaredGlobalTempTables.size() - 1; i2 >= 0; --i2) {
            TableDescriptor tableDescriptor;
            TempTableInfo tempTableInfo = this.allDeclaredGlobalTempTables.get(i2);
            if (tempTableInfo.getDeclaredInSavepointLevel() >= this.currentSavepointLevel) {
                if (tempTableInfo.getDroppedInSavepointLevel() == -1) {
                    tableDescriptor = tempTableInfo.getTableDescriptor();
                    this.invalidateCleanupDroppedTable(tableDescriptor);
                    this.tran.dropConglomerate(tableDescriptor.getHeapConglomerateId());
                    this.allDeclaredGlobalTempTables.remove(i2);
                    continue;
                }
                if (tempTableInfo.getDroppedInSavepointLevel() < this.currentSavepointLevel) continue;
                this.allDeclaredGlobalTempTables.remove(i2);
                continue;
            }
            if (tempTableInfo.getDroppedInSavepointLevel() >= this.currentSavepointLevel) {
                tableDescriptor = tempTableInfo.getTableDescriptor();
                tableDescriptor = this.cleanupTempTableOnCommitOrRollback(tableDescriptor, false);
                tempTableInfo.setTableDescriptor(tableDescriptor);
                tempTableInfo.setDroppedInSavepointLevel(-1);
                tempTableInfo.setModifiedInSavepointLevel(-1);
                this.allDeclaredGlobalTempTables.set(i2, tempTableInfo);
                continue;
            }
            if (tempTableInfo.getModifiedInSavepointLevel() < this.currentSavepointLevel) continue;
            tempTableInfo.setModifiedInSavepointLevel(-1);
            tableDescriptor = tempTableInfo.getTableDescriptor();
            this.invalidateCleanupDroppedTable(tableDescriptor);
        }
        if (this.allDeclaredGlobalTempTables.isEmpty()) {
            this.allDeclaredGlobalTempTables = null;
        }
    }

    private void invalidateCleanupDroppedTable(TableDescriptor tableDescriptor) throws StandardException {
        this.getDataDictionary().getDependencyManager().invalidateFor(tableDescriptor, 1, this);
        this.cleanupTempTableOnCommitOrRollback(tableDescriptor, true);
    }

    private void replaceDeclaredGlobalTempTable(String string, TableDescriptor tableDescriptor) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        tempTableInfo.setDroppedInSavepointLevel(-1);
        tempTableInfo.setDeclaredInSavepointLevel(-1);
        tempTableInfo.setTableDescriptor(tableDescriptor);
        this.allDeclaredGlobalTempTables.set(this.allDeclaredGlobalTempTables.indexOf(tempTableInfo), tempTableInfo);
    }

    @Override
    public TableDescriptor getTableDescriptorForDeclaredGlobalTempTable(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        if (tempTableInfo == null) {
            return null;
        }
        return tempTableInfo.getTableDescriptor();
    }

    private TempTableInfo findDeclaredGlobalTempTable(String string) {
        if (this.allDeclaredGlobalTempTables == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.allDeclaredGlobalTempTables.size(); ++i2) {
            if (!this.allDeclaredGlobalTempTables.get(i2).matches(string)) continue;
            return this.allDeclaredGlobalTempTables.get(i2);
        }
        return null;
    }

    @Override
    public void markTempTableAsModifiedInUnitOfWork(String string) {
        TempTableInfo tempTableInfo = this.findDeclaredGlobalTempTable(string);
        tempTableInfo.setModifiedInSavepointLevel(this.currentSavepointLevel);
    }

    @Override
    public PreparedStatement prepareInternalStatement(SchemaDescriptor schemaDescriptor, String string, boolean bl, boolean bl2) throws StandardException {
        if (bl2) {
            schemaDescriptor = this.getDataDictionary().getSystemSchemaDescriptor();
        }
        return this.connFactory.getStatement(schemaDescriptor, string, bl).prepare(this, bl2);
    }

    @Override
    public PreparedStatement prepareInternalStatement(String string) throws StandardException {
        return this.connFactory.getStatement(this.getDefaultSchema(), string, true).prepare(this);
    }

    @Override
    public void removeActivation(Activation activation) {
        this.acts.remove(activation);
        if (this.maxActsSize > 20 && this.maxActsSize > 2 * this.acts.size()) {
            this.acts.trimToSize();
            this.maxActsSize = this.acts.size();
        }
    }

    @Override
    public int getActivationCount() {
        return this.acts.size();
    }

    @Override
    public CursorActivation lookupCursorActivation(String string) {
        int n2 = this.acts.size();
        if (n2 > 0) {
            int n3 = string.hashCode();
            for (int i2 = 0; i2 < n2; ++i2) {
                ResultSet resultSet;
                String string2;
                Activation activation = this.acts.get(i2);
                if (!activation.isInUse() || (string2 = activation.getCursorName()) == null || string2.hashCode() != n3 || !string.equals(string2) || (resultSet = activation.getResultSet()) == null || resultSet.isClosed()) continue;
                return (CursorActivation)activation;
            }
        }
        return null;
    }

    public void removeStatement(GenericStatement genericStatement) throws StandardException {
        CacheManager cacheManager = this.getLanguageConnectionFactory().getStatementCache();
        if (cacheManager == null) {
            return;
        }
        Cacheable cacheable = cacheManager.findCached(genericStatement);
        if (cacheable != null) {
            CachedStatement cachedStatement = (CachedStatement)cacheable;
            if (genericStatement.getPreparedStatement() != cachedStatement.getPreparedStatement()) {
                cacheManager.release(cacheable);
            } else {
                cacheManager.remove(cacheable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement lookupStatement(GenericStatement genericStatement) throws StandardException {
        GenericPreparedStatement genericPreparedStatement;
        CacheManager cacheManager = this.getLanguageConnectionFactory().getStatementCache();
        if (cacheManager == null) {
            return null;
        }
        if (this.dataDictionaryInWriteMode()) {
            return null;
        }
        Cacheable cacheable = cacheManager.find(genericStatement);
        CachedStatement cachedStatement = (CachedStatement)cacheable;
        GenericPreparedStatement genericPreparedStatement2 = genericPreparedStatement = cachedStatement.getPreparedStatement();
        synchronized (genericPreparedStatement2) {
            if (genericPreparedStatement.upToDate()) {
                GeneratedClass generatedClass = genericPreparedStatement.getActivationClass();
                int n2 = this.getLanguageConnectionFactory().getClassFactory().getClassLoaderVersion();
                if (generatedClass.getClassLoaderVersion() != n2) {
                    genericPreparedStatement.makeInvalid(23, this);
                }
            }
        }
        cacheManager.release(cacheable);
        return genericPreparedStatement;
    }

    @Override
    public String getUniqueCursorName() {
        return this.getNameString("SQLCUR", this.nextCursorId++);
    }

    @Override
    public String getUniqueSavepointName() {
        return this.getNameString("SAVEPT", this.nextSavepointId++);
    }

    @Override
    public int getUniqueSavepointID() {
        return this.nextSavepointId - 1;
    }

    private String getNameString(String string, long l2) {
        if (this.sb != null) {
            this.sb.setLength(0);
        } else {
            this.sb = new StringBuffer();
        }
        this.sb.append(string).append(l2);
        return this.sb.toString();
    }

    @Override
    public void internalCommit(boolean bl) throws StandardException {
        this.doCommit(bl, true, 0, false);
    }

    @Override
    public void userCommit() throws StandardException {
        this.doCommit(true, true, 0, true);
    }

    @Override
    public final void internalCommitNoSync(int n2) throws StandardException {
        this.doCommit(true, false, n2, false);
    }

    @Override
    public final void xaCommit(boolean bl) throws StandardException {
        this.doCommit(true, true, bl ? 1 : 2, true);
    }

    protected void doCommit(boolean bl, boolean bl2, int n2, boolean bl3) throws StandardException {
        Object object;
        StatementContext statementContext = this.getStatementContext();
        if (bl3 && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y66.S", new Object[0]);
        }
        this.checkIntegrity();
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            object = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + (String)object + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Committing");
        }
        this.endTransactionActivationHandling(false);
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndCommit(n2 != 0);
        }
        this.currentSavepointLevel = 0;
        if (bl2) {
            this.finishDDTransaction();
        }
        if ((object = this.getTransactionExecute()) != null && bl) {
            if (bl2) {
                if (n2 == 0) {
                    object.commit();
                } else {
                    ((XATransactionController)object).xa_commit(n2 == 1);
                }
            } else {
                object.commitNoSync(n2);
            }
            this.resetSavepoints();
            if (this.allDeclaredGlobalTempTables != null && n2 != 0) {
                this.tempTablesXApostCommit();
            }
        }
    }

    private TableDescriptor cleanupTempTableOnCommitOrRollback(TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        long l2 = transactionController.createConglomerate("heap", tableDescriptor.getEmptyExecRow().getRowArray(), null, tableDescriptor.getColumnCollationIds(), null, 3);
        long l3 = tableDescriptor.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(l3);
        tableDescriptor.getConglomerateDescriptorList().dropConglomerateDescriptorByUUID(conglomerateDescriptor.getUUID());
        conglomerateDescriptor = this.getDataDictionary().getDataDescriptorGenerator().newConglomerateDescriptor(l2, null, false, null, false, null, tableDescriptor.getUUID(), tableDescriptor.getSchemaDescriptor().getUUID());
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        conglomerateDescriptorList.add(conglomerateDescriptor);
        tableDescriptor.resetHeapConglomNumber();
        if (bl) {
            transactionController.dropConglomerate(l3);
            this.replaceDeclaredGlobalTempTable(tableDescriptor.getName(), tableDescriptor);
        }
        return tableDescriptor;
    }

    @Override
    public void internalRollback() throws StandardException {
        this.doRollback(false, false);
    }

    @Override
    public void userRollback() throws StandardException {
        this.doRollback(false, true);
    }

    @Override
    public void xaRollback() throws StandardException {
        this.doRollback(true, true);
    }

    private void doRollback(boolean bl, boolean bl2) throws StandardException {
        Object object;
        StatementContext statementContext = this.getStatementContext();
        if (bl2 && statementContext != null && statementContext.inUse() && statementContext.isAtomic()) {
            throw StandardException.newException("X0Y67.S", new Object[0]);
        }
        this.clearDeferreds();
        if (this.logStatementText) {
            if (this.istream == null) {
                this.istream = Monitor.getStream();
            }
            object = this.tran.getTransactionIdString();
            this.istream.printlnWithHeader("(XID = " + (String)object + "), " + "(SESSIONID = " + this.instanceNumber + "), " + "(DATABASE = " + this.dbname + "), " + "(DRDAID = " + this.drdaID + "), Rolling back");
        }
        this.endTransactionActivationHandling(true);
        this.currentSavepointLevel = 0;
        if (this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
        this.finishDDTransaction();
        if (this.readOnlyNestedTransaction != null) {
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
            this.queryNestingDepth = 0;
        }
        if ((object = this.getTransactionExecute()) != null) {
            if (bl) {
                ((XATransactionController)object).xa_rollback();
            } else {
                object.abort();
            }
            this.resetSavepoints();
        }
    }

    private void resetSavepoints() throws StandardException {
        ContextManager contextManager = this.getContextManager();
        List<Context> list = contextManager.getContextStack("StatementContext");
        for (Context context : list) {
            ((StatementContext)context).resetSavePoint();
        }
    }

    @Override
    public void internalRollbackToSavepoint(String string, boolean bl, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            boolean bl2;
            if (bl) {
                bl2 = true;
                this.endTransactionActivationHandling(true);
            } else {
                bl2 = false;
            }
            this.currentSavepointLevel = transactionController.rollbackToSavePoint(string, bl2, object);
        }
        if (transactionController != null && bl && this.allDeclaredGlobalTempTables != null) {
            this.tempTablesAndRollback();
        }
    }

    @Override
    public void releaseSavePoint(String string, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            this.currentSavepointLevel = transactionController.releaseSavePoint(string, object);
            if (this.allDeclaredGlobalTempTables != null) {
                this.tempTablesReleaseSavepointLevels();
            }
        }
    }

    @Override
    public void languageSetSavePoint(String string, Object object) throws StandardException {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController != null) {
            this.currentSavepointLevel = transactionController.setSavePoint(string, object);
        }
    }

    @Override
    public void beginNestedTransaction(boolean bl) throws StandardException {
        if (this.readOnlyNestedTransaction == null) {
            this.readOnlyNestedTransaction = this.tran.startNestedUserTransaction(bl, true);
        }
        ++this.queryNestingDepth;
    }

    @Override
    public void commitNestedTransaction() throws StandardException {
        if (--this.queryNestingDepth == 0) {
            this.readOnlyNestedTransaction.commit();
            this.readOnlyNestedTransaction.destroy();
            this.readOnlyNestedTransaction = null;
        }
    }

    @Override
    public final TransactionController getTransactionCompile() {
        return this.readOnlyNestedTransaction != null ? this.readOnlyNestedTransaction : this.tran;
    }

    @Override
    public TransactionController getTransactionExecute() {
        return this.tran;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dataFactory;
    }

    @Override
    public LanguageFactory getLanguageFactory() {
        return this.langFactory;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    @Override
    public LanguageConnectionFactory getLanguageConnectionFactory() {
        return this.connFactory;
    }

    private boolean checkIfAnyActivationHasHoldCursor(String string) throws StandardException {
        for (int i2 = this.acts.size() - 1; i2 >= 0; --i2) {
            Activation activation = this.acts.get(i2);
            if (!activation.checkIfThisActivationHasHoldCursor(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyAllHeldResultSetsAreClosed() throws StandardException {
        ResultSet resultSet;
        Activation activation;
        int n2;
        boolean bl = false;
        for (n2 = this.acts.size() - 1; n2 >= 0; --n2) {
            activation = this.acts.get(n2);
            if (!activation.isInUse() || !activation.getResultSetHoldability() || (resultSet = ((CursorActivation)activation).getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return true;
        }
        System.gc();
        System.runFinalization();
        for (n2 = this.acts.size() - 1; n2 >= 0; --n2) {
            activation = this.acts.get(n2);
            if (!activation.isInUse() || !activation.getResultSetHoldability() || (resultSet = ((CursorActivation)activation).getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean verifyNoOpenResultSets(PreparedStatement preparedStatement, Provider provider, int n2) throws StandardException {
        ResultSet resultSet;
        Activation activation;
        int n3;
        boolean bl = false;
        for (n3 = this.acts.size() - 1; n3 >= 0; --n3) {
            activation = this.acts.get(n3);
            if (!activation.isInUse() || preparedStatement != activation.getPreparedStatement() || (resultSet = activation.getResultSet()) == null || resultSet.isClosed() || !resultSet.returnsRows()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return false;
        }
        System.gc();
        System.runFinalization();
        for (n3 = this.acts.size() - 1; n3 >= 0; --n3) {
            activation = this.acts.get(n3);
            if (!activation.isInUse() || preparedStatement != activation.getPreparedStatement() || (resultSet = activation.getResultSet()) == null || resultSet.isClosed()) continue;
            if (provider != null && resultSet.returnsRows()) {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0X95.S", dependencyManager.getActionString(n2), provider.getObjectName());
            }
            return true;
        }
        return false;
    }

    @Override
    public String getSessionUserId() {
        return this.sessionUser;
    }

    @Override
    public SchemaDescriptor getDefaultSchema() {
        return this.getCurrentSQLSessionContext().getDefaultSchema();
    }

    @Override
    public SchemaDescriptor getDefaultSchema(Activation activation) {
        return this.getCurrentSQLSessionContext(activation).getDefaultSchema();
    }

    @Override
    public String getCurrentSchemaName() {
        SchemaDescriptor schemaDescriptor = this.getDefaultSchema();
        if (null == schemaDescriptor) {
            return null;
        }
        return schemaDescriptor.getSchemaName();
    }

    @Override
    public String getCurrentSchemaName(Activation activation) {
        SchemaDescriptor schemaDescriptor = this.getDefaultSchema(activation);
        if (null == schemaDescriptor) {
            return null;
        }
        return schemaDescriptor.getSchemaName();
    }

    @Override
    public boolean isInitialDefaultSchema(String string) {
        return this.cachedInitialDefaultSchemaDescr.getSchemaName().equals(string);
    }

    @Override
    public void setDefaultSchema(SchemaDescriptor schemaDescriptor) throws StandardException {
        if (schemaDescriptor == null) {
            schemaDescriptor = this.getInitialDefaultSchemaDescriptor();
        }
        this.getCurrentSQLSessionContext().setDefaultSchema(schemaDescriptor);
    }

    @Override
    public void setDefaultSchema(Activation activation, SchemaDescriptor schemaDescriptor) throws StandardException {
        if (schemaDescriptor == null) {
            schemaDescriptor = this.getInitialDefaultSchemaDescriptor();
        }
        this.getCurrentSQLSessionContext(activation).setDefaultSchema(schemaDescriptor);
    }

    @Override
    public void resetSchemaUsages(Activation activation, String string) throws StandardException {
        SchemaDescriptor schemaDescriptor;
        SQLSessionContext sQLSessionContext;
        SchemaDescriptor schemaDescriptor2 = this.getInitialDefaultSchemaDescriptor();
        for (Activation activation2 = activation.getParentActivation(); activation2 != null; activation2 = activation2.getParentActivation()) {
            sQLSessionContext = activation2.getSQLSessionContextForChildren();
            schemaDescriptor = sQLSessionContext.getDefaultSchema();
            if (!string.equals(schemaDescriptor.getSchemaName())) continue;
            sQLSessionContext.setDefaultSchema(schemaDescriptor2);
        }
        sQLSessionContext = this.getTopLevelSQLSessionContext();
        schemaDescriptor = sQLSessionContext.getDefaultSchema();
        if (string.equals(schemaDescriptor.getSchemaName())) {
            sQLSessionContext.setDefaultSchema(schemaDescriptor2);
        }
    }

    @Override
    public Long getIdentityValue() {
        return this.identityNotNull ? Long.valueOf(this.identityVal) : null;
    }

    @Override
    public void setIdentityValue(long l2) {
        this.identityVal = l2;
        this.identityNotNull = true;
    }

    @Override
    public final CompilerContext pushCompilerContext() {
        return this.pushCompilerContext(null);
    }

    @Override
    public CompilerContext pushCompilerContext(SchemaDescriptor schemaDescriptor) {
        boolean bl = false;
        CompilerContext compilerContext = (CompilerContext)this.getContextManager().getContext("CompilerContext");
        if (compilerContext == null) {
            bl = true;
        }
        if (compilerContext == null || compilerContext.getInUse()) {
            compilerContext = new CompilerContextImpl(this.getContextManager(), this, this.tcf);
            if (bl) {
                compilerContext.firstOnStack();
            }
        } else {
            compilerContext.resetContext();
        }
        compilerContext.setInUse(true);
        StatementContext statementContext = this.getStatementContext();
        if (statementContext.getSystemCode()) {
            compilerContext.setReliability(0);
        }
        if (schemaDescriptor != null && schemaDescriptor.getUUID() != null) {
            compilerContext.setCompilationSchema(schemaDescriptor);
        }
        return compilerContext;
    }

    @Override
    public void popCompilerContext(CompilerContext compilerContext) {
        compilerContext.setCurrentDependent(null);
        compilerContext.setInUse(false);
        if (!compilerContext.isFirstOnStack()) {
            compilerContext.popMe();
        } else {
            compilerContext.setCompilationSchema(null);
        }
    }

    @Override
    public StatementContext pushStatementContext(boolean bl, boolean bl2, String string, ParameterValueSet parameterValueSet, boolean bl3, long l2) {
        int n2 = this.statementDepth;
        boolean bl4 = false;
        boolean bl5 = false;
        StatementContext statementContext = this.statementContexts[0];
        if (statementContext == null) {
            statementContext = this.statementContexts[0] = new GenericStatementContext(this);
            statementContext.setSQLSessionContext(this.getTopLevelSQLSessionContext());
        } else if (this.statementDepth > 0) {
            StatementContext statementContext2;
            if (this.statementDepth == 1) {
                statementContext = this.statementContexts[1];
                if (statementContext == null) {
                    statementContext = this.statementContexts[1] = new GenericStatementContext(this);
                } else {
                    statementContext.pushMe();
                }
                statementContext2 = this.statementContexts[0];
            } else {
                statementContext2 = this.getStatementContext();
                statementContext = new GenericStatementContext(this);
            }
            statementContext.setSQLSessionContext(statementContext2.getSQLSessionContext());
            bl4 = statementContext2.inTrigger() || this.outermostTrigger == n2;
            bl5 = statementContext2.isAtomic();
            statementContext.setSQLAllowed(statementContext2.getSQLAllowed(), false);
            if (statementContext2.getSystemCode()) {
                statementContext.setSystemCode();
            }
        } else {
            statementContext.setSQLSessionContext(this.getTopLevelSQLSessionContext());
        }
        this.incrementStatementDepth();
        statementContext.setInUse(bl4, bl || bl5, bl2, string, parameterValueSet, l2);
        if (bl3) {
            statementContext.setParentRollback();
        }
        return statementContext;
    }

    @Override
    public void popStatementContext(StatementContext statementContext, Throwable throwable) {
        if (statementContext != null) {
            if (!statementContext.inUse()) {
                return;
            }
            statementContext.clearInUse();
        }
        this.decrementStatementDepth();
        if (this.statementDepth == -1) {
            this.resetStatementDepth();
        } else if (this.statementDepth != 0) {
            statementContext.popMe();
        }
    }

    @Override
    public void pushExecutionStmtValidator(ExecutionStmtValidator executionStmtValidator) {
        this.stmtValidators.add(executionStmtValidator);
    }

    @Override
    public void popExecutionStmtValidator(ExecutionStmtValidator executionStmtValidator) throws StandardException {
        boolean bl = this.stmtValidators.remove(executionStmtValidator);
    }

    @Override
    public void pushTriggerExecutionContext(TriggerExecutionContext triggerExecutionContext) throws StandardException {
        if (this.outermostTrigger == -1) {
            this.outermostTrigger = this.statementDepth;
        }
        if (this.triggerExecutionContexts.size() >= 16) {
            throw StandardException.newException("54038", new Object[0]);
        }
        this.triggerExecutionContexts.add(triggerExecutionContext);
    }

    @Override
    public void popTriggerExecutionContext(TriggerExecutionContext triggerExecutionContext) throws StandardException {
        if (this.outermostTrigger == this.statementDepth) {
            this.outermostTrigger = -1;
        }
        boolean bl = this.triggerExecutionContexts.remove(triggerExecutionContext);
    }

    @Override
    public TriggerExecutionContext getTriggerExecutionContext() {
        return this.triggerExecutionContexts.isEmpty() ? null : this.triggerExecutionContexts.get(this.triggerExecutionContexts.size() - 1);
    }

    @Override
    public void validateStmtExecution(ConstantAction constantAction) throws StandardException {
        if (this.stmtValidators.size() > 0) {
            Iterator<ExecutionStmtValidator> iterator = this.stmtValidators.iterator();
            while (iterator.hasNext()) {
                iterator.next().validateStatement(constantAction);
            }
        }
    }

    @Override
    public void pushTriggerTable(TableDescriptor tableDescriptor) {
        this.triggerTables.add(tableDescriptor);
    }

    @Override
    public void popTriggerTable(TableDescriptor tableDescriptor) {
        boolean bl = this.triggerTables.remove(tableDescriptor);
    }

    @Override
    public TableDescriptor getTriggerTable() {
        return this.triggerTables.isEmpty() ? (TableDescriptor)null : this.triggerTables.get(this.triggerTables.size() - 1);
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public int incrementBindCount() {
        ++this.bindCount;
        return this.bindCount;
    }

    @Override
    public int decrementBindCount() {
        --this.bindCount;
        return this.bindCount;
    }

    @Override
    public int getBindCount() {
        return this.bindCount;
    }

    @Override
    public final void setDataDictionaryWriteMode() {
        this.ddWriteMode = true;
    }

    @Override
    public final boolean dataDictionaryInWriteMode() {
        return this.ddWriteMode;
    }

    @Override
    public final void setRunTimeStatisticsMode(boolean bl) {
        this.runTimeStatisticsSetting = bl;
    }

    @Override
    public boolean getRunTimeStatisticsMode() {
        return this.runTimeStatisticsSetting;
    }

    @Override
    public void setStatisticsTiming(boolean bl) {
        this.statisticsTiming = bl;
    }

    @Override
    public boolean getStatisticsTiming() {
        return this.statisticsTiming;
    }

    @Override
    public void setRunTimeStatisticsObject(RunTimeStatistics runTimeStatistics) {
        this.runTimeStatisticsObject = runTimeStatistics;
    }

    @Override
    public RunTimeStatistics getRunTimeStatisticsObject() {
        return this.runTimeStatisticsObject;
    }

    @Override
    public int getStatementDepth() {
        return this.statementDepth;
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() {
        return this.isolationLevelSetUsingSQLorJDBC;
    }

    @Override
    public void resetIsolationLevelFlagUsedForSQLandJDBC() {
        this.isolationLevelSetUsingSQLorJDBC = false;
    }

    @Override
    public void setIsolationLevel(int n2) throws StandardException {
        StatementContext statementContext = this.getStatementContext();
        if (statementContext != null && statementContext.inTrigger()) {
            throw StandardException.newException("X0Y71.S", this.getTriggerExecutionContext().toString());
        }
        if (this.isolationLevel != n2 && !this.verifyAllHeldResultSetsAreClosed()) {
            throw StandardException.newException("X0X03.S", new Object[0]);
        }
        TransactionController transactionController = this.getTransactionExecute();
        if (!transactionController.isIdle()) {
            if (transactionController.isGlobal()) {
                throw StandardException.newException("X0Y77.S", new Object[0]);
            }
            this.userCommit();
        }
        this.isolationLevel = n2;
        this.isolationLevelExplicitlySet = true;
        this.isolationLevelSetUsingSQLorJDBC = true;
    }

    @Override
    public int getCurrentIsolationLevel() {
        return this.isolationLevel == 0 ? this.defaultIsolationLevel : this.isolationLevel;
    }

    @Override
    public String getCurrentIsolationLevelStr() {
        if (this.isolationLevel >= 0 && this.isolationLevel < TransactionControl.isolationMapCount()) {
            return TransactionControl.isolationTextNames(this.isolationLevel)[0];
        }
        return TransactionControl.isolationTextNames(0)[0];
    }

    @Override
    public void setPrepareIsolationLevel(int n2) {
        this.prepareIsolationLevel = n2;
    }

    @Override
    public int getPrepareIsolationLevel() {
        if (!this.isolationLevelExplicitlySet) {
            return this.prepareIsolationLevel;
        }
        return 0;
    }

    @Override
    public StatementContext getStatementContext() {
        return (StatementContext)this.getContextManager().getContext("StatementContext");
    }

    @Override
    public void setOptimizerTracer(OptTrace optTrace) {
        this.optimizerTracer = optTrace;
    }

    @Override
    public OptTrace getOptimizerTracer() {
        return this.optimizerTracer;
    }

    @Override
    public boolean optimizerTracingIsOn() {
        return this.optimizerTracer != null;
    }

    @Override
    public boolean isTransactionPristine() {
        return this.getTransactionExecute().isPristine();
    }

    @Override
    public void cleanupOnError(Throwable throwable) throws StandardException {
        int n2;
        int n3 = n2 = throwable instanceof StandardException ? ((StandardException)throwable).getSeverity() : 40000;
        if (this.statementContexts[0] != null) {
            this.statementContexts[0].clearInUse();
            if (n2 >= 40000) {
                this.statementContexts[0].popMe();
            }
        }
        if (this.statementContexts[1] != null) {
            this.statementContexts[1].clearInUse();
        }
        if (n2 >= 40000) {
            for (int i2 = this.acts.size() - 1; i2 >= 0; --i2) {
                if (i2 >= this.acts.size()) continue;
                Activation activation = this.acts.get(i2);
                activation.reset();
                activation.close();
            }
            this.popMe();
            InterruptStatus.saveInfoFromLcc(this);
        } else if (n2 >= 30000) {
            this.internalRollback();
        }
    }

    @Override
    public boolean isLastHandler(int n2) {
        return false;
    }

    private void endTransactionActivationHandling(boolean bl) throws StandardException {
        for (int i2 = this.acts.size() - 1; i2 >= 0; --i2) {
            boolean bl2;
            if (i2 >= this.acts.size()) continue;
            Activation activation = this.acts.get(i2);
            if (!activation.isInUse()) {
                activation.close();
                continue;
            }
            ResultSet resultSet = activation.getResultSet();
            boolean bl3 = bl2 = resultSet != null && resultSet.returnsRows();
            if (bl) {
                ExecPreparedStatement execPreparedStatement;
                if (bl2) {
                    activation.reset();
                }
                if (!this.dataDictionaryInWriteMode() || (execPreparedStatement = activation.getPreparedStatement()) == null) continue;
                execPreparedStatement.makeInvalid(4, this);
                continue;
            }
            if (bl2) {
                if (!activation.getResultSetHoldability()) {
                    resultSet.close();
                } else {
                    resultSet.clearCurrentRow();
                }
            }
            activation.clearHeapConglomerateController();
        }
    }

    private void finishDDTransaction() throws StandardException {
        if (this.ddWriteMode) {
            DataDictionary dataDictionary = this.getDataDictionary();
            dataDictionary.transactionFinished();
            this.ddWriteMode = false;
        }
    }

    private void incrementStatementDepth() {
        ++this.statementDepth;
    }

    private void decrementStatementDepth() {
        --this.statementDepth;
    }

    protected void resetStatementDepth() {
        this.statementDepth = 0;
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.getDatabase().getDataDictionary();
    }

    @Override
    public void setReadOnly(boolean bl) throws StandardException {
        if (!this.tran.isPristine()) {
            throw StandardException.newException("25501", new Object[0]);
        }
        this.authorizer.setReadOnlyConnection(bl, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.authorizer.isReadOnlyConnection();
    }

    @Override
    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    @Override
    public Long lastAutoincrementValue(String string, String string2, String string3) {
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        int n2 = this.triggerExecutionContexts.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            TriggerExecutionContext triggerExecutionContext = this.triggerExecutionContexts.get(i2);
            Long l2 = triggerExecutionContext.getAutoincrementValue(string4);
            if (l2 == null) continue;
            return l2;
        }
        if (this.autoincrementHT == null) {
            return null;
        }
        return this.autoincrementHT.get(string4);
    }

    @Override
    public void setAutoincrementUpdate(boolean bl) {
        this.autoincrementUpdate = bl;
    }

    @Override
    public boolean getAutoincrementUpdate() {
        return this.autoincrementUpdate;
    }

    @Override
    public void autoincrementCreateCounter(String string, String string2, String string3, Long l2, long l3, int n2) {
        AutoincrementCounter autoincrementCounter;
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        if (this.autoincrementCacheHashtable == null) {
            this.autoincrementCacheHashtable = new HashMap();
        }
        if ((autoincrementCounter = this.autoincrementCacheHashtable.get(string4)) != null) {
            return;
        }
        autoincrementCounter = new AutoincrementCounter(l2, l3, 0L, string, string2, string3, n2);
        this.autoincrementCacheHashtable.put(string4, autoincrementCounter);
    }

    @Override
    public long nextAutoincrementValue(String string, String string2, String string3) throws StandardException {
        String string4 = AutoincrementCounter.makeIdentity(string, string2, string3);
        AutoincrementCounter autoincrementCounter = this.autoincrementCacheHashtable.get(string4);
        if (autoincrementCounter == null) {
            return 0L;
        }
        return autoincrementCounter.update();
    }

    @Override
    public void autoincrementFlushCache(UUID uUID) throws StandardException {
        if (this.autoincrementCacheHashtable == null) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        for (String string : this.autoincrementCacheHashtable.keySet()) {
            AutoincrementCounter autoincrementCounter = this.autoincrementCacheHashtable.get(string);
            Long l2 = autoincrementCounter.getCurrentValue();
            autoincrementCounter.flushToDisk(this.getTransactionExecute(), dataDictionary, uUID);
            if (l2 == null) continue;
            this.autoincrementHT.put(string, l2);
        }
        this.autoincrementCacheHashtable.clear();
    }

    @Override
    public void copyHashtableToAIHT(Map<String, Long> map) {
        if (map.isEmpty()) {
            return;
        }
        if (this.autoincrementHT == null) {
            this.autoincrementHT = new HashMap();
        }
        this.autoincrementHT.putAll(map);
    }

    @Override
    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public String getDrdaID() {
        return this.drdaID;
    }

    @Override
    public void setDrdaID(String string) {
        this.drdaID = string;
    }

    @Override
    public String getDbname() {
        return this.dbname;
    }

    @Override
    public Activation getLastActivation() {
        return this.acts.get(this.acts.size() - 1);
    }

    @Override
    public StringBuffer appendErrorInfo() {
        TransactionController transactionController = this.getTransactionExecute();
        if (transactionController == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("(XID = ");
        stringBuffer.append(transactionController.getTransactionIdString());
        stringBuffer.append("), ");
        stringBuffer.append("(SESSIONID = ");
        stringBuffer.append(Integer.toString(this.getInstanceNumber()));
        stringBuffer.append("), ");
        stringBuffer.append("(DATABASE = ");
        stringBuffer.append(this.getDbname());
        stringBuffer.append("), ");
        stringBuffer.append("(DRDAID = ");
        stringBuffer.append(this.getDrdaID());
        stringBuffer.append("), ");
        return stringBuffer;
    }

    @Override
    public void setCurrentRole(Activation activation, String string) {
        this.getCurrentSQLSessionContext(activation).setRole(string);
    }

    @Override
    public String getCurrentRoleId(Activation activation) {
        return this.getCurrentSQLSessionContext(activation).getRole();
    }

    @Override
    public String getCurrentUserId(Activation activation) {
        return this.getCurrentSQLSessionContext(activation).getCurrentUser();
    }

    @Override
    public String getCurrentRoleIdDelimited(Activation activation) throws StandardException {
        String string = this.getCurrentSQLSessionContext(activation).getRole();
        if (string != null) {
            this.beginNestedTransaction(true);
            try {
                if (!this.roleIsSettable(activation, string)) {
                    this.setCurrentRole(activation, null);
                    string = null;
                }
            }
            finally {
                this.commitNestedTransaction();
            }
        }
        if (string != null) {
            string = IdUtil.normalToDelimited(string);
        }
        return string;
    }

    @Override
    public boolean roleIsSettable(Activation activation, String string) throws StandardException {
        RoleGrantDescriptor roleGrantDescriptor;
        DataDictionary dataDictionary = this.getDataDictionary();
        String string2 = dataDictionary.getAuthorizationDatabaseOwner();
        String string3 = this.getCurrentUserId(activation);
        if (string3.equals(string2)) {
            roleGrantDescriptor = dataDictionary.getRoleDefinitionDescriptor(string);
        } else {
            roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string, string3, string2);
            if (roleGrantDescriptor == null) {
                roleGrantDescriptor = dataDictionary.getRoleGrantDescriptor(string, "PUBLIC", string2);
            }
        }
        return roleGrantDescriptor != null;
    }

    @Override
    public SQLSessionContext getCurrentSQLSessionContext(Activation activation) {
        Activation activation2 = activation.getParentActivation();
        SQLSessionContext sQLSessionContext = activation2 == null ? this.getTopLevelSQLSessionContext() : activation2.getSQLSessionContextForChildren();
        return sQLSessionContext;
    }

    private SQLSessionContext getCurrentSQLSessionContext() {
        StatementContext statementContext = this.getStatementContext();
        SQLSessionContext sQLSessionContext = statementContext == null || !statementContext.inUse() ? this.getTopLevelSQLSessionContext() : statementContext.getSQLSessionContext();
        return sQLSessionContext;
    }

    @Override
    public void pushNestedSessionContext(Activation activation, boolean bl, String string) throws StandardException {
        this.setupSessionContextMinion(activation, true, bl, string);
    }

    private void setupSessionContextMinion(Activation activation, boolean bl, boolean bl2, String string) throws StandardException {
        Object object;
        SQLSessionContext sQLSessionContext = activation.setupSQLSessionContextForChildren(bl);
        if (bl2) {
            sQLSessionContext.setUser(string);
        } else {
            sQLSessionContext.setUser(this.getCurrentUserId(activation));
        }
        if (bl2) {
            sQLSessionContext.setRole(null);
        } else {
            sQLSessionContext.setRole(this.getCurrentRoleId(activation));
        }
        if (bl2) {
            object = this.getDataDictionary().getSchemaDescriptor(string, this.getTransactionExecute(), false);
            if (object == null) {
                object = new SchemaDescriptor(this.getDataDictionary(), string, string, null, false);
            }
            sQLSessionContext.setDefaultSchema((SchemaDescriptor)object);
        } else {
            sQLSessionContext.setDefaultSchema(this.getDefaultSchema(activation));
        }
        object = this.getCurrentSQLSessionContext(activation);
        sQLSessionContext.setDeferredAll(object.getDeferredAll());
        sQLSessionContext.setConstraintModes(object.getConstraintModes());
        StatementContext statementContext = this.getStatementContext();
        statementContext.setSQLSessionContext(sQLSessionContext);
    }

    @Override
    public void popNestedSessionContext(Activation activation) throws StandardException {
        SQLSessionContext sQLSessionContext = activation.getSQLSessionContextForChildren();
        SQLSessionContext sQLSessionContext2 = this.getCurrentSQLSessionContext(activation);
        this.compareConstraintModes(sQLSessionContext, sQLSessionContext2);
    }

    private void compareConstraintModes(SQLSessionContext sQLSessionContext, SQLSessionContext sQLSessionContext2) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        for (DeferredConstraintsMemory.ValidationInfo validationInfo : this.deferredHashTables.values()) {
            validationInfo.possiblyValidateOnReturn(this, sQLSessionContext, sQLSessionContext2);
        }
    }

    @Override
    public boolean isEffectivelyDeferred(SQLSessionContext sQLSessionContext, UUID uUID) throws StandardException {
        boolean bl;
        Boolean bl2 = sQLSessionContext.isDeferred(uUID);
        DataDictionary dataDictionary = this.getDataDictionary();
        if (bl2 != null) {
            bl = bl2;
        } else {
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(uUID);
            bl = constraintDescriptor.initiallyDeferred();
        }
        return bl;
    }

    @Override
    public void setupSubStatementSessionContext(Activation activation) throws StandardException {
        this.setupSessionContextMinion(activation, false, false, null);
    }

    @Override
    public SQLSessionContext getTopLevelSQLSessionContext() {
        if (this.topLevelSSC == null) {
            this.topLevelSSC = new SQLSessionContextImpl(this.getInitialDefaultSchemaDescriptor(), this.getSessionUserId());
        }
        return this.topLevelSSC;
    }

    @Override
    public SQLSessionContext createSQLSessionContext() {
        return new SQLSessionContextImpl(this.getInitialDefaultSchemaDescriptor(), this.getSessionUserId());
    }

    @Override
    public Map<Object, Object> getPrintedObjectsMap() {
        if (this.printedObjectsMap == null) {
            this.printedObjectsMap = new IdentityHashMap<Object, Object>();
        }
        return this.printedObjectsMap;
    }

    @Override
    public boolean getXplainOnlyMode() {
        return this.xplainOnlyMode;
    }

    @Override
    public void setXplainOnlyMode(boolean bl) {
        this.xplainOnlyMode = bl;
    }

    @Override
    public String getXplainSchema() {
        return this.xplain_schema;
    }

    @Override
    public void setXplainSchema(String string) {
        this.xplain_schema = string;
    }

    @Override
    public void setXplainStatement(Object object, Object object2) {
        this.xplain_statements.put(object, object2);
    }

    @Override
    public Object getXplainStatement(Object object) {
        return this.xplain_statements.get(object);
    }

    @Override
    public void setASTVisitor(ASTVisitor aSTVisitor) {
        this.astWalker = aSTVisitor;
    }

    @Override
    public ASTVisitor getASTVisitor() {
        return this.astWalker;
    }

    @Override
    public void setInterruptedException(StandardException standardException) {
        this.interruptedException = standardException;
    }

    @Override
    public StandardException getInterruptedException() {
        return this.interruptedException;
    }

    @Override
    public FormatableBitSet getReferencedColumnMap(TableDescriptor tableDescriptor) {
        return this.referencedColumnMap.get(tableDescriptor);
    }

    @Override
    public void setReferencedColumnMap(TableDescriptor tableDescriptor, FormatableBitSet formatableBitSet) {
        this.referencedColumnMap.put(tableDescriptor, formatableBitSet);
    }

    @Override
    public void setConstraintDeferred(Activation activation, ConstraintDescriptor constraintDescriptor, boolean bl) throws StandardException {
        if (!bl) {
            this.validateDeferredConstraint(constraintDescriptor);
        }
        this.getCurrentSQLSessionContext(activation).setDeferred(constraintDescriptor.getUUID(), bl);
    }

    @Override
    public void checkIntegrity() throws StandardException {
        this.validateDeferredConstraints(true);
        this.clearDeferreds();
    }

    private void clearDeferreds() {
        this.deferredHashTables = null;
        this.getCurrentSQLSessionContext().resetConstraintModes();
    }

    @Override
    public void setDeferredAll(Activation activation, boolean bl) throws StandardException {
        if (!bl) {
            this.validateDeferredConstraints(false);
        }
        this.getCurrentSQLSessionContext(activation).setDeferredAll(bl);
    }

    @Override
    public HashMap<UUID, DeferredConstraintsMemory.ValidationInfo> getDeferredHashTables() {
        if (this.deferredHashTables == null) {
            this.deferredHashTables = new HashMap();
        }
        return this.deferredHashTables;
    }

    private void validateDeferredConstraints(boolean bl) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        for (DeferredConstraintsMemory.ValidationInfo validationInfo : this.deferredHashTables.values()) {
            validationInfo.validateConstraint(this, null, bl);
        }
    }

    private void validateDeferredConstraint(ConstraintDescriptor constraintDescriptor) throws StandardException {
        if (this.deferredHashTables == null) {
            return;
        }
        UUID uUID = constraintDescriptor.hasBackingIndex() ? constraintDescriptor.getUUID() : constraintDescriptor.getTableId();
        DeferredConstraintsMemory.ValidationInfo validationInfo = this.deferredHashTables.get(uUID);
        if (validationInfo == null) {
            return;
        }
        validationInfo.validateConstraint(this, constraintDescriptor.getUUID(), false);
    }
}

