/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

class CurrentOfResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private boolean next;
    private RowLocation rowLocation;
    private CursorResultSet cursor;
    private CursorResultSet target;
    private ExecRow sparseRow;
    private final String cursorName;

    CurrentOfResultSet(String string, Activation activation, int n2) {
        super(activation, n2, 0.0, 0.0);
        this.cursorName = string;
    }

    @Override
    public void openCore() throws StandardException {
        this.getCursor();
        this.next = false;
        this.isOpen = true;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.isOpen) {
            if (!this.next) {
                this.next = true;
                ExecRow execRow = this.cursor.getCurrentRow();
                if (execRow == null) {
                    throw StandardException.newException("24000", new Object[0]);
                }
                this.rowLocation = this.cursor.getRowLocation();
                this.currentRow = this.target.getCurrentRow();
                if (this.rowLocation == null || execRow != null && this.currentRow == null) {
                    this.activation.addWarning(StandardException.newWarning("01001", new Object[0]));
                    return null;
                }
                if (this.target instanceof TableScanResultSet) {
                    TableScanResultSet tableScanResultSet = (TableScanResultSet)this.target;
                    if (tableScanResultSet.indexCols != null && this.currentRow != null) {
                        this.currentRow = this.getSparseRow(this.currentRow, tableScanResultSet.indexCols);
                    }
                }
            } else {
                this.currentRow = null;
                this.rowLocation = null;
            }
        } else {
            this.currentRow = null;
            this.rowLocation = null;
        }
        this.setCurrentRow(this.currentRow);
        return this.currentRow;
    }

    private ExecRow getSparseRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n2;
        int n3;
        if (this.sparseRow == null) {
            n3 = 1;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n4 = n2 = nArray[i2] > 0 ? nArray[i2] : -nArray[i2];
                if (n2 <= n3) continue;
                n3 = n2;
            }
            this.sparseRow = new ValueRow(n3);
        }
        for (n3 = 1; n3 <= nArray.length; ++n3) {
            n2 = nArray[n3 - 1] > 0 ? nArray[n3 - 1] : -nArray[n3 - 1];
            this.sparseRow.setColumn(n2, execRow.getColumn(n3));
        }
        return this.sparseRow;
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            super.close();
        }
    }

    @Override
    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int n2) {
        return 0L;
    }

    @Override
    public RowLocation getRowLocation() {
        return this.rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private void getCursor() throws StandardException {
        LanguageConnectionContext languageConnectionContext;
        CursorActivation cursorActivation;
        if (this.cursor != null && this.cursor.isClosed()) {
            this.cursor = null;
            this.target = null;
        }
        if (this.cursor == null && (cursorActivation = (languageConnectionContext = this.getLanguageConnectionContext()).lookupCursorActivation(this.cursorName)) != null) {
            this.cursor = cursorActivation.getCursorResultSet();
            this.target = cursorActivation.getTargetResultSet();
            this.activation.setForUpdateIndexScan(cursorActivation.getForUpdateIndexScan());
            if (cursorActivation.getHeapConglomerateController() != null) {
                cursorActivation.getHeapConglomerateController().close();
            }
            cursorActivation.setHeapConglomerateController(this.activation.getHeapConglomerateController());
        }
        if (this.cursor == null || this.cursor.isClosed()) {
            throw StandardException.newException("42X30", this.cursorName);
        }
    }

    @Override
    public void updateRow(ExecRow execRow, RowChanger rowChanger) throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).updateRow(execRow, rowChanger);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        ((NoPutResultSet)((Object)this.cursor)).markRowAsDeleted();
    }
}

