/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int numDistinctAggs = 0;
    private int maxRowSize;
    private ScanController scanController;
    private ExecIndexRow sourceExecIndexRow;
    private ExecIndexRow sortResultRow;
    private boolean resultsComplete;
    private List<ExecRow> finishedResults;
    private ExecIndexRow[] resultRows;
    private List<List<Set<DataValueDescriptor>>> distinctValues;
    private boolean rollup;
    private boolean usingAggregateObserver = false;
    private long genericSortId;
    private TransactionController tc;
    public Properties sortProperties = new Properties();

    GroupedAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n2, int n3, Activation activation, int n4, int n5, int n6, double d2, double d3, boolean bl2) throws StandardException {
        super(noPutResultSet, n2, activation, n4, n6, d2, d3);
        this.isInSortedOrder = bl;
        this.rollup = bl2;
        this.finishedResults = new ArrayList<ExecRow>();
        this.order = (ColumnOrdering[])((FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n3)).getArray(ColumnOrdering[].class);
        this.hasDistinctAggregate = this.aggInfoList.hasDistinct();
        this.usingAggregateObserver = !bl && !this.rollup && !this.hasDistinctAggregate;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sortResultRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.sourceExecIndexRow = (ExecIndexRow)this.getRowTemplate().getClone();
        this.source.openCore();
        try {
            ExecIndexRow execIndexRow;
            if (!this.isInSortedOrder) {
                this.scanController = this.loadSorter();
            }
            boolean bl = this.resultsComplete = (execIndexRow = this.getNextRowFromRS()) == null;
            if (this.usingAggregateObserver) {
                if (execIndexRow != null) {
                    this.finishedResults.add(this.finishAggregation(execIndexRow).getClone());
                }
            } else if (!this.resultsComplete) {
                this.resultRows = this.rollup ? new ExecIndexRow[this.numGCols() + 1] : new ExecIndexRow[1];
                if (this.aggInfoList.hasDistinct()) {
                    this.distinctValues = new ArrayList<List<Set<DataValueDescriptor>>>(this.resultRows.length);
                }
                for (int i2 = 0; i2 < this.resultRows.length; ++i2) {
                    this.resultRows[i2] = (ExecIndexRow)execIndexRow.getClone();
                    this.initializeVectorAggregation(this.resultRows[i2]);
                    if (!this.aggInfoList.hasDistinct()) continue;
                    this.distinctValues.add(new ArrayList(this.aggregates.length));
                    this.initializeDistinctMaps(i2, true);
                }
            }
        }
        catch (StandardException standardException) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw standardException;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecIndexRow execIndexRow;
        int n2 = (int)this.optimizerEstimatedRowCount;
        ExecIndexRow execIndexRow2 = this.getRowTemplate();
        this.tc = this.getTransactionController();
        BasicSortObserver basicSortObserver = this.usingAggregateObserver ? new AggregateSortObserver(true, this.aggregates, this.aggregates, execIndexRow2) : new BasicSortObserver(true, false, execIndexRow2, true);
        this.genericSortId = this.tc.createSort(null, execIndexRow2.getRowArray(), this.order, basicSortObserver, false, n2, this.maxRowSize);
        SortController sortController = this.tc.openSort(this.genericSortId);
        while ((execIndexRow = this.getNextRowFromRS()) != null) {
            sortController.insert(execIndexRow.getRowArray());
        }
        this.source.close();
        sortController.completedInserts();
        this.sortProperties = sortController.getSortInfo().getAllSortInfo(this.sortProperties);
        if (this.aggInfoList.hasDistinct()) {
            this.numDistinctAggs = 1;
        }
        return this.tc.openSortScan(this.genericSortId, this.activation.getResultSetHoldability());
    }

    private int numGCols() {
        return this.order.length - this.numDistinctAggs;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        if (this.resultsComplete) {
            return null;
        }
        ExecIndexRow execIndexRow = this.getNextRowFromRS();
        if (execIndexRow == null) {
            return this.finalizeResults();
        }
        if (this.usingAggregateObserver) {
            return this.finishAggregation(execIndexRow);
        }
        while (execIndexRow != null) {
            ExecIndexRow execIndexRow2 = this.resultRows[this.resultRows.length - 1];
            ExecRow execRow = execIndexRow.getClone();
            this.initializeVectorAggregation(execIndexRow);
            int n2 = this.sameGroupingValues(execIndexRow2, execIndexRow);
            for (int i2 = 0; i2 < this.resultRows.length; ++i2) {
                boolean bl;
                boolean bl2 = this.rollup ? i2 <= n2 : (bl = n2 == this.numGCols());
                if (bl) {
                    this.mergeVectorAggregates(execIndexRow, this.resultRows[i2], i2);
                    continue;
                }
                this.setRollupColumnsToNull(this.resultRows[i2], i2);
                this.finishedResults.add(this.finishAggregation(this.resultRows[i2]));
                this.resultRows[i2] = (ExecIndexRow)execRow.getClone();
                this.initializeVectorAggregation(this.resultRows[i2]);
                this.initializeDistinctMaps(i2, false);
            }
            if (this.finishedResults.size() > 0) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                ++this.rowsReturned;
                return this.makeCurrent(this.finishedResults.remove(0));
            }
            execIndexRow = this.getNextRowFromRS();
        }
        return this.finalizeResults();
    }

    private ExecRow makeCurrent(Object object) throws StandardException {
        ExecRow execRow = (ExecRow)object;
        this.setCurrentRow(execRow);
        return execRow;
    }

    private ExecRow finalizeResults() throws StandardException {
        this.resultsComplete = true;
        if (!this.usingAggregateObserver) {
            for (int i2 = 0; i2 < this.resultRows.length; ++i2) {
                this.setRollupColumnsToNull(this.resultRows[i2], i2);
                this.finishedResults.add(this.finishAggregation(this.resultRows[i2]));
            }
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (this.finishedResults.size() > 0) {
            return this.makeCurrent(this.finishedResults.remove(0));
        }
        return null;
    }

    private int sameGroupingValues(ExecRow execRow, ExecRow execRow2) throws StandardException {
        for (int i2 = 0; i2 < this.numGCols(); ++i2) {
            DataValueDescriptor dataValueDescriptor;
            DataValueDescriptor dataValueDescriptor2 = execRow.getColumn(this.order[i2].getColumnId() + 1);
            if (dataValueDescriptor2.compare(2, dataValueDescriptor = execRow2.getColumn(this.order[i2].getColumnId() + 1), true, true)) continue;
            return i2;
        }
        return this.numGCols();
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.sourceExecIndexRow = null;
            this.closeSource();
            if (!this.isInSortedOrder) {
                this.tc.dropSort(this.genericSortId);
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.originalSource.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rowLocation = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rowLocation);
        return rowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    private ExecIndexRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecIndexRow getRowFromResultSet() throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(execRow);
            execIndexRow = this.sourceExecIndexRow;
        }
        return execIndexRow;
    }

    private void setRollupColumnsToNull(ExecRow execRow, int n2) throws StandardException {
        int n3 = this.resultRows.length - n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.numGCols() - 1 - i2;
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(this.order[n4].getColumnId() + 1);
            dataValueDescriptor.setToNull();
        }
    }

    private ExecIndexRow getRowFromSorter() throws StandardException {
        ExecIndexRow execIndexRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            execIndexRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(execIndexRow.getRowArray());
        }
        return execIndexRow;
    }

    public void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    private void initializeVectorAggregation(ExecRow execRow) throws StandardException {
        for (GenericAggregator genericAggregator : this.aggregates) {
            genericAggregator.initialize(execRow);
            genericAggregator.accumulate(execRow, execRow);
        }
    }

    private void mergeVectorAggregates(ExecRow execRow, ExecRow execRow2, int n2) throws StandardException {
        for (int i2 = 0; i2 < this.aggregates.length; ++i2) {
            DataValueDescriptor dataValueDescriptor;
            GenericAggregator genericAggregator = this.aggregates[i2];
            AggregatorInfo aggregatorInfo = (AggregatorInfo)this.aggInfoList.elementAt(i2);
            if (aggregatorInfo.isDistinct() && !(dataValueDescriptor = genericAggregator.getInputColumnValue(execRow)).isNull() && !this.distinctValues.get(n2).get(i2).add(dataValueDescriptor)) continue;
            genericAggregator.merge(execRow, execRow2);
        }
    }

    private void initializeDistinctMaps(int n2, boolean bl) throws StandardException {
        for (int i2 = 0; i2 < this.aggregates.length; ++i2) {
            AggregatorInfo aggregatorInfo = (AggregatorInfo)this.aggInfoList.elementAt(i2);
            if (bl) {
                this.distinctValues.get(n2).add(aggregatorInfo.isDistinct() ? new HashSet() : null);
            }
            if (!aggregatorInfo.isDistinct()) continue;
            Set<DataValueDescriptor> set = this.distinctValues.get(n2).get(i2);
            set.clear();
            DataValueDescriptor dataValueDescriptor = this.aggregates[i2].getInputColumnValue(this.resultRows[n2]);
            set.add(dataValueDescriptor);
        }
    }
}

