/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.ScanResultSet;

public class HashScanResultSet
extends ScanResultSet
implements CursorResultSet {
    private boolean hashtableBuilt;
    private ExecIndexRow startPosition;
    private ExecIndexRow stopPosition;
    protected ExecRow compactRow;
    protected boolean firstNext = true;
    private int numFetchedOnNext;
    private int entryVectorSize;
    private List entryVector;
    private long conglomId;
    protected StaticCompiledOpenConglomInfo scoci;
    private GeneratedMethod startKeyGetter;
    private int startSearchOperator;
    private GeneratedMethod stopKeyGetter;
    private int stopSearchOperator;
    public Qualifier[][] scanQualifiers;
    public Qualifier[][] nextQualifiers;
    private int initialCapacity;
    private float loadFactor;
    private int maxCapacity;
    public String userSuppliedOptimizerOverrides;
    public boolean forUpdate;
    private boolean runTimeStatisticsOn;
    public int[] keyColumns;
    private boolean sameStartStopPosition;
    private boolean skipNullKeyColumns;
    private boolean keepAfterCommit;
    protected BackingStoreHashtable hashtable;
    protected boolean eliminateDuplicates;
    public Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public int hashtableSize;
    public boolean isConstraint;
    public static final int DEFAULT_INITIAL_CAPACITY = -1;
    public static final float DEFAULT_LOADFACTOR = -1.0f;
    public static final int DEFAULT_MAX_CAPACITY = -1;

    HashScanResultSet(long l2, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, Activation activation, int n2, int n3, GeneratedMethod generatedMethod, int n4, GeneratedMethod generatedMethod2, int n5, boolean bl, Qualifier[][] qualifierArray, Qualifier[][] qualifierArray2, int n6, float f2, int n7, int n8, String string, String string2, String string3, boolean bl2, boolean bl3, int n9, int n10, boolean bl4, int n11, boolean bl5, double d2, double d3) throws StandardException {
        super(activation, n3, n2, n10, bl4, n11, n9, d2, d3);
        this.scoci = staticCompiledOpenConglomInfo;
        this.conglomId = l2;
        this.startKeyGetter = generatedMethod;
        this.startSearchOperator = n4;
        this.stopKeyGetter = generatedMethod2;
        this.stopSearchOperator = n5;
        this.sameStartStopPosition = bl;
        this.scanQualifiers = qualifierArray;
        this.nextQualifiers = qualifierArray2;
        this.initialCapacity = n6;
        this.loadFactor = f2;
        this.maxCapacity = n7;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.isConstraint = bl2;
        this.forUpdate = bl3;
        this.skipNullKeyColumns = bl5;
        this.keepAfterCommit = activation.getResultSetHoldability();
        FormatableArrayHolder formatableArrayHolder = (FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n8);
        FormatableIntHolder[] formatableIntHolderArray = (FormatableIntHolder[])formatableArrayHolder.getArray(FormatableIntHolder[].class);
        this.keyColumns = new int[formatableIntHolderArray.length];
        for (int i2 = 0; i2 < formatableIntHolderArray.length; ++i2) {
            this.keyColumns[i2] = formatableIntHolderArray[i2].getInt();
        }
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.setRowLocationsState();
        this.compactRow = this.getCompactRow(this.candidate, this.accessedCols, false);
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        TransactionController transactionController = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (this.startKeyGetter != null) {
            this.startPosition = (ExecIndexRow)this.startKeyGetter.invoke(this.activation);
            if (this.sameStartStopPosition) {
                this.stopPosition = this.startPosition;
            }
        }
        if (this.stopKeyGetter != null) {
            this.stopPosition = (ExecIndexRow)this.stopKeyGetter.invoke(this.activation);
        }
        if (!this.skipScan(this.startPosition, this.stopPosition) && !this.hashtableBuilt) {
            DataValueDescriptor[] dataValueDescriptorArray = this.startPosition == null ? null : this.startPosition.getRowArray();
            DataValueDescriptor[] dataValueDescriptorArray2 = this.stopPosition == null ? null : this.stopPosition.getRowArray();
            this.hashtable = transactionController.createBackingStoreHashtableFromScan(this.conglomId, this.forUpdate ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, dataValueDescriptorArray, this.startSearchOperator, this.scanQualifiers, dataValueDescriptorArray2, this.stopSearchOperator, -1L, this.keyColumns, this.eliminateDuplicates, -1L, this.maxCapacity, this.initialCapacity, this.loadFactor, this.runTimeStatisticsOn, this.skipNullKeyColumns, this.keepAfterCommit, this.fetchRowLocations);
            if (this.runTimeStatisticsOn) {
                this.hashtableSize = this.hashtable.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.hashtable != null) {
                        this.hashtable.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
            }
            this.hashtableBuilt = true;
            this.activation.informOfRowCount(this, this.hashtableSize);
        }
        this.isOpen = true;
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void resetProbeVariables() throws StandardException {
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen && this.hashtableBuilt) {
            do {
                if (this.firstNext) {
                    Object object;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        object = this.hashtable.get(this.nextQualifiers[0][0].getOrderable());
                    } else {
                        KeyHasher keyHasher = new KeyHasher(this.keyColumns.length);
                        for (int i2 = 0; i2 < this.keyColumns.length; ++i2) {
                            DataValueDescriptor dataValueDescriptor = this.nextQualifiers[0][i2].getOrderable();
                            if (dataValueDescriptor == null) {
                                keyHasher = null;
                                break;
                            }
                            keyHasher.setObject(i2, this.nextQualifiers[0][i2].getOrderable());
                        }
                        Object object2 = object = keyHasher == null ? null : this.hashtable.get(keyHasher);
                    }
                    if (object instanceof List) {
                        this.entryVector = (List)object;
                        this.entryVectorSize = this.entryVector.size();
                        dataValueDescriptorArray = this.unpackHashValue(this.entryVector.get(0));
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        dataValueDescriptorArray = this.unpackHashValue(object);
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    dataValueDescriptorArray = this.unpackHashValue(this.entryVector.get(this.numFetchedOnNext));
                }
                if (dataValueDescriptorArray != null) {
                    if (RowUtil.qualifyRow(dataValueDescriptorArray, this.nextQualifiers)) {
                        this.setCompatRow(this.compactRow, dataValueDescriptorArray);
                        ++this.rowsSeen;
                        execRow = this.compactRow;
                    } else {
                        execRow = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                execRow = null;
            } while (execRow == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.hashtableBuilt) {
                this.scanProperties = this.getScanProperties();
                if (this.runTimeStatisticsOn) {
                    this.startPositionString = this.printStartPosition();
                    this.stopPositionString = this.printStopPosition();
                }
                this.hashtable.close();
                this.hashtable = null;
                this.hashtableBuilt = false;
            }
            this.startPosition = null;
            this.stopPosition = null;
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2;
        }
        return l2;
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (!this.hashtableBuilt) {
            return null;
        }
        return (RowLocation)this.currentRow.getColumn(this.currentRow.nColumns());
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return null;
    }

    public String printStartPosition() {
        return this.printPosition(this.startSearchOperator, this.startKeyGetter, this.startPosition);
    }

    public String printStopPosition() {
        if (this.sameStartStopPosition) {
            return this.printPosition(this.stopSearchOperator, this.startKeyGetter, this.startPosition);
        }
        return this.printPosition(this.stopSearchOperator, this.stopKeyGetter, this.stopPosition);
    }

    private String printPosition(int n2, GeneratedMethod generatedMethod, ExecIndexRow execIndexRow) {
        String string = "";
        String string2 = "";
        if (generatedMethod == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        ExecIndexRow execIndexRow2 = null;
        try {
            execIndexRow2 = (ExecIndexRow)generatedMethod.invoke(this.activation);
        }
        catch (StandardException standardException) {
            if (execIndexRow == null) {
                return "\t" + MessageService.getTextMessage("42Z38.U", new Object[0]);
            }
            return "\t" + MessageService.getTextMessage("42Z39.U", new Object[0]) + "\n";
        }
        if (execIndexRow2 == null) {
            return "\t" + MessageService.getTextMessage("42Z37.U", new Object[0]) + "\n";
        }
        String string3 = null;
        switch (n2) {
            case 1: {
                string3 = ">=";
                break;
            }
            case -1: {
                string3 = ">";
                break;
            }
            default: {
                string3 = "unknown value (" + n2 + ")";
            }
        }
        string2 = string2 + "\t" + MessageService.getTextMessage("42Z40.U", string3, String.valueOf(execIndexRow2.nColumns())) + "\n";
        string2 = string2 + "\t" + MessageService.getTextMessage("42Z41.U", new Object[0]) + "\n";
        boolean bl = false;
        for (int i2 = 0; i2 < execIndexRow2.nColumns(); ++i2) {
            if (execIndexRow2.areNullsOrdered(i2)) {
                string2 = string2 + i2 + " ";
                bl = true;
            }
            if (!bl || i2 != execIndexRow2.nColumns() - 1) continue;
            string2 = string2 + "\n";
        }
        return string2;
    }

    public Properties getScanProperties() {
        return this.scanProperties;
    }

    @Override
    public boolean isForUpdate() {
        return this.forUpdate;
    }
}

