/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.IndexChanger;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class IndexSetChanger {
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    private DynamicCompiledOpenConglomInfo[] indexDCOCIs;
    private StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    ConglomerateController baseCC;
    FormatableBitSet baseRowReadMap;
    TransactionController tc;
    TemporaryRowHolderImpl rowHolder;
    IndexChanger[] indexChangers;
    private int lockMode;
    boolean[] fixOnUpdate;
    boolean isOpen = false;
    private static final int NO_INDEXES = 0;
    private static final int UPDATE_INDEXES = 1;
    private static final int ALL_INDEXES = 2;
    private int whatIsOpen = 0;
    private int isolationLevel;
    private final Activation activation;

    public IndexSetChanger(IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, DynamicCompiledOpenConglomInfo[] dynamicCompiledOpenConglomInfoArray, String[] stringArray, ConglomerateController conglomerateController, TransactionController transactionController, int n2, FormatableBitSet formatableBitSet, int n3, Activation activation) throws StandardException {
        this.irgs = indexRowGeneratorArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexDCOCIs = dynamicCompiledOpenConglomInfoArray;
        this.indexNames = stringArray;
        this.baseCC = conglomerateController;
        this.tc = transactionController;
        this.lockMode = n2;
        this.baseRowReadMap = formatableBitSet;
        this.isolationLevel = n3;
        this.activation = activation;
        this.indexChangers = new IndexChanger[indexRowGeneratorArray.length];
    }

    public void open(boolean[] blArray) throws StandardException {
        this.fixOnUpdate = blArray;
        this.isOpen = true;
    }

    public void setRowHolder(TemporaryRowHolderImpl temporaryRowHolderImpl) {
        this.rowHolder = temporaryRowHolderImpl;
    }

    private void openIndexes(int n2) throws StandardException {
        if (this.whatIsOpen >= n2) {
            return;
        }
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            if (n2 == 1 && !this.fixOnUpdate[i2]) continue;
            if (this.indexChangers[i2] == null) {
                this.indexChangers[i2] = new IndexChanger(this.irgs[i2], this.indexCIDS[i2], this.indexSCOCIs == null ? (StaticCompiledOpenConglomInfo)null : this.indexSCOCIs[i2], this.indexDCOCIs == null ? (DynamicCompiledOpenConglomInfo)null : this.indexDCOCIs[i2], this.indexNames == null ? null : this.indexNames[i2], this.baseCC, this.tc, this.lockMode, this.baseRowReadMap, this.isolationLevel, this.activation);
                this.indexChangers[i2].setRowHolder(this.rowHolder);
            } else {
                this.indexChangers[i2].setBaseCC(this.baseCC);
            }
            this.indexChangers[i2].open();
        }
        this.whatIsOpen = n2;
    }

    public void delete(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            this.indexChangers[i2].delete(execRow, rowLocation);
        }
    }

    public void insert(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.openIndexes(2);
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            this.indexChangers[i2].insert(execRow, rowLocation);
        }
    }

    public void update(ExecRow execRow, ExecRow execRow2, RowLocation rowLocation) throws StandardException {
        this.openIndexes(1);
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            if (!this.fixOnUpdate[i2]) continue;
            this.indexChangers[i2].update(execRow, execRow2, rowLocation);
        }
    }

    public void setBaseCC(ConglomerateController conglomerateController) {
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            if (this.indexChangers[i2] == null) continue;
            this.indexChangers[i2].setBaseCC(conglomerateController);
        }
        this.baseCC = conglomerateController;
    }

    public void finish() throws StandardException {
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            if (this.indexChangers[i2] == null) continue;
            this.indexChangers[i2].finish();
        }
    }

    public void close() throws StandardException {
        this.whatIsOpen = 0;
        for (int i2 = 0; i2 < this.indexChangers.length; ++i2) {
            if (this.indexChangers[i2] == null) continue;
            this.indexChangers[i2].close();
        }
        this.fixOnUpdate = null;
        this.isOpen = false;
        this.rowHolder = null;
    }

    public String toString() {
        return null;
    }
}

