/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ScanResultSet;

class LastIndexKeyResultSet
extends ScanResultSet {
    protected long conglomId;
    protected int startSearchOperator;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String userSuppliedOptimizerOverrides;
    protected boolean runTimeStatisticsOn;
    public String stopPositionString;
    public boolean coarserLock;
    public boolean returnedRow;

    public LastIndexKeyResultSet(Activation activation, int n2, int n3, long l2, String string, String string2, String string3, int n4, int n5, boolean bl, int n6, double d2, double d3) throws StandardException {
        super(activation, n2, n3, n5, bl, n6, n4, d2, d3);
        this.conglomId = l2;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        activation.informOfRowCount(this, 1L);
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        ExecRow execRow = this.candidate.getClone();
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        TransactionController transactionController = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (transactionController.fetchMaxOnBtree(this.conglomId, 0, this.lockMode, this.isolationLevel, this.accessedCols, execRow.getRowArray())) {
            this.setCurrentRow(this.getCompactRow(execRow, this.accessedCols, true));
        } else {
            this.clearCurrentRow();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        if (this.returnedRow || !this.isOpen) {
            this.clearCurrentRow();
        } else {
            this.returnedRow = true;
        }
        return this.currentRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.isOpen = false;
            this.returnedRow = false;
            this.clearCurrentRow();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2;
        }
        return l2;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }
}

