/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.ForeignKeyRIChecker;
import org.apache.derby.impl.sql.execute.GenericRIChecker;
import org.apache.derby.impl.sql.execute.ReferencedKeyRIChecker;

public class RISetChecker {
    private GenericRIChecker[] checkers;
    LanguageConnectionContext lcc;

    public RISetChecker(LanguageConnectionContext languageConnectionContext, TransactionController transactionController, FKInfo[] fKInfoArray) throws StandardException {
        if (fKInfoArray == null) {
            return;
        }
        this.checkers = new GenericRIChecker[fKInfoArray.length];
        this.lcc = languageConnectionContext;
        for (int i2 = 0; i2 < fKInfoArray.length; ++i2) {
            this.checkers[i2] = fKInfoArray[i2].type == 1 ? new ForeignKeyRIChecker(languageConnectionContext, transactionController, fKInfoArray[i2]) : new ReferencedKeyRIChecker(languageConnectionContext, transactionController, fKInfoArray[i2]);
        }
    }

    void reopen() throws StandardException {
    }

    public void doPKCheck(Activation activation, ExecRow execRow, boolean bl, int n2) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (GenericRIChecker genericRIChecker : this.checkers) {
            if (!(genericRIChecker instanceof ReferencedKeyRIChecker)) continue;
            genericRIChecker.doCheck(activation, execRow, bl, n2);
        }
    }

    public void postCheck() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.checkers.length; ++i2) {
            this.postCheck(i2);
        }
    }

    public void postCheck(int n2) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        if (this.checkers[n2] instanceof ReferencedKeyRIChecker) {
            ((ReferencedKeyRIChecker)this.checkers[n2]).postCheck();
        }
    }

    public void doFKCheck(Activation activation, ExecRow execRow) throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.checkers.length; ++i2) {
            if (!(this.checkers[i2] instanceof ForeignKeyRIChecker)) continue;
            this.checkers[i2].doCheck(activation, execRow, false, 0);
        }
    }

    public void doRICheck(Activation activation, int n2, ExecRow execRow, boolean bl, int n3) throws StandardException {
        this.checkers[n2].doCheck(activation, execRow, bl, n3);
    }

    public void close() throws StandardException {
        if (this.checkers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.checkers.length; ++i2) {
            this.checkers[i2].close();
        }
    }
}

