/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class SetOpResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private final NoPutResultSet leftSource;
    private final NoPutResultSet rightSource;
    private final Activation activation;
    private final int opType;
    private final boolean all;
    private final int resultSetNumber;
    private DataValueDescriptor[] prevCols;
    private ExecRow leftInputRow;
    private ExecRow rightInputRow;
    private final int[] intermediateOrderByColumns;
    private final int[] intermediateOrderByDirection;
    private final boolean[] intermediateOrderByNullsLow;
    private int rowsSeenLeft;
    private int rowsSeenRight;
    private int rowsReturned;

    SetOpResultSet(NoPutResultSet noPutResultSet, NoPutResultSet noPutResultSet2, Activation activation, int n2, long l2, double d2, int n3, boolean bl, int n4, int n5, int n6) {
        super(activation, n2, (double)l2, d2);
        this.leftSource = noPutResultSet;
        this.rightSource = noPutResultSet2;
        this.activation = activation;
        this.resultSetNumber = n2;
        this.opType = n3;
        this.all = bl;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.intermediateOrderByColumns = (int[])execPreparedStatement.getSavedObject(n4);
        this.intermediateOrderByDirection = (int[])execPreparedStatement.getSavedObject(n5);
        this.intermediateOrderByNullsLow = (boolean[])execPreparedStatement.getSavedObject(n6);
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.leftSource.openCore();
        try {
            this.rightSource.openCore();
            this.rightInputRow = this.rightSource.getNextRowCore();
        }
        catch (StandardException standardException) {
            this.isOpen = true;
            try {
                this.close();
            }
            catch (StandardException standardException2) {
                // empty catch block
            }
            throw standardException;
        }
        if (this.rightInputRow != null) {
            ++this.rowsSeenRight;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((this.leftInputRow = this.leftSource.getNextRowCore()) != null) {
                ++this.rowsSeenLeft;
                DataValueDescriptor[] dataValueDescriptorArray = this.leftInputRow.getRowArray();
                if (!this.all) {
                    if (this.isDuplicate(dataValueDescriptorArray)) continue;
                    this.prevCols = this.leftInputRow.getRowArrayClone();
                }
                int n2 = 0;
                while (this.rightInputRow != null && (n2 = this.compare(dataValueDescriptorArray, this.rightInputRow.getRowArray())) > 0) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow == null) continue;
                    ++this.rowsSeenRight;
                }
                if (this.rightInputRow == null || n2 < 0) {
                    if (this.opType != 2) continue;
                    break;
                }
                if (this.all) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow != null) {
                        ++this.rowsSeenRight;
                    }
                }
                if (this.opType != 1) continue;
                break;
            }
        }
        this.setCurrentRow(this.leftInputRow);
        if (this.currentRow != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return this.currentRow;
    }

    private void advanceRightPastDuplicates(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        while ((this.rightInputRow = this.rightSource.getNextRowCore()) != null) {
            ++this.rowsSeenRight;
            if (this.compare(dataValueDescriptorArray, this.rightInputRow.getRowArray()) != 0) continue;
        }
    }

    private int compare(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        for (int i2 = 0; i2 < this.intermediateOrderByColumns.length; ++i2) {
            int n2 = this.intermediateOrderByColumns[i2];
            if (dataValueDescriptorArray[n2].compare(1, dataValueDescriptorArray2[n2], true, this.intermediateOrderByNullsLow[i2], false)) {
                return -1 * this.intermediateOrderByDirection[i2];
            }
            if (dataValueDescriptorArray[n2].compare(2, dataValueDescriptorArray2[n2], true, this.intermediateOrderByNullsLow[i2], false)) continue;
            return this.intermediateOrderByDirection[i2];
        }
        return 0;
    }

    private boolean isDuplicate(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.prevCols == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.intermediateOrderByColumns.length; ++i2) {
            int n2 = this.intermediateOrderByColumns[i2];
            if (dataValueDescriptorArray[n2].compare(2, this.prevCols[n2], true, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.prevCols = null;
            this.leftSource.close();
            this.rightSource.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        this.leftSource.finish();
        this.rightSource.finish();
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n2 == 0) {
            return l2 - this.leftSource.getTimeSpent(1) - this.rightSource.getTimeSpent(1);
        }
        return l2;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.leftSource)).getRowLocation();
    }

    public int getOpType() {
        return this.opType;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public NoPutResultSet getLeftSourceInput() {
        return this.leftSource;
    }

    public NoPutResultSet getRightSourceInput() {
        return this.rightSource;
    }

    public int getRowsSeenLeft() {
        return this.rowsSeenLeft;
    }

    public int getRowsSeenRight() {
        return this.rowsSeenRight;
    }

    public int getRowsReturned() {
        return this.rowsReturned;
    }
}

