/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;
import org.apache.derby.impl.sql.execute.GenericTriggerExecutor;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.RowTriggerExecutor;
import org.apache.derby.impl.sql.execute.StatementTriggerExecutor;
import org.apache.derby.impl.sql.execute.TriggerEvent;
import org.apache.derby.impl.sql.execute.TriggerInfo;

public class TriggerEventActivator {
    private LanguageConnectionContext lcc;
    private TriggerInfo triggerInfo;
    private InternalTriggerExecutionContext tec;
    private GenericTriggerExecutor[][] executors;
    private Activation activation;
    private ConnectionContext cc;
    private String statementText;
    private int dmlType;
    private UUID tableId;
    private String tableName;

    public TriggerEventActivator(LanguageConnectionContext languageConnectionContext, UUID uUID, TriggerInfo triggerInfo, int n2, Activation activation, Vector<AutoincrementCounter> vector) throws StandardException {
        if (triggerInfo == null) {
            return;
        }
        this.tableName = triggerInfo.triggerArray[0].getTableDescriptor().getQualifiedName();
        this.lcc = languageConnectionContext;
        this.activation = activation;
        this.tableId = uUID;
        this.dmlType = n2;
        this.triggerInfo = triggerInfo;
        this.cc = (ConnectionContext)((Object)languageConnectionContext.getContextManager().getContext("JDBC_ConnectionContext"));
        this.statementText = languageConnectionContext.getStatementContext().getStatementText();
        this.tec = ((GenericExecutionFactory)languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(languageConnectionContext, this.cc, this.statementText, n2, uUID, this.tableName, vector);
        this.setupExecutors(triggerInfo);
    }

    void reopen() throws StandardException {
        this.tec = ((GenericExecutionFactory)this.lcc.getLanguageConnectionFactory().getExecutionFactory()).getTriggerExecutionContext(this.lcc, this.cc, this.statementText, this.dmlType, this.tableId, this.tableName, null);
        this.setupExecutors(this.triggerInfo);
    }

    private void setupExecutors(TriggerInfo triggerInfo) throws StandardException {
        Object object;
        int n2;
        this.executors = new GenericTriggerExecutor[6][];
        ArrayList arrayList = new ArrayList(6);
        for (n2 = 0; n2 < 6; ++n2) {
            arrayList.add(new ArrayList());
        }
        block6: for (n2 = 0; n2 < triggerInfo.triggerArray.length; ++n2) {
            object = triggerInfo.triggerArray[n2];
            switch (((TriggerDescriptor)object).getTriggerEventMask()) {
                case 4: {
                    if (((TriggerDescriptor)object).isBeforeTrigger()) {
                        ((List)arrayList.get(0)).add(object);
                        continue block6;
                    }
                    ((List)arrayList.get(3)).add(object);
                    continue block6;
                }
                case 2: {
                    if (((TriggerDescriptor)object).isBeforeTrigger()) {
                        ((List)arrayList.get(1)).add(object);
                        continue block6;
                    }
                    ((List)arrayList.get(4)).add(object);
                    continue block6;
                }
                case 1: {
                    if (((TriggerDescriptor)object).isBeforeTrigger()) {
                        ((List)arrayList.get(2)).add(object);
                        continue block6;
                    }
                    ((List)arrayList.get(5)).add(object);
                    continue block6;
                }
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = (List)arrayList.get(n2);
            int n3 = object.size();
            if (n3 <= 0) continue;
            this.executors[n2] = new GenericTriggerExecutor[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                TriggerDescriptor triggerDescriptor = (TriggerDescriptor)object.get(i2);
                this.executors[n2][i2] = triggerDescriptor.isRowTrigger() ? new RowTriggerExecutor(this.tec, triggerDescriptor, this.activation, this.lcc) : new StatementTriggerExecutor(this.tec, triggerDescriptor, this.activation, this.lcc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(TriggerEvent triggerEvent, CursorResultSet cursorResultSet, CursorResultSet cursorResultSet2, int[] nArray) throws StandardException {
        if (this.executors == null) {
            return;
        }
        int n2 = triggerEvent.getNumber();
        if (this.executors[n2] == null) {
            return;
        }
        this.tec.setCurrentTriggerEvent(triggerEvent);
        try {
            if (cursorResultSet != null) {
                cursorResultSet.open();
            }
            if (cursorResultSet2 != null) {
                cursorResultSet2.open();
            }
            this.lcc.pushExecutionStmtValidator(this.tec);
            for (int i2 = 0; i2 < this.executors[n2].length; ++i2) {
                if (i2 > 0) {
                    if (cursorResultSet != null) {
                        ((NoPutResultSet)((Object)cursorResultSet)).reopenCore();
                    }
                    if (cursorResultSet2 != null) {
                        ((NoPutResultSet)((Object)cursorResultSet2)).reopenCore();
                    }
                }
                this.tec.resetAICounters(true);
                this.executors[n2][i2].fireTrigger(triggerEvent, cursorResultSet, cursorResultSet2, nArray);
            }
        }
        finally {
            this.lcc.popExecutionStmtValidator(this.tec);
            this.tec.clearCurrentTriggerEvent();
        }
    }

    public void cleanup() throws StandardException {
        if (this.tec != null) {
            this.tec.cleanup();
        }
    }
}

