/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealIndexRowToBaseRowStatistics
extends RealNoPutResultSetStatistics {
    public String tableName;
    public ResultSetStatistics childResultSetStatistics;
    public String colsAccessedFromHeap;

    public RealIndexRowToBaseRowStatistics(int n2, int n3, int n4, long l2, long l3, long l4, long l5, int n5, String string, FormatableBitSet formatableBitSet, double d2, double d3, ResultSetStatistics resultSetStatistics) {
        super(n2, n3, n4, l2, l3, l4, l5, n5, d2, d3);
        this.tableName = string;
        this.colsAccessedFromHeap = formatableBitSet == null ? "{" + MessageService.getTextMessage("43X59.U", new Object[0]) + "}" : formatableBitSet.toString();
        this.childResultSetStatistics = resultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int n2) {
        this.initFormatInfo(n2);
        return this.indent + MessageService.getTextMessage("43X60.U", this.tableName) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X61.U", new Object[0]) + " = " + this.colsAccessedFromHeap + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String string, int n2) {
        if (string == null || string.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n2);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.childResultSetStatistics);
        return vector;
    }

    @Override
    public String getNodeOn() {
        return MessageService.getTextMessage("43X62.U", this.tableName);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X63.U", new Object[0]);
    }

    ResultSetStatistics getChildResultSetStatistics() {
        return this.childResultSetStatistics;
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        int n2 = 0;
        if (this.childResultSetStatistics != null) {
            ++n2;
        }
        xPLAINVisitor.setNumberOfChildren(n2);
        xPLAINVisitor.visit(this);
        if (this.childResultSetStatistics != null) {
            this.childResultSetStatistics.accept(xPLAINVisitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "ROWIDSCAN";
    }

    @Override
    public String getRSXplainDetails() {
        return "(" + this.resultSetNumber + ")," + this.tableName;
    }
}

