/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;

public class BTreeController
extends OpenBTree
implements ConglomerateController {
    transient DataValueDescriptor[] scratch_template = null;
    boolean get_insert_row_lock;
    private static final int NO_MATCH = 0;
    private static final int MATCH_FOUND = 1;
    private static final int RESCAN_REQUIRED = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reclaim_deleted_rows(OpenBTree openBTree, long l2) throws StandardException {
        boolean bl = false;
        ControlRow controlRow = null;
        try {
            controlRow = ControlRow.get(openBTree, l2);
            if (controlRow == null) {
                boolean bl2 = false;
                return bl2;
            }
            LeafControlRow leafControlRow = (LeafControlRow)controlRow;
            BTreeLockingPolicy bTreeLockingPolicy = openBTree.getLockingPolicy();
            int n2 = leafControlRow.page.recordCount() - 1 - leafControlRow.page.nonDeletedRecordCount();
            if (n2 > 0) {
                Page page = leafControlRow.page;
                FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
                for (int i2 = page.recordCount() - 1; i2 > 0; --i2) {
                    if (!page.isDeletedAtSlot(i2) || !bTreeLockingPolicy.lockScanCommittedDeletedRow(openBTree, leafControlRow, this.scratch_template, fetchDescriptor, i2)) continue;
                    page.purgeAtSlot(i2, 1, true);
                    bl = true;
                }
            }
        }
        catch (ClassCastException classCastException) {
        }
        finally {
            if (controlRow != null) {
                if (bl) {
                    controlRow.page.setRepositionNeeded();
                } else {
                    controlRow.release();
                }
            }
        }
        return bl;
    }

    private long start_xact_and_dosplit(boolean bl, long l2, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        TransactionManager transactionManager = null;
        OpenBTree openBTree = null;
        ControlRow controlRow = null;
        transactionManager = this.init_open_user_scans.getInternalTransaction();
        boolean bl2 = true;
        if (bl) {
            ConglomerateController conglomerateController = null;
            try {
                conglomerateController = this.getConglomerate().lockTable(transactionManager, 132, 6, 4);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
            if (conglomerateController != null) {
                openBTree = new OpenBTree();
                openBTree.init(this.init_open_user_scans, transactionManager, null, transactionManager.getRawStoreXact(), false, 132, 6, this.getConglomerate().getBtreeLockingPolicy(transactionManager.getRawStoreXact(), 6, 1, 4, conglomerateController, openBTree), this.getConglomerate(), null, null);
                bl2 = !this.reclaim_deleted_rows(openBTree, l2);
                openBTree.close();
            }
        }
        long l3 = l2;
        if (bl2) {
            openBTree = new OpenBTree();
            openBTree.init(this.init_open_user_scans, transactionManager, null, transactionManager.getRawStoreXact(), false, this.getOpenMode(), 5, this.getConglomerate().getBtreeLockingPolicy(transactionManager.getRawStoreXact(), this.init_lock_level, 1, 4, null, openBTree), this.getConglomerate(), null, null);
            controlRow = ControlRow.get(openBTree, 1L);
            l3 = controlRow.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n2);
            openBTree.close();
        }
        transactionManager.commit();
        transactionManager.destroy();
        return l3;
    }

    private int comparePreviousRecord(int n2, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        RecordHandle recordHandle = null;
        boolean bl = false;
        LeafControlRow leafControlRow2 = leafControlRow;
        while (leafControlRow != null) {
            if (n2 == 0) {
                LeafControlRow leafControlRow3 = leafControlRow;
                try {
                    leafControlRow = (LeafControlRow)leafControlRow.getLeftSibling(this);
                    if (bl) {
                        leafControlRow3.release();
                    }
                    bl = true;
                    if (leafControlRow == null) {
                        return 0;
                    }
                    n2 = leafControlRow.page.recordCount() - 1;
                    continue;
                }
                catch (WaitError waitError) {
                    if (bl) {
                        leafControlRow3.release();
                    }
                    leafControlRow2.release();
                    return 2;
                }
            }
            recordHandle = leafControlRow.page.fetchFromSlot(null, n2, dataValueDescriptorArray, null, true);
            if (recordHandle != null) {
                boolean bl2;
                int n3 = this.compareRowsForInsert(dataValueDescriptorArray, dataValueDescriptorArray2, leafControlRow, n2);
                boolean bl3 = bl2 = n3 == 1 && leafControlRow.page.isDeletedAtSlot(n2);
                if (!bl2) {
                    if (bl) {
                        if (n3 == 2) {
                            leafControlRow2.release();
                        }
                        if (n3 != 2) {
                            leafControlRow.release();
                        }
                    }
                    return n3;
                }
            }
            --n2;
        }
        return 0;
    }

    private int compareNextRecord(int n2, LeafControlRow leafControlRow, DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        RecordHandle recordHandle = null;
        boolean bl = false;
        LeafControlRow leafControlRow2 = leafControlRow;
        while (leafControlRow != null) {
            if (n2 >= leafControlRow.page.recordCount()) {
                LeafControlRow leafControlRow3 = leafControlRow;
                leafControlRow = (LeafControlRow)leafControlRow.getRightSibling(this);
                if (bl) {
                    leafControlRow3.release();
                }
                bl = true;
                if (leafControlRow == null) {
                    return 0;
                }
                n2 = 1;
                continue;
            }
            recordHandle = leafControlRow.page.fetchFromSlot(null, n2, dataValueDescriptorArray, null, true);
            if (recordHandle != null) {
                boolean bl2;
                int n3 = this.compareRowsForInsert(dataValueDescriptorArray, dataValueDescriptorArray2, leafControlRow, n2);
                boolean bl3 = bl2 = n3 == 1 && leafControlRow.page.isDeletedAtSlot(n2);
                if (!bl2) {
                    if (bl) {
                        if (n3 == 2) {
                            leafControlRow2.release();
                        }
                        if (n3 != 2) {
                            leafControlRow.release();
                        }
                    }
                    return n3;
                }
            }
            ++n2;
        }
        return 0;
    }

    private int compareRowsForInsert(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2, LeafControlRow leafControlRow, int n2) throws StandardException {
        boolean bl;
        for (int i2 = 0; i2 < dataValueDescriptorArray.length - 1; ++i2) {
            if (dataValueDescriptorArray[i2].equals(dataValueDescriptorArray2[i2])) continue;
            return 0;
        }
        DataValueDescriptor[] dataValueDescriptorArray3 = this.runtime_mem.get_template(this.getRawTran());
        FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(dataValueDescriptorArray3.length - 1);
        RowLocation rowLocation = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        boolean bl2 = bl = !this.getLockingPolicy().lockNonScanRowOnPage(leafControlRow, n2, fetchDescriptor, dataValueDescriptorArray3, rowLocation, 1);
        if (bl) {
            return 2;
        }
        return 1;
    }

    private int compareLeftAndRightSiblings(DataValueDescriptor[] dataValueDescriptorArray, int n2, LeafControlRow leafControlRow) throws StandardException {
        if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
            int n3 = dataValueDescriptorArray.length - 1;
            boolean bl = false;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!dataValueDescriptorArray[i2].isNull()) continue;
                return 0;
            }
            if (!bl) {
                DataValueDescriptor[] dataValueDescriptorArray2 = this.runtime_mem.get_template(this.getRawTran());
                int n4 = this.comparePreviousRecord(n2 - 1, leafControlRow, dataValueDescriptorArray2, dataValueDescriptorArray);
                if (n4 > 0) {
                    return n4;
                }
                return this.compareNextRecord(n2, leafControlRow, dataValueDescriptorArray2, dataValueDescriptorArray);
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doIns(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        LeafControlRow leafControlRow = null;
        Object var3_3 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        SearchParameters searchParameters = new SearchParameters(dataValueDescriptorArray, 1, this.scratch_template, this, false);
        FetchDescriptor fetchDescriptor = RowUtil.getFetchDescriptorConstant(this.scratch_template.length - 1);
        RowLocation rowLocation = (RowLocation)this.scratch_template[this.scratch_template.length - 1];
        if (this.get_insert_row_lock) {
            this.getLockingPolicy().lockNonScanRow(this.getConglomerate(), null, null, dataValueDescriptorArray, 3);
        }
        while (true) {
            int n5;
            leafControlRow = (LeafControlRow)ControlRow.get(this, 1L).search(searchParameters);
            int n6 = searchParameters.resultExact ? searchParameters.resultSlot : searchParameters.resultSlot + 1;
            boolean bl2 = false;
            boolean bl3 = bl2 = !this.getLockingPolicy().lockNonScanPreviousRow(leafControlRow, n6, fetchDescriptor, this.scratch_template, rowLocation, this, 5, 1);
            if (bl2) {
                leafControlRow = null;
                continue;
            }
            if (searchParameters.resultExact) {
                n3 = n2 = searchParameters.resultSlot;
                if (this.getConglomerate().nKeyFields != this.getConglomerate().nUniqueColumns) {
                    boolean bl4 = bl2 = !this.getLockingPolicy().lockNonScanRowOnPage(leafControlRow, n2, fetchDescriptor, this.scratch_template, rowLocation, 1);
                    if (bl2) {
                        leafControlRow = null;
                        continue;
                    }
                }
                if (!leafControlRow.page.isDeletedAtSlot(n2)) {
                    n4 = 1;
                    break;
                }
                if (this.getConglomerate().nKeyFields == this.getConglomerate().nUniqueColumns) {
                    leafControlRow.page.deleteAtSlot(n2, false, this.btree_undo);
                    break;
                }
                if (this.getConglomerate().nUniqueColumns != this.getConglomerate().nKeyFields - 1) throw StandardException.newException("XSCB3.S", new Object[0]);
                leafControlRow.page.deleteAtSlot(n2, false, this.btree_undo);
                n5 = 1;
                try {
                    int n7;
                    if (this.runtime_mem.hasCollatedTypes()) {
                        n7 = this.getConglomerate().nKeyFields;
                        for (int i2 = 0; i2 < n7; ++i2) {
                            leafControlRow.page.updateFieldAtSlot(n2, i2, RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, i2), this.btree_undo);
                        }
                    } else {
                        n7 = this.getConglomerate().nKeyFields - 1;
                        leafControlRow.page.updateFieldAtSlot(n2, n7, RowUtil.getColumn(dataValueDescriptorArray, (FormatableBitSet)null, n7), this.btree_undo);
                    }
                }
                catch (StandardException standardException) {
                    if (!standardException.getMessageId().equals("XSDA3.S")) {
                        throw standardException;
                    }
                    n5 = 0;
                    leafControlRow.page.deleteAtSlot(n2, true, this.btree_undo);
                }
                if (n5 != 0) {
                    break;
                }
            } else if (leafControlRow.page.recordCount() - 1 < BTree.maxRowsPerPage) {
                n2 = searchParameters.resultSlot + 1;
                n3 = n2 + 1;
                if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                    n5 = this.compareLeftAndRightSiblings(dataValueDescriptorArray, n2, leafControlRow);
                    if (n5 == 1) {
                        n4 = 1;
                        break;
                    }
                    if (n5 == 2) continue;
                }
                if (leafControlRow.page.insertAtSlot(n2, dataValueDescriptorArray, null, this.btree_undo, (byte)1, 50) != null) break;
                if (leafControlRow.page.recordCount() <= 2) {
                    throw StandardException.newException("XSCB6.S", new Object[0]);
                }
            }
            if (this.getConglomerate().isUniqueWithDuplicateNulls()) {
                n5 = this.compareLeftAndRightSiblings(dataValueDescriptorArray, n2, leafControlRow);
                if (n5 == 1) {
                    n4 = 1;
                    break;
                }
                if (n5 == 2) continue;
            }
            n5 = 0;
            if (n2 == 1) {
                n5 |= 4;
                if (leafControlRow.isLeftmostLeaf()) {
                    n5 |= 8;
                }
            } else if (n2 == leafControlRow.page.recordCount()) {
                n5 |= 1;
                if (leafControlRow.isRightmostLeaf()) {
                    n5 |= 2;
                }
            }
            long l2 = leafControlRow.page.getPageNumber();
            if (leafControlRow.page.recordCount() - leafControlRow.page.nonDeletedRecordCount() <= 0) {
                bl = true;
            }
            BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow(dataValueDescriptorArray, l2);
            leafControlRow.release();
            leafControlRow = null;
            this.start_xact_and_dosplit(!bl, l2, this.scratch_template, branchRow.getRow(), n5);
            bl = true;
        }
        leafControlRow.last_search_result = n3;
        leafControlRow.release();
        return n4;
    }

    private boolean do_load_insert(DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow, int n2) throws StandardException {
        Object var4_4 = null;
        boolean bl = false;
        int n3 = leafControlRow.page.recordCount() - 1;
        if (n3 < BTree.maxRowsPerPage) {
            if (leafControlRow.page.insertAtSlot(n2, dataValueDescriptorArray, null, this.btree_undo, (byte)1, 50) != null) {
                bl = true;
            } else if (leafControlRow.page.recordCount() <= 2) {
                throw StandardException.newException("XSCB6.S", new Object[0]);
            }
        }
        return bl;
    }

    private LeafControlRow do_load_split(DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow) throws StandardException {
        LeafControlRow leafControlRow2 = null;
        BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow(dataValueDescriptorArray, leafControlRow.page.getPageNumber());
        long l2 = leafControlRow.page.getPageNumber();
        leafControlRow.release();
        leafControlRow = null;
        long l3 = this.start_xact_and_dosplit(false, l2, this.scratch_template, branchRow.getRow(), 3);
        leafControlRow2 = (LeafControlRow)ControlRow.get(this, l3);
        return leafControlRow2;
    }

    public void init(TransactionManager transactionManager, boolean bl, ContainerHandle containerHandle, Transaction transaction, int n2, int n3, BTreeLockingPolicy bTreeLockingPolicy, BTree bTree, LogicalUndo logicalUndo, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, DynamicCompiledOpenConglomInfo dynamicCompiledOpenConglomInfo) throws StandardException {
        this.get_insert_row_lock = (n2 & 0x4000) == 0;
        super.init(transactionManager, transactionManager, containerHandle, transaction, bl, n2, n3, bTreeLockingPolicy, bTree, logicalUndo, dynamicCompiledOpenConglomInfo);
    }

    @Override
    public void close() throws StandardException {
        super.close();
        if (this.getXactMgr() != null) {
            this.getXactMgr().closeMe(this);
        }
    }

    @Override
    public boolean closeForEndTransaction(boolean bl) throws StandardException {
        super.close();
        if (!this.getHold() || bl) {
            if (this.getXactMgr() != null) {
                this.getXactMgr().closeMe(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public int insert(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.isClosed()) {
            if (this.getHold()) {
                this.reopen();
            } else {
                throw StandardException.newException("XSCB8.S", this.err_containerid);
            }
        }
        return this.doIns(dataValueDescriptorArray);
    }

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public void getTableProperties(Properties properties) throws StandardException {
        if (this.container == null) {
            throw StandardException.newException("XSCB8.S", this.err_containerid);
        }
        this.container.getContainerProperties(properties);
    }

    @Override
    public Properties getInternalTablePropertySet(Properties properties) throws StandardException {
        Properties properties2 = ConglomerateUtil.createRawStorePropertySet(properties);
        this.getTableProperties(properties2);
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long load(TransactionManager transactionManager, boolean bl, RowLocationRetRowSource rowLocationRetRowSource) throws StandardException {
        long l2 = 0L;
        if (this.scratch_template == null) {
            this.scratch_template = this.runtime_mem.get_template(this.getRawTran());
        }
        LeafControlRow leafControlRow = null;
        try {
            DataValueDescriptor[] dataValueDescriptorArray;
            leafControlRow = (LeafControlRow)ControlRow.get(this, 1L);
            int n2 = 1;
            FormatableBitSet formatableBitSet = rowLocationRetRowSource.getValidColumns();
            while ((dataValueDescriptorArray = rowLocationRetRowSource.getNextRowFromRowSource()) != null) {
                ++l2;
                while (!this.do_load_insert(dataValueDescriptorArray, leafControlRow, n2)) {
                    leafControlRow = this.do_load_split(dataValueDescriptorArray, leafControlRow);
                    n2 = leafControlRow.page.recordCount();
                }
                ++n2;
            }
            leafControlRow.release();
            leafControlRow = null;
            if (!this.getConglomerate().isTemporary()) {
                this.container.flushContainer();
            }
        }
        finally {
            this.close();
        }
        return l2;
    }

    @Override
    public boolean delete(RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean fetch(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, boolean bl) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void insertAndFetchLocation(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean lockRow(RowLocation rowLocation, int n2, boolean bl, int n3) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean lockRow(long l2, int n2, int n3, boolean bl, int n4) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public void unlockRowAfterRead(RowLocation rowLocation, boolean bl, boolean bl2) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean replace(RowLocation rowLocation, DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }
}

