/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class BranchControlRow
extends ControlRow {
    protected SQLLongint left_child_page = null;
    transient SQLLongint child_pageno_buf = null;
    private static final int CR_LEFTCHILD = 7;
    private static final int CR_COLID_LAST = 7;
    private static final int CR_NCOLUMNS = 8;
    protected static final FormatableBitSet CR_LEFTCHILD_BITMAP = new FormatableBitSet(8);

    public BranchControlRow() {
    }

    public BranchControlRow(OpenBTree openBTree, Page page, int n2, ControlRow controlRow, boolean bl, long l2) throws StandardException {
        super(openBTree, page, n2, controlRow, bl);
        this.left_child_page = new SQLLongint(l2);
        this.row[7] = this.left_child_page;
        this.child_pageno_buf = new SQLLongint();
    }

    @Override
    protected final void controlRowInit() {
        this.child_pageno_buf = new SQLLongint();
    }

    @Override
    public boolean isLeftmostLeaf() throws StandardException {
        return false;
    }

    @Override
    public boolean isRightmostLeaf() throws StandardException {
        return false;
    }

    @Override
    protected final int getNumberOfControlRowColumns() {
        return 8;
    }

    public static long restartSplitFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, BranchControlRow branchControlRow, ControlRow controlRow, DataValueDescriptor[] dataValueDescriptorArray2, DataValueDescriptor[] dataValueDescriptorArray3, int n2) throws StandardException {
        branchControlRow.release();
        controlRow.release();
        branchControlRow = null;
        controlRow = null;
        ControlRow controlRow2 = ControlRow.get(openBTree, 1L);
        return controlRow2.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControlRow search(SearchParameters searchParameters) throws StandardException {
        ControlRow controlRow = null;
        boolean bl = true;
        try {
            this.searchForEntry(searchParameters);
            if (searchParameters.searchForOptimizer) {
                float f2 = searchParameters.resultSlot;
                int n2 = this.page.recordCount();
                if (this.getIsRoot()) {
                    searchParameters.current_fraction = 1.0f;
                    searchParameters.left_fraction = 0.0f;
                }
                searchParameters.left_fraction += searchParameters.current_fraction * (f2 / (float)n2);
                searchParameters.current_fraction *= 1.0f / (float)n2;
            }
            controlRow = this.getChildPageAtSlot(searchParameters.btree, searchParameters.resultSlot);
            this.release();
            bl = false;
            ControlRow controlRow2 = controlRow.search(searchParameters);
            return controlRow2;
        }
        finally {
            if (bl) {
                if (controlRow != null) {
                    controlRow.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ControlRow searchLeft(OpenBTree openBTree) throws StandardException {
        ControlRow controlRow = null;
        boolean bl = true;
        try {
            controlRow = this.getLeftChild(openBTree);
            this.release();
            bl = false;
            ControlRow controlRow2 = controlRow.searchLeft(openBTree);
            return controlRow2;
        }
        finally {
            if (bl) {
                if (controlRow != null) {
                    controlRow.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ControlRow searchRight(OpenBTree openBTree) throws StandardException {
        ControlRow controlRow = null;
        boolean bl = true;
        try {
            controlRow = this.getRightChild(openBTree);
            this.release();
            bl = false;
            ControlRow controlRow2 = controlRow.searchRight(openBTree);
            return controlRow2;
        }
        finally {
            if (bl) {
                if (controlRow != null) {
                    controlRow.release();
                }
                if (this.page.isLatched()) {
                    this.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shrinkFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        ControlRow controlRow = null;
        boolean bl = false;
        try {
            BranchRow branchRow = BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate());
            SearchParameters searchParameters = new SearchParameters(dataValueDescriptorArray, 1, branchRow.getRow(), openBTree, false);
            this.searchForEntry(searchParameters);
            controlRow = this.getChildPageAtSlot(searchParameters.btree, searchParameters.resultSlot);
            if (controlRow.shrinkFor(openBTree, dataValueDescriptorArray)) {
                if (searchParameters.resultSlot != 0) {
                    this.page.purgeAtSlot(searchParameters.resultSlot, 1, true);
                } else if (this.page.recordCount() > 1) {
                    long l2 = this.getChildPageIdAtSlot(openBTree, 1);
                    this.setLeftChildPageno(l2);
                    this.page.purgeAtSlot(1, 1, true);
                } else if (this.getIsRoot()) {
                    LeafControlRow leafControlRow = new LeafControlRow(openBTree, this.page, null, true);
                    leafControlRow.page.updateAtSlot(0, leafControlRow.getRow(), null);
                    leafControlRow.release();
                    bl = true;
                } else if (this.unlink(openBTree)) {
                    bl = true;
                }
            }
        }
        finally {
            if (!bl) {
                this.release();
            }
        }
        return bl;
    }

    @Override
    protected long splitFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, BranchControlRow branchControlRow, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        if (this.page.recordCount() - 1 >= BTree.maxRowsPerPage || !this.page.spaceForInsert(dataValueDescriptorArray2, null, 50)) {
            BranchControlRow branchControlRow2;
            if (this.page.recordCount() == 1) {
                throw StandardException.newException("XSCB6.S", new Object[0]);
            }
            if (this.getIsRoot()) {
                BranchControlRow.growRoot(openBTree, dataValueDescriptorArray, this);
                branchControlRow = (BranchControlRow)ControlRow.get(openBTree, 1L);
                return branchControlRow.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n2);
            }
            int n3 = (this.page.recordCount() - 1) / 2 + 1;
            if ((n2 & 4) != 0) {
                n3 = 1;
            } else if ((n2 & 1) != 0) {
                n3 = this.page.recordCount() - 1;
            }
            BranchRow branchRow = BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate());
            this.page.fetchFromSlot(null, n3, branchRow.getRow(), null, true);
            BranchRow branchRow2 = branchRow.createBranchRowFromOldBranchRow(-1L);
            if (!branchControlRow.page.spaceForInsert(branchRow2.getRow(), null, 50)) {
                return BranchControlRow.restartSplitFor(openBTree, dataValueDescriptorArray, branchControlRow, this, branchRow2.getRow(), dataValueDescriptorArray2, n2);
            }
            ControlRow controlRow = this.getChildPageAtSlot(openBTree, n3);
            BranchControlRow branchControlRow3 = BranchControlRow.allocate(openBTree, controlRow, this.getLevel(), branchControlRow);
            branchControlRow3.linkRight(openBTree, this);
            controlRow.release();
            branchRow2.setPageNumber(branchControlRow3.page.getPageNumber());
            BranchRow branchRow3 = BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate());
            SearchParameters searchParameters = new SearchParameters(branchRow2.getRow(), 1, branchRow3.getRow(), openBTree, false);
            branchControlRow.searchForEntry(searchParameters);
            byte by = 0;
            by = (byte)(by | 1);
            by = (byte)(by | 2);
            if (branchControlRow.page.insertAtSlot(searchParameters.resultSlot + 1, branchRow2.getRow(), null, null, by, 50) == null) {
                throw StandardException.newException("XSCB6.S", new Object[0]);
            }
            branchRow2 = null;
            int n4 = this.page.recordCount() - (n3 + 1);
            if (n4 > 0) {
                this.page.copyAndPurge(branchControlRow3.page, n3 + 1, n4, 1);
            }
            this.page.purgeAtSlot(n3, 1, true);
            branchControlRow3.fixChildrensParents(openBTree, null);
            openBTree.getXactMgr().commit();
            if (BranchControlRow.compareIndexRowToKey(dataValueDescriptorArray2, branchRow.getRow(), branchRow.getRow().length - 1, 0, openBTree.getConglomerate().ascDescInfo) >= 0) {
                branchControlRow2 = branchControlRow3;
                this.release();
            } else {
                branchControlRow2 = this;
                branchControlRow3.release();
            }
            return branchControlRow2.splitFor(openBTree, dataValueDescriptorArray, branchControlRow, dataValueDescriptorArray2, n2);
        }
        if (branchControlRow != null) {
            branchControlRow.release();
        }
        BranchRow branchRow = BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate());
        SearchParameters searchParameters = new SearchParameters(dataValueDescriptorArray2, 1, branchRow.getRow(), openBTree, false);
        this.searchForEntry(searchParameters);
        ControlRow controlRow = this.getChildPageAtSlot(openBTree, searchParameters.resultSlot);
        return controlRow.splitFor(openBTree, dataValueDescriptorArray, this, dataValueDescriptorArray2, n2);
    }

    @Override
    public int checkConsistency(OpenBTree openBTree, ControlRow controlRow, boolean bl) throws StandardException {
        this.checkGeneric(openBTree, controlRow, bl);
        if (bl) {
            this.checkChildOrderAgainstRowOrder(openBTree);
        }
        int n2 = 0;
        if (bl) {
            n2 = this.checkChildren(openBTree);
        }
        return n2 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkChildren(OpenBTree openBTree) throws StandardException {
        int n2 = 0;
        ControlRow controlRow = null;
        try {
            int n3;
            controlRow = this.getLeftChild(openBTree);
            n2 += controlRow.checkConsistency(openBTree, this, true);
            controlRow.release();
            controlRow = null;
            int n4 = this.page.recordCount();
            for (n3 = 1; n3 < n4; ++n3) {
                controlRow = this.getChildPageAtSlot(openBTree, n3);
                n2 += controlRow.checkConsistency(openBTree, this, true);
                controlRow.release();
                controlRow = null;
            }
            n3 = n2;
            return n3;
        }
        finally {
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChildOrderAgainstRowOrder(OpenBTree openBTree) throws StandardException {
        ControlRow controlRow = null;
        ControlRow controlRow2 = null;
        try {
            controlRow2 = this.getLeftChild(openBTree);
            int n2 = this.page.recordCount();
            for (int i2 = 1; i2 < n2; ++i2) {
                controlRow = this.getChildPageAtSlot(openBTree, i2);
                long l2 = controlRow2.getrightSiblingPageNumber();
                long l3 = controlRow.getleftSiblingPageNumber();
                controlRow2.release();
                controlRow2 = controlRow;
                controlRow = null;
            }
            controlRow2.release();
            controlRow2 = null;
        }
        finally {
            if (controlRow2 != null) {
                controlRow2.release();
            }
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    @Override
    public void printTree(OpenBTree openBTree) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void growRoot(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, BranchControlRow branchControlRow) throws StandardException {
        ControlRow controlRow = null;
        ControlRow controlRow2 = null;
        try {
            controlRow = branchControlRow.getLeftChild(openBTree);
            controlRow2 = BranchControlRow.allocate(openBTree, controlRow, branchControlRow.getLevel(), branchControlRow);
            branchControlRow.page.copyAndPurge(((BranchControlRow)controlRow2).page, 1, branchControlRow.page.recordCount() - 1, 1);
            branchControlRow.setLeftChild(controlRow2);
            branchControlRow.setLevel(branchControlRow.getLevel() + 1);
            super.fixChildrensParents(openBTree, controlRow);
            openBTree.getXactMgr().commit();
        }
        finally {
            branchControlRow.release();
            if (controlRow2 != null) {
                controlRow2.release();
            }
            if (controlRow != null) {
                controlRow.release();
            }
        }
    }

    private static BranchControlRow allocate(OpenBTree openBTree, ControlRow controlRow, int n2, ControlRow controlRow2) throws StandardException {
        Page page = openBTree.container.addPage();
        BranchControlRow branchControlRow = new BranchControlRow(openBTree, page, n2, controlRow2, false, controlRow.page.getPageNumber());
        byte by = 0;
        by = (byte)(by | 1);
        page.insertAtSlot(0, branchControlRow.getRow(), null, null, by, 50);
        return branchControlRow;
    }

    protected void setLeftChildPageno(long l2) throws StandardException {
        if (this.left_child_page == null) {
            this.left_child_page = new SQLLongint(l2);
        } else {
            this.left_child_page.setValue(l2);
        }
        this.page.updateFieldAtSlot(0, 7, this.left_child_page, null);
    }

    protected void setLeftChild(ControlRow controlRow) throws StandardException {
        this.setLeftChildPageno(controlRow.page.getPageNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixChildrensParents(OpenBTree openBTree, ControlRow controlRow) throws StandardException {
        ControlRow controlRow2 = null;
        try {
            if (controlRow == null) {
                controlRow2 = this.getLeftChild(openBTree);
                controlRow2.setParent(this.page.getPageNumber());
                controlRow2.release();
                controlRow2 = null;
            } else {
                controlRow.setParent(this.page.getPageNumber());
            }
            int n2 = this.page.recordCount();
            for (int i2 = 1; i2 < n2; ++i2) {
                controlRow2 = this.getChildPageAtSlot(openBTree, i2);
                controlRow2.setParent(this.page.getPageNumber());
                controlRow2.release();
                controlRow2 = null;
            }
        }
        finally {
            if (controlRow2 != null) {
                controlRow2.release();
            }
        }
    }

    private long getChildPageIdAtSlot(OpenBTree openBTree, int n2) throws StandardException {
        long l2;
        if (n2 == 0) {
            l2 = this.getLeftChildPageno();
        } else {
            this.page.fetchFieldFromSlot(n2, openBTree.getConglomerate().nKeyFields, this.child_pageno_buf);
            l2 = this.child_pageno_buf.getLong();
        }
        return l2;
    }

    protected ControlRow getChildPageAtSlot(OpenBTree openBTree, int n2) throws StandardException {
        ControlRow controlRow;
        if (n2 == 0) {
            controlRow = this.getLeftChild(openBTree);
        } else {
            this.page.fetchFieldFromSlot(n2, openBTree.getConglomerate().nKeyFields, this.child_pageno_buf);
            controlRow = ControlRow.get(openBTree, this.child_pageno_buf.getLong());
        }
        return controlRow;
    }

    @Override
    public ControlRow getLeftChild(OpenBTree openBTree) throws StandardException {
        return ControlRow.get(openBTree, this.getLeftChildPageno());
    }

    @Override
    protected ControlRow getRightChild(OpenBTree openBTree) throws StandardException {
        int n2 = this.page.recordCount();
        ControlRow controlRow = n2 == 1 ? ControlRow.get(openBTree, this.getLeftChildPageno()) : this.getChildPageAtSlot(openBTree, n2 - 1);
        return controlRow;
    }

    long getLeftChildPageno() throws StandardException {
        if (this.left_child_page == null) {
            this.left_child_page = new SQLLongint();
            this.scratch_row[7] = this.left_child_page;
            this.fetchDesc.setValidColumns(CR_LEFTCHILD_BITMAP);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.left_child_page.getLong();
    }

    @Override
    public int getTypeFormatId() {
        return 134;
    }

    @Override
    public DataValueDescriptor[] getRowTemplate(OpenBTree openBTree) throws StandardException {
        return BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate()).getRow();
    }

    @Override
    public String toString() {
        return null;
    }

    static {
        CR_LEFTCHILD_BITMAP.set(7);
    }
}

