/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.conglomerate.Conglomerate;
import org.apache.derby.iapi.store.access.conglomerate.ConglomerateFactory;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.Heap_v10_2;

public class HeapConglomerateFactory
implements ConglomerateFactory,
ModuleControl,
ModuleSupportable {
    private static final String IMPLEMENTATIONID = "heap";
    private static final String FORMATUUIDSTRING = "D2976090-D9F5-11d0-B54D-00A024BF8878";
    private UUID formatUUID;

    @Override
    public Properties defaultProperties() {
        return new Properties();
    }

    @Override
    public boolean supportsImplementation(String string) {
        return string.equals(IMPLEMENTATIONID);
    }

    @Override
    public String primaryImplementationType() {
        return IMPLEMENTATIONID;
    }

    @Override
    public boolean supportsFormat(UUID uUID) {
        return uUID.equals(this.formatUUID);
    }

    @Override
    public UUID primaryFormat() {
        return this.formatUUID;
    }

    @Override
    public int getConglomerateFactoryId() {
        return 0;
    }

    @Override
    public Conglomerate createConglomerate(TransactionManager transactionManager, int n2, long l2, DataValueDescriptor[] dataValueDescriptorArray, ColumnOrdering[] columnOrderingArray, int[] nArray, Properties properties, int n3) throws StandardException {
        Heap heap = null;
        heap = (n3 & 1) != 0 && transactionManager.getAccessManager().isReadOnly() ? new Heap() : (transactionManager.checkVersion(10, 3, null) ? new Heap() : new Heap_v10_2());
        heap.create(transactionManager.getRawStoreXact(), n2, l2, dataValueDescriptorArray, columnOrderingArray, nArray, properties, heap.getTypeFormatId(), n3);
        return heap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Conglomerate readConglomerate(TransactionManager transactionManager, ContainerKey containerKey) throws StandardException {
        ContainerHandle containerHandle = null;
        Page page = null;
        Object[] objectArray = new DataValueDescriptor[1];
        try {
            containerHandle = transactionManager.getRawStoreXact().openContainer(containerKey, null, 0);
            if (containerHandle == null) {
                throw StandardException.newException("XSAI2.S", containerKey.getContainerId());
            }
            objectArray[0] = new Heap();
            page = containerHandle.getPage(1L);
            RecordHandle recordHandle = page.fetchFromSlot(null, 0, objectArray, null, true);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            if (containerHandle != null) {
                containerHandle.close();
            }
        }
        return (Conglomerate)objectArray[0];
    }

    @Override
    public void insertUndoNotify(AccessFactory accessFactory, Transaction transaction, PageKey pageKey) throws StandardException {
        transaction.addPostAbortWork(new HeapPostCommit(accessFactory, pageKey));
    }

    @Override
    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("derby.access.Conglomerate.type");
        if (string == null) {
            return false;
        }
        return this.supportsImplementation(string);
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        UUIDFactory uUIDFactory = HeapConglomerateFactory.getMonitor().getUUIDFactory();
        this.formatUUID = uUIDFactory.recreateUUID(FORMATUUIDSTRING);
    }

    @Override
    public void stop() {
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

