/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.DerbyObservable;
import org.apache.derby.iapi.services.monitor.DerbyObserver;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.RecordId;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;

abstract class BasePage
implements Page,
DerbyObserver,
TypedFormat {
    private AuxObject auxObj;
    protected PageKey identity;
    private StoredRecordHeader[] headers;
    private int recordCount;
    protected BaseContainerHandle owner;
    private int nestedLatch;
    protected boolean inClean;
    protected boolean preLatch;
    private LogInstant lastLog;
    private long repositionNeededAfterVersion;
    private long pageVersion = 0L;
    private byte pageStatus;
    public static final byte VALID_PAGE = 1;
    public static final byte INVALID_PAGE = 2;
    public static final int INIT_PAGE_REUSE = 1;
    public static final int INIT_PAGE_OVERFLOW = 2;
    public static final int INIT_PAGE_REUSE_RECORDID = 4;
    public static final int LOG_RECORD_DEFAULT = 0;
    public static final int LOG_RECORD_FOR_UPDATE = 1;
    public static final int LOG_RECORD_FOR_PURGE = 2;
    private static final RecordHandle InvalidRecordHandle = new RecordId(new PageKey(new ContainerKey(0L, 0L), -1L), 0);

    protected BasePage() {
    }

    protected void initialize() {
        this.setAuxObject(null);
        this.identity = null;
        this.recordCount = 0;
        this.clearLastLogInstant();
        this.repositionNeededAfterVersion = 0L;
    }

    protected void initializeHeaders(int n2) {
        this.headers = new StoredRecordHeader[n2];
    }

    protected void fillInIdentity(PageKey pageKey) {
        this.identity = pageKey;
        this.repositionNeededAfterVersion = this.pageVersion;
    }

    public void clearIdentity() {
        this.identity = null;
        this.cleanPageForReuse();
    }

    protected void cleanPageForReuse() {
        this.setAuxObject(null);
        this.recordCount = 0;
        this.repositionNeededAfterVersion = 0L;
    }

    public Object getIdentity() {
        return this.identity;
    }

    @Override
    public final RecordHandle getInvalidRecordHandle() {
        return InvalidRecordHandle;
    }

    public static final RecordHandle MakeRecordHandle(PageKey pageKey, int n2) throws StandardException {
        if (n2 >= 6) {
            throw StandardException.newException("XSDAE.S", n2);
        }
        return new RecordId(pageKey, n2);
    }

    @Override
    public final RecordHandle makeRecordHandle(int n2) throws StandardException {
        return BasePage.MakeRecordHandle(this.getPageId(), n2);
    }

    @Override
    public final long getPageNumber() {
        return this.identity.getPageNumber();
    }

    @Override
    public final PageKey getPageKey() {
        return this.identity;
    }

    @Override
    public final RecordHandle getRecordHandle(int n2) {
        int n3 = this.findRecordById(n2, 0);
        if (n3 < 0) {
            return null;
        }
        return this.getRecordHandleAtSlot(n3);
    }

    @Override
    public final RecordHandle getRecordHandleAtSlot(int n2) {
        return this.getHeaderAtSlot(n2).getHandle(this.getPageId(), n2);
    }

    @Override
    public final boolean recordExists(RecordHandle recordHandle, boolean bl) throws StandardException {
        if (recordHandle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", recordHandle);
        }
        if (recordHandle.getPageNumber() != this.getPageNumber()) {
            return false;
        }
        int n2 = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        return n2 >= 0 && (bl || !this.isDeletedAtSlot(n2));
    }

    @Override
    public RecordHandle fetchFromSlot(RecordHandle recordHandle, int n2, Object[] objectArray, FetchDescriptor fetchDescriptor, boolean bl) throws StandardException {
        this.checkSlotOnPage(n2);
        StoredRecordHeader storedRecordHeader = this.getHeaderAtSlot(n2);
        if (recordHandle == null) {
            recordHandle = storedRecordHeader.getHandle(this.getPageId(), n2);
        }
        if (!bl && storedRecordHeader.isDeleted()) {
            return null;
        }
        return this.restoreRecordFromSlot(n2, objectArray, fetchDescriptor, recordHandle, storedRecordHeader, true) ? recordHandle : null;
    }

    @Override
    public final RecordHandle fetchFieldFromSlot(int n2, int n3, Object object) throws StandardException {
        Object[] objectArray = new Object[n3 + 1];
        objectArray[n3] = object;
        FetchDescriptor fetchDescriptor = new FetchDescriptor(n3 + 1, n3);
        return this.fetchFromSlot(null, n2, objectArray, fetchDescriptor, true);
    }

    @Override
    public final int getSlotNumber(RecordHandle recordHandle) throws StandardException {
        int n2 = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n2 < 0) {
            throw StandardException.newException("XSRS9.S", recordHandle);
        }
        return n2;
    }

    @Override
    public final int getNextSlotNumber(RecordHandle recordHandle) throws StandardException {
        int n2 = this.findNextRecordById(recordHandle.getId());
        return n2;
    }

    @Override
    public RecordHandle insertAtSlot(int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3) throws StandardException {
        if ((by & 1) == 1) {
            return this.insertNoOverflow(n2, objectArray, formatableBitSet, logicalUndo, by, n3);
        }
        return this.insertAllowOverflow(n2, objectArray, formatableBitSet, 0, by, n3, null);
    }

    protected RecordHandle insertNoOverflow(int n2, Object[] objectArray, FormatableBitSet formatableBitSet, LogicalUndo logicalUndo, byte by, int n3) throws StandardException {
        int n4;
        RecordId recordId;
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (n2 < 0 || n2 > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        if (!this.allowInsert()) {
            return null;
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        if (logicalUndo != null) {
            rawTransaction.checkLogicalOperationOk();
        }
        do {
            n4 = this.newRecordIdAndBump();
            recordId = new RecordId(this.getPageId(), n4, n2);
        } while (!this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId, true, false));
        this.owner.getActionSet().actionInsert(rawTransaction, this, n2, n4, objectArray, formatableBitSet, logicalUndo, by, 0, false, -1, null, -1, n3);
        return recordId;
    }

    @Override
    public final RecordHandle insert(Object[] objectArray, FormatableBitSet formatableBitSet, byte by, int n2) throws StandardException {
        if ((by & 1) == 1) {
            return this.insertAtSlot(this.recordCount, objectArray, formatableBitSet, null, by, n2);
        }
        return this.insertAllowOverflow(this.recordCount, objectArray, formatableBitSet, 0, by, n2, null);
    }

    public RecordHandle insertAllowOverflow(int n2, Object[] objectArray, FormatableBitSet formatableBitSet, int n3, byte by, int n4, RecordHandle recordHandle) throws StandardException {
        BasePage basePage = this;
        if (!basePage.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RecordId recordId = null;
        RecordId recordId2 = null;
        RawTransaction rawTransaction = basePage.owner.getTransaction();
        while (basePage.allowInsert()) {
            if (basePage != this) {
                n2 = basePage.recordCount;
            }
            boolean bl = false;
            int n5 = -1;
            int n6 = -1;
            DynamicByteArrayOutputStream dynamicByteArrayOutputStream = null;
            int n7 = basePage.newRecordIdAndBump();
            RecordId recordId3 = new RecordId(basePage.getPageId(), n7, n2);
            if (basePage == this) {
                if (recordId2 == null) {
                    while (!this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId3, true, false)) {
                        n7 = basePage.newRecordIdAndBump();
                        recordId3 = new RecordId(basePage.getPageId(), n7, n2);
                    }
                }
                recordId = recordId3;
            }
            do {
                try {
                    n3 = this.owner.getActionSet().actionInsert(rawTransaction, basePage, n2, n7, objectArray, formatableBitSet, null, by, n3, false, n5, dynamicByteArrayOutputStream, n6, n4);
                    bl = false;
                }
                catch (LongColumnException longColumnException) {
                    dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream(longColumnException.getLogBuffer());
                    RecordHandle recordHandle2 = this.insertLongColumn(basePage, longColumnException, by);
                    int n8 = 0;
                    try {
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                    n5 = longColumnException.getNextColumn() + 1;
                    n6 = longColumnException.getRealSpaceOnPage() - (n8 += this.appendOverflowFieldHeader(dynamicByteArrayOutputStream, recordHandle2));
                    bl = true;
                }
            } while (bl);
            if (recordId2 != null) {
                this.updateOverflowDetails(recordId2, recordId3);
            }
            if (n3 == -1) {
                if (basePage != this) {
                    basePage.unlatch();
                }
                if (recordHandle != null) {
                    this.updateOverflowDetails(recordId3, recordHandle);
                }
                return recordId;
            }
            recordId2 = recordId3;
            BasePage basePage2 = basePage.getOverflowPageForInsert(n2, objectArray, formatableBitSet, n3);
            if (basePage != this) {
                basePage.unlatch();
            }
            basePage = basePage2;
        }
        return null;
    }

    protected RecordHandle insertLongColumn(BasePage basePage, LongColumnException longColumnException, byte by) throws StandardException {
        Object[] objectArray = new Object[]{longColumnException.getColumn()};
        RecordId recordId = null;
        RecordId recordId2 = null;
        RecordId recordId3 = null;
        BasePage basePage2 = basePage;
        BasePage basePage3 = null;
        boolean bl = true;
        byte by2 = (byte)(by | 2);
        int n2 = 0;
        RawTransaction rawTransaction = basePage2.owner.getTransaction();
        do {
            if (!bl) {
                basePage3 = basePage2;
                recordId3 = recordId2;
            }
            basePage2 = this.getNewOverflowPage();
            int n3 = basePage2.recordCount;
            int n4 = basePage2.newRecordId();
            recordId2 = new RecordId(basePage2.getPageId(), n4, n3);
            if (bl) {
                recordId = recordId2;
            }
            n2 = this.owner.getActionSet().actionInsert(rawTransaction, basePage2, n3, n4, objectArray, null, null, bl ? by : by2, n2, true, -1, null, -1, 100);
            if (!bl) {
                basePage3.updateFieldOverflowDetails(recordId3, recordId2);
                basePage3.unlatch();
                basePage3 = null;
                continue;
            }
            bl = false;
        } while (n2 != -1);
        if (basePage2 != null) {
            basePage2.unlatch();
            basePage2 = null;
        }
        return recordId;
    }

    public abstract void preDirty();

    public abstract void updateOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract void updateFieldOverflowDetails(RecordHandle var1, RecordHandle var2) throws StandardException;

    public abstract int appendOverflowFieldHeader(DynamicByteArrayOutputStream var1, RecordHandle var2) throws StandardException, IOException;

    public abstract BasePage getOverflowPageForInsert(int var1, Object[] var2, FormatableBitSet var3, int var4) throws StandardException;

    protected abstract BasePage getNewOverflowPage() throws StandardException;

    @Override
    public final RecordHandle updateAtSlot(int n2, Object[] objectArray, FormatableBitSet formatableBitSet) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (this.isDeletedAtSlot(n2)) {
            throw StandardException.newException("XSDA2.S", new Object[0]);
        }
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n2);
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.doUpdateAtSlot(rawTransaction, n2, recordHandle.getId(), objectArray, formatableBitSet);
        return recordHandle;
    }

    public abstract void doUpdateAtSlot(RawTransaction var1, int var2, int var3, Object[] var4, FormatableBitSet var5) throws StandardException;

    @Override
    public RecordHandle updateFieldAtSlot(int n2, int n3, Object object, LogicalUndo logicalUndo) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (this.isDeletedAtSlot(n2)) {
            throw StandardException.newException("XSDA2.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n2);
        this.owner.getActionSet().actionUpdateField(rawTransaction, this, n2, recordHandle.getId(), n3, object, logicalUndo);
        return recordHandle;
    }

    @Override
    public final int fetchNumFields(RecordHandle recordHandle) throws StandardException {
        return this.fetchNumFieldsAtSlot(this.getSlotNumber(recordHandle));
    }

    @Override
    public int fetchNumFieldsAtSlot(int n2) throws StandardException {
        return this.getHeaderAtSlot(n2).getNumberFields();
    }

    @Override
    public RecordHandle deleteAtSlot(int n2, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (bl) {
            if (this.isDeletedAtSlot(n2)) {
                throw StandardException.newException("XSDA2.S", new Object[0]);
            }
        } else if (!this.isDeletedAtSlot(n2)) {
            throw StandardException.newException("XSDA5.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        if (logicalUndo != null) {
            rawTransaction.checkLogicalOperationOk();
        }
        RecordHandle recordHandle = this.getRecordHandleAtSlot(n2);
        this.owner.getActionSet().actionDelete(rawTransaction, this, n2, recordHandle.getId(), bl, logicalUndo);
        return recordHandle;
    }

    @Override
    public void purgeAtSlot(int n2, int n3, boolean bl) throws StandardException {
        if (n3 <= 0) {
            return;
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (n2 < 0 || n2 + n3 > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[n3];
        PageKey pageKey = this.getPageId();
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.getHeaderAtSlot(n2 + i2).getId();
            RecordHandle recordHandle = this.getRecordHandleAtSlot(n2);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordHandle, false, true);
            if (this.owner.isTemporaryContainer() || this.entireRecordOnPage(n2 + i2)) continue;
            RecordHandle recordHandle2 = this.getHeaderAtSlot(n2 + i2).getHandle(pageKey, n2 + i2);
            this.purgeRowPieces(rawTransaction, n2 + i2, recordHandle2, bl);
        }
        this.owner.getActionSet().actionPurge(rawTransaction, this, n2, n3, nArray, bl);
    }

    protected abstract void purgeRowPieces(RawTransaction var1, int var2, RecordHandle var3, boolean var4) throws StandardException;

    @Override
    public void copyAndPurge(Page page, int n2, int n3, int n4) throws StandardException {
        if (n3 <= 0) {
            throw StandardException.newException("XSDAD.S", new Object[0]);
        }
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (n2 < 0 || n2 + n3 > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        BasePage basePage = (BasePage)page;
        PageKey pageKey = this.getPageId();
        if (!pageKey.getContainerId().equals(basePage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", pageKey.getContainerId(), basePage.getPageId().getContainerId());
        }
        int[] nArray = new int[n3];
        RawTransaction rawTransaction = this.owner.getTransaction();
        for (int i2 = 0; i2 < n3; ++i2) {
            RecordHandle recordHandle = this.getRecordHandleAtSlot(n2 + i2);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordHandle, false, true);
            nArray[i2] = this.getHeaderAtSlot(n2 + i2).getId();
        }
        basePage.copyInto(this, n2, n3, n4);
        this.owner.getActionSet().actionPurge(rawTransaction, this, n2, n3, nArray, true);
    }

    @Override
    public void unlatch() {
        this.releaseExclusive();
    }

    @Override
    public final synchronized boolean isLatched() {
        return this.owner != null;
    }

    @Override
    public final int recordCount() {
        return this.recordCount;
    }

    protected abstract int internalDeletedRecordCount();

    protected int internalNonDeletedRecordCount() {
        if (this.pageStatus != 1) {
            return 0;
        }
        int n2 = this.internalDeletedRecordCount();
        if (n2 == -1) {
            int n3 = 0;
            int n4 = this.recordCount;
            for (int i2 = 0; i2 < n4; ++i2) {
                if (this.isDeletedOnPage(i2)) continue;
                ++n3;
            }
            return n3;
        }
        return this.recordCount - n2;
    }

    @Override
    public int nonDeletedRecordCount() {
        return this.internalNonDeletedRecordCount();
    }

    @Override
    public boolean shouldReclaimSpace(int n2, int n3) throws StandardException {
        boolean bl = false;
        if (!this.isOverflowPage()) {
            if (this.internalNonDeletedRecordCount() <= n2) {
                bl = true;
            } else if (!this.entireRecordOnPage(n3)) {
                bl = true;
            }
        }
        return bl;
    }

    protected final boolean isDeletedOnPage(int n2) {
        return this.getHeaderAtSlot(n2).isDeleted();
    }

    @Override
    public boolean isDeletedAtSlot(int n2) throws StandardException {
        this.checkSlotOnPage(n2);
        return this.isDeletedOnPage(n2);
    }

    @Override
    public void setAuxObject(AuxObject auxObject) {
        if (this.auxObj != null) {
            this.auxObj.auxObjectInvalidated();
        }
        this.auxObj = auxObject;
    }

    @Override
    public AuxObject getAuxObject() {
        return this.auxObj;
    }

    @Override
    public void setRepositionNeeded() {
        this.repositionNeededAfterVersion = this.getPageVersion();
    }

    @Override
    public boolean isRepositionNeeded(long l2) {
        return this.repositionNeededAfterVersion > l2;
    }

    @Override
    public void update(DerbyObservable derbyObservable, Object object) {
        this.releaseExclusive();
    }

    public final PageKey getPageId() {
        return this.identity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExclusive(BaseContainerHandle baseContainerHandle) throws StandardException {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && rawTransaction == this.owner.getTransaction()) {
                if (rawTransaction.inAbort()) {
                    ++this.nestedLatch;
                    return;
                }
                throw StandardException.newException("XSDAO.S", this.identity);
            }
            while (this.owner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch(baseContainerHandle);
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setExclusiveNoWait(BaseContainerHandle baseContainerHandle) throws StandardException {
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        BasePage basePage = this;
        synchronized (basePage) {
            if (this.owner != null && rawTransaction == this.owner.getTransaction() && rawTransaction.inAbort()) {
                ++this.nestedLatch;
                return true;
            }
            if (this.owner == null) {
                this.preLatch(baseContainerHandle);
            } else {
                return false;
            }
            while (this.inClean) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            this.preLatch = false;
        }
        return true;
    }

    protected synchronized void releaseExclusive() {
        if (this.nestedLatch > 0) {
            --this.nestedLatch;
            return;
        }
        this.owner.deleteObserver(this);
        this.owner = null;
        this.notifyAll();
    }

    private void preLatch(BaseContainerHandle baseContainerHandle) {
        this.owner = baseContainerHandle;
        baseContainerHandle.addObserver(this);
        this.preLatch = true;
    }

    protected final void setHeaderAtSlot(int n2, StoredRecordHeader storedRecordHeader) {
        if (n2 < this.headers.length) {
            if (storedRecordHeader != null) {
                this.headers[n2] = storedRecordHeader;
            }
        } else {
            StoredRecordHeader[] storedRecordHeaderArray = new StoredRecordHeader[n2 + 1];
            System.arraycopy(this.headers, 0, storedRecordHeaderArray, 0, this.headers.length);
            this.headers = storedRecordHeaderArray;
            this.headers[n2] = storedRecordHeader;
        }
    }

    protected final void bumpRecordCount(int n2) {
        this.recordCount += n2;
    }

    public final StoredRecordHeader getHeaderAtSlot(int n2) {
        if (n2 < this.headers.length) {
            StoredRecordHeader storedRecordHeader = this.headers[n2];
            return storedRecordHeader != null ? storedRecordHeader : this.recordHeaderOnDemand(n2);
        }
        return this.recordHeaderOnDemand(n2);
    }

    public abstract boolean entireRecordOnPage(int var1) throws StandardException;

    public abstract StoredRecordHeader recordHeaderOnDemand(int var1);

    private final void checkSlotOnPage(int n2) throws StandardException {
        if (n2 >= 0 && n2 < this.recordCount) {
            return;
        }
        throw StandardException.newException("XSDA1.S", new Object[0]);
    }

    public int setDeleteStatus(int n2, boolean bl) throws StandardException, IOException {
        return this.getHeaderAtSlot(n2).setDeleted(bl);
    }

    public void deallocatePage() throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.owner.getActionSet().actionInvalidatePage(rawTransaction, this);
    }

    public void initPage(int n2, long l2) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        this.owner.getActionSet().actionInitPage(rawTransaction, this, n2, this.getTypeFormatId(), l2);
    }

    public int findRecordById(int n2, int n3) {
        if (n3 == 0) {
            n3 = n2 - 6;
        }
        int n4 = this.recordCount();
        if (n3 > 0 && n3 < n4 && n2 == this.getHeaderAtSlot(n3).getId()) {
            return n3;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (n2 != this.getHeaderAtSlot(i2).getId()) continue;
            return i2;
        }
        return -1;
    }

    private int findNextRecordById(int n2) {
        int n3 = this.recordCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.getHeaderAtSlot(i2).getId() <= n2) continue;
            return i2;
        }
        return -1;
    }

    private void copyInto(BasePage basePage, int n2, int n3, int n4) throws StandardException {
        if (n4 < 0 || n4 > this.recordCount) {
            throw StandardException.newException("XSDA1.S", new Object[0]);
        }
        RawTransaction rawTransaction = this.owner.getTransaction();
        int[] nArray = new int[n3];
        PageKey pageKey = this.getPageId();
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = i2 == 0 ? this.newRecordId() : this.newRecordId(nArray[i2 - 1]);
            RecordId recordId = new RecordId(pageKey, nArray[i2], i2);
            this.owner.getLockingPolicy().lockRecordForWrite(rawTransaction, recordId, false, true);
        }
        this.owner.getActionSet().actionCopyRows(rawTransaction, this, basePage, n4, n3, n2, nArray);
    }

    protected void removeAndShiftDown(int n2) {
        System.arraycopy(this.headers, n2 + 1, this.headers, n2, this.headers.length - (n2 + 1));
        this.headers[this.headers.length - 1] = null;
        --this.recordCount;
    }

    protected StoredRecordHeader shiftUp(int n2) {
        if (n2 < this.headers.length) {
            System.arraycopy(this.headers, n2, this.headers, n2 + 1, this.headers.length - (n2 + 1));
            this.headers[n2] = null;
        }
        return null;
    }

    public void compactRecord(RecordHandle recordHandle) throws StandardException {
        if (!this.owner.updateOK()) {
            throw StandardException.newException("40XD1", new Object[0]);
        }
        if (recordHandle.getId() < 6) {
            throw StandardException.newException("XSDAF.S", recordHandle);
        }
        if (recordHandle.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException("XSDAK.S", recordHandle);
        }
        if (this.isOverflowPage()) {
            throw StandardException.newException("XSDAL.S", recordHandle);
        }
        int n2 = this.findRecordById(recordHandle.getId(), recordHandle.getSlotNumberHint());
        if (n2 >= 0) {
            this.compactRecord(this.owner.getTransaction(), n2, recordHandle.getId());
        }
    }

    public final LogInstant getLastLogInstant() {
        return this.lastLog;
    }

    protected final void clearLastLogInstant() {
        this.lastLog = null;
    }

    protected final void updateLastLogInstant(LogInstant logInstant) {
        if (logInstant != null) {
            this.lastLog = logInstant;
        }
    }

    @Override
    public final long getPageVersion() {
        return this.pageVersion;
    }

    protected final long bumpPageVersion() {
        return ++this.pageVersion;
    }

    public final void setPageVersion(long l2) {
        this.pageVersion = l2;
    }

    protected void setPageStatus(byte by) {
        this.pageStatus = by;
    }

    public byte getPageStatus() {
        return this.pageStatus;
    }

    protected abstract boolean restoreRecordFromSlot(int var1, Object[] var2, FetchDescriptor var3, RecordHandle var4, StoredRecordHeader var5, boolean var6) throws StandardException;

    protected abstract void restorePortionLongColumn(OverflowInputStream var1) throws StandardException, IOException;

    public abstract int newRecordId() throws StandardException;

    public abstract int newRecordIdAndBump() throws StandardException;

    protected abstract int newRecordId(int var1) throws StandardException;

    public abstract boolean spaceForCopy(int var1, int[] var2) throws StandardException;

    public abstract int getTotalSpace(int var1) throws StandardException;

    public abstract int getReservedCount(int var1) throws IOException;

    public abstract int getRecordLength(int var1) throws IOException;

    public abstract void restoreRecordFromStream(LimitObjectInput var1, Object[] var2) throws StandardException, IOException;

    public abstract void logRecord(int var1, int var2, int var3, FormatableBitSet var4, OutputStream var5, RecordHandle var6) throws StandardException, IOException;

    public abstract int logRow(int var1, boolean var2, int var3, Object[] var4, FormatableBitSet var5, DynamicByteArrayOutputStream var6, int var7, byte var8, int var9, int var10, int var11) throws StandardException, IOException;

    public abstract void logField(int var1, int var2, OutputStream var3) throws StandardException, IOException;

    public abstract void logColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4, int var5) throws StandardException, IOException;

    public abstract int logLongColumn(int var1, int var2, Object var3, DynamicByteArrayOutputStream var4) throws StandardException, IOException;

    public abstract void storeRecord(LogInstant var1, int var2, boolean var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void storeField(LogInstant var1, int var2, int var3, ObjectInput var4) throws StandardException, IOException;

    public abstract void reserveSpaceForSlot(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract void skipField(ObjectInput var1) throws StandardException, IOException;

    public abstract void skipRecord(ObjectInput var1) throws StandardException, IOException;

    public abstract void setDeleteStatus(LogInstant var1, int var2, boolean var3) throws StandardException, IOException;

    public abstract void purgeRecord(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    protected abstract void compactRecord(RawTransaction var1, int var2, int var3) throws StandardException;

    public abstract void setPageStatus(LogInstant var1, byte var2) throws StandardException;

    public abstract void initPage(LogInstant var1, byte var2, int var3, boolean var4, boolean var5) throws StandardException;

    public abstract void setReservedSpace(LogInstant var1, int var2, int var3) throws StandardException, IOException;

    public abstract boolean isOverflowPage();

    public abstract boolean allowInsert();

    public abstract boolean unfilled();

    public abstract void setContainerRowCount(long var1);

    protected abstract byte[] getPageArray() throws StandardException;

    protected String slotTableToString() {
        String string = null;
        return string;
    }
}

