/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;

public final class DeleteOperation
extends LogicalPageOperation {
    protected int doMeSlot;
    protected boolean delete;
    protected transient ByteArray preparedLog;

    DeleteOperation(RawTransaction rawTransaction, BasePage basePage, int n2, int n3, boolean bl, LogicalUndo logicalUndo) throws StandardException {
        super(basePage, logicalUndo, n3);
        this.doMeSlot = n2;
        this.delete = bl;
        try {
            this.writeOptionalDataToBuffer(rawTransaction);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
    }

    public DeleteOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.doMeSlot);
        objectOutput.writeBoolean(this.delete);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.doMeSlot = CompressedNumber.readInt(objectInput);
        this.delete = objectInput.readBoolean();
    }

    @Override
    public int getTypeFormatId() {
        return 101;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.page.setDeleteStatus(logInstant, this.doMeSlot, this.delete);
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, int n2, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n3 = basePage.findRecordById(n2, 0);
        basePage.setDeleteStatus(logInstant, n3, !this.delete);
        basePage.setAuxObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreLoggedRow(Object[] objectArray, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        Page page = null;
        try {
            page = this.getContainer().getPage(this.getPageId().getPageNumber());
            ((BasePage)page).restoreRecordFromStream(limitObjectInput, objectArray);
        }
        finally {
            if (page != null) {
                page.unlatch();
                page = null;
            }
        }
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        int n2 = basePage.findRecordById(this.recordId, 0);
        basePage.setDeleteStatus(logInstant, n2, !this.delete);
        basePage.setAuxObject(null);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction) throws StandardException, IOException {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n2 = dynamicByteArrayOutputStream.getPosition();
        if (this.undo != null) {
            this.page.logRecord(this.doMeSlot, 0, this.recordId, null, dynamicByteArrayOutputStream, null);
        }
        int n3 = dynamicByteArrayOutputStream.getPosition() - n2;
        dynamicByteArrayOutputStream.setPosition(n2);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n2, n3);
    }

    @Override
    public String toString() {
        return null;
    }
}

