/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.ByteHolderInputStream;

public class RememberBytesInputStream
extends FilterInputStream {
    ByteHolder bh;
    boolean recording = true;
    boolean streamClosed = false;

    public RememberBytesInputStream(InputStream inputStream, ByteHolder byteHolder) {
        super(inputStream);
        this.bh = byteHolder;
    }

    @Override
    public int read() throws IOException {
        int n2 = -1;
        if (!this.streamClosed) {
            n2 = super.read();
            if (n2 != -1) {
                this.bh.write(n2);
            } else {
                this.streamClosed = true;
            }
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.streamClosed) {
            if (n3 + n2 > byArray.length) {
                n3 = byArray.length - n2;
            }
            if ((n3 = super.read(byArray, n2, n3)) > 0) {
                this.bh.write(byArray, n2, n3);
            } else {
                this.streamClosed = true;
            }
        } else {
            return -1;
        }
        return n3;
    }

    public long fillBuf(int n2) throws IOException {
        long l2 = 0L;
        if (!this.streamClosed && (l2 = this.bh.write(this.in, n2)) < (long)n2) {
            this.streamClosed = true;
        }
        return l2;
    }

    public int putBuf(OutputStream outputStream, int n2) throws IOException {
        this.bh.startReading();
        return this.bh.read(outputStream, n2);
    }

    @Override
    public long skip(long l2) throws IOException {
        return this.bh.write(this.in, l2);
    }

    public InputStream getReplayStream() throws IOException {
        this.bh.startReading();
        this.recording = false;
        return new ByteHolderInputStream(this.bh);
    }

    public ByteHolder getByteHolder() throws IOException {
        return this.bh;
    }

    public void clear() throws IOException {
        this.bh.clear();
        this.recording = true;
    }

    public void setInput(InputStream inputStream) {
        this.in = inputStream;
        this.streamClosed = false;
    }

    public boolean recording() {
        return this.recording;
    }

    @Override
    public int available() throws IOException {
        int n2 = this.bh.available();
        n2 = n2 > 0 ? n2 : -1 * n2;
        return n2;
    }

    public int numBytesSaved() throws IOException {
        return this.bh.numBytesSaved();
    }

    public int shiftToFront() throws IOException {
        int n2 = this.bh.shiftToFront();
        return n2;
    }

    public String toString() {
        return "RememberBytesInputStream:  recording: " + this.recording + " " + this.bh;
    }
}

