/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RePreparable;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.xact.TransactionId;

public class LogRecord
implements Formatable {
    private TransactionId xactId;
    private Loggable op;
    private int group;
    transient ObjectInput input;
    private static final int formatLength = FormatIdUtil.getFormatIdByteLength(129);

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        CompressedNumber.writeInt(objectOutput, this.group);
        objectOutput.writeObject(this.xactId);
        objectOutput.writeObject(this.op);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.group = CompressedNumber.readInt(objectInput);
        this.input = objectInput;
        this.xactId = null;
        this.op = null;
    }

    @Override
    public int getTypeFormatId() {
        return 129;
    }

    public void setValue(TransactionId transactionId, Loggable loggable) {
        this.xactId = transactionId;
        this.op = loggable;
        this.group = loggable.group();
    }

    public static int formatOverhead() {
        return formatLength;
    }

    public static int maxGroupStoredSize() {
        return 4;
    }

    public static int maxTransactionIdStoredSize(TransactionId transactionId) {
        return transactionId.getMaxStoredSize();
    }

    public static int getStoredSize(int n2, TransactionId transactionId) {
        return formatLength + CompressedNumber.sizeInt(n2) + FormatIdUtil.getFormatIdByteLength(0);
    }

    public TransactionId getTransactionId() throws IOException, ClassNotFoundException {
        if (this.xactId != null) {
            return this.xactId;
        }
        Object object = this.input.readObject();
        this.xactId = (TransactionId)object;
        return this.xactId;
    }

    public Loggable getLoggable() throws IOException, ClassNotFoundException {
        if (this.op != null) {
            return this.op;
        }
        if (this.xactId == null) {
            this.xactId = (TransactionId)this.input.readObject();
        }
        Object object = this.input.readObject();
        this.op = (Loggable)object;
        this.input = null;
        return this.op;
    }

    public RePreparable getRePreparable() throws IOException, ClassNotFoundException {
        return (RePreparable)((Object)this.getLoggable());
    }

    public void skipLoggable() throws StandardException {
        if (this.op != null) {
            return;
        }
        try {
            if (this.xactId == null) {
                this.xactId = (TransactionId)this.input.readObject();
            }
            if (this.op == null) {
                this.op = (Loggable)this.input.readObject();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.newException("XSLA3.D", classNotFoundException, new Object[0]);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSLA3.D", iOException, new Object[0]);
        }
    }

    public Undoable getUndoable() throws IOException, ClassNotFoundException {
        if (this.op == null) {
            this.getLoggable();
        }
        if (this.op instanceof Undoable) {
            return (Undoable)this.op;
        }
        return null;
    }

    public boolean isCLR() {
        return (this.group & 4) != 0;
    }

    public boolean isFirst() {
        return (this.group & 1) != 0;
    }

    public boolean isComplete() {
        return (this.group & 2) != 0;
    }

    public boolean isPrepare() {
        return (this.group & 0x40) != 0;
    }

    public boolean requiresPrepareLocks() {
        return (this.group & 0x80) != 0;
    }

    public boolean isCommit() {
        return (this.group & 0x10) != 0;
    }

    public boolean isAbort() {
        return (this.group & 0x20) != 0;
    }

    public int group() {
        return this.group;
    }

    public boolean isChecksum() {
        return (this.group & 0x800) != 0;
    }
}

