/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import org.apache.derby.jdbc.ClientConnectionPoolDataSourceInterface;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class ClientConnectionPoolDataSource
extends ClientDataSource
implements ClientConnectionPoolDataSourceInterface {
    private static final long serialVersionUID = -539234282156481377L;
    private static final MessageUtil msgUtil = new MessageUtil("org.apache.derby.loc.clientmessages");
    public static final String className__ = "org.apache.derby.jdbc.ClientConnectionPoolDataSource";
    private int maxStatements = 0;

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnectionMinion();
    }

    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        return this.getPooledConnectionMinion(string, string2);
    }

    @Override
    public void setMaxStatements(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", n2));
        }
        this.maxStatements = n2;
    }

    @Override
    public int getMaxStatements() {
        return this.maxStatements;
    }

    @Override
    public int maxStatementsToPool() {
        return this.maxStatements;
    }

    private final void validateState() {
        if (this.maxStatements < 0) {
            throw new IllegalArgumentException(msgUtil.getTextMessage("J134", this.maxStatements));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.validateState();
    }
}

