/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.BlockReader;

@InterfaceAudience.Private
class BlockReaderUtil {
    BlockReaderUtil() {
    }

    public static int readAll(BlockReader reader, byte[] buf, int offset, int len) throws IOException {
        int nread;
        int n2 = 0;
        do {
            if ((nread = reader.read(buf, offset + n2, len - n2)) > 0) continue;
            return n2 == 0 ? nread : n2;
        } while ((n2 += nread) < len);
        return n2;
    }

    public static void readFully(BlockReader reader, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = reader.read(buf, off, toRead);
            if (ret < 0) {
                throw new IOException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }
}

