/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolUtils;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientDatanodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientDatanodeProtocol,
ProtocolTranslator,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ClientDatanodeProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private final ClientDatanodeProtocolPB rpcProxy;
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto VOID_REFRESH_NAMENODES = ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto VOID_GET_DATANODE_INFO = ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetVolumeReportRequestProto VOID_GET_DATANODE_STORAGE_INFO = ClientDatanodeProtocolProtos.GetVolumeReportRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.StartReconfigurationRequestProto VOID_START_RECONFIG = ReconfigurationProtocolProtos.StartReconfigurationRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto VOID_GET_BALANCER_BANDWIDTH = ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.EvictWritersRequestProto VOID_EVICT_WRITERS = ClientDatanodeProtocolProtos.EvictWritersRequestProto.newBuilder().build();

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(datanodeid, conf, socketTimeout, connectToDnViaHostname, locatedBlock);
    }

    public ClientDatanodeProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, conf, factory, 0);
    }

    public ClientDatanodeProtocolTranslatorPB(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        this.rpcProxy = ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, UserGroupInformation.getCurrentUser(), conf, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(DatanodeID datanodeid, Configuration conf, int socketTimeout, boolean connectToDnViaHostname, LocatedBlock locatedBlock) throws IOException {
        String dnAddr = datanodeid.getIpcAddr(connectToDnViaHostname);
        InetSocketAddress addr = NetUtils.createSocketAddr((String)dnAddr);
        LOG.debug("Connecting to datanode {} addr={}", (Object)dnAddr, (Object)addr);
        Configuration confWithNoIpcIdle = new Configuration(conf);
        confWithNoIpcIdle.setInt("ipc.client.connection.maxidletime", 0);
        UserGroupInformation ticket = UserGroupInformation.createRemoteUser((String)locatedBlock.getBlock().getLocalBlock().toString());
        ticket.addToken(locatedBlock.getBlockToken());
        return ClientDatanodeProtocolTranslatorPB.createClientDatanodeProtocolProxy(addr, ticket, confWithNoIpcIdle, NetUtils.getDefaultSocketFactory((Configuration)conf), socketTimeout);
    }

    static ClientDatanodeProtocolPB createClientDatanodeProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ClientDatanodeProtocolPB.class, ProtobufRpcEngine2.class);
        return (ClientDatanodeProtocolPB)RPC.getProxy(ClientDatanodeProtocolPB.class, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)factory, (int)socketTimeout);
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public long getReplicaVisibleLength(ExtendedBlock b2) throws IOException {
        ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto req = ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto.newBuilder().setBlock(PBHelperClient.convert(b2)).build();
        try {
            return this.rpcProxy.getReplicaVisibleLength(NULL_CONTROLLER, req).getLength();
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void refreshNamenodes() throws IOException {
        try {
            this.rpcProxy.refreshNamenodes(NULL_CONTROLLER, VOID_REFRESH_NAMENODES);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void deleteBlockPool(String bpid, boolean force) throws IOException {
        ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto req = ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto.newBuilder().setBlockPool(bpid).setForce(force).build();
        try {
            this.rpcProxy.deleteBlockPool(NULL_CONTROLLER, req);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock block, Token<BlockTokenIdentifier> token) throws IOException {
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto resp;
        ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto req = ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto.newBuilder().setBlock(PBHelperClient.convert(block)).setToken(PBHelperClient.convert(token)).build();
        try {
            resp = this.rpcProxy.getBlockLocalPathInfo(NULL_CONTROLLER, req);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
        return new BlockLocalPathInfo(PBHelperClient.convert(resp.getBlock()), resp.getLocalPath(), resp.getLocalMetaPath());
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ClientDatanodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientDatanodeProtocolPB.class), (String)methodName);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void shutdownDatanode(boolean forUpgrade) throws IOException {
        ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request = ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto.newBuilder().setForUpgrade(forUpgrade).build();
        try {
            this.rpcProxy.shutdownDatanode(NULL_CONTROLLER, request);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void evictWriters() throws IOException {
        try {
            this.rpcProxy.evictWriters(NULL_CONTROLLER, VOID_EVICT_WRITERS);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public DatanodeLocalInfo getDatanodeInfo() throws IOException {
        try {
            ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto response = this.rpcProxy.getDatanodeInfo(NULL_CONTROLLER, VOID_GET_DATANODE_INFO);
            return PBHelperClient.convert(response.getLocalInfo());
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void startReconfiguration() throws IOException {
        try {
            this.rpcProxy.startReconfiguration(NULL_CONTROLLER, VOID_START_RECONFIG);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        try {
            return ReconfigurationProtocolUtils.getReconfigurationStatus(this.rpcProxy.getReconfigurationStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS));
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public List<String> listReconfigurableProperties() throws IOException {
        try {
            ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto response = this.rpcProxy.listReconfigurableProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES);
            return response.getNameList();
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void triggerBlockReport(BlockReportOptions options) throws IOException {
        try {
            ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto.Builder builder = ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto.newBuilder().setIncremental(options.isIncremental());
            if (options.getNamenodeAddr() != null) {
                builder.setNnAddress(NetUtils.getHostPortString((InetSocketAddress)options.getNamenodeAddr()));
            }
            this.rpcProxy.triggerBlockReport(NULL_CONTROLLER, builder.build());
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public long getBalancerBandwidth() throws IOException {
        try {
            ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto response = this.rpcProxy.getBalancerBandwidth(NULL_CONTROLLER, VOID_GET_BALANCER_BANDWIDTH);
            return response.getBandwidth();
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void submitDiskBalancerPlan(String planID, long planVersion, String planFile, String planData, boolean skipDateCheck) throws IOException {
        try {
            ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanRequestProto request = ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanRequestProto.newBuilder().setPlanID(planID).setPlanVersion(planVersion).setPlanFile(planFile).setPlan(planData).setIgnoreDateCheck(skipDateCheck).build();
            this.rpcProxy.submitDiskBalancerPlan(NULL_CONTROLLER, request);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public void cancelDiskBalancePlan(String planID) throws IOException {
        try {
            ClientDatanodeProtocolProtos.CancelPlanRequestProto request = ClientDatanodeProtocolProtos.CancelPlanRequestProto.newBuilder().setPlanID(planID).build();
            this.rpcProxy.cancelDiskBalancerPlan(NULL_CONTROLLER, request);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public DiskBalancerWorkStatus queryDiskBalancerPlan() throws IOException {
        try {
            ClientDatanodeProtocolProtos.QueryPlanStatusRequestProto request = ClientDatanodeProtocolProtos.QueryPlanStatusRequestProto.newBuilder().build();
            ClientDatanodeProtocolProtos.QueryPlanStatusResponseProto response = this.rpcProxy.queryDiskBalancerPlan(NULL_CONTROLLER, request);
            DiskBalancerWorkStatus.Result result = DiskBalancerWorkStatus.Result.NO_PLAN;
            if (response.hasResult()) {
                result = DiskBalancerWorkStatus.Result.values()[response.getResult()];
            }
            return new DiskBalancerWorkStatus(result, response.hasPlanID() ? response.getPlanID() : null, response.hasPlanFile() ? response.getPlanFile() : null, response.hasCurrentStatus() ? response.getCurrentStatus() : null);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public String getDiskBalancerSetting(String key) throws IOException {
        try {
            ClientDatanodeProtocolProtos.DiskBalancerSettingRequestProto request = ClientDatanodeProtocolProtos.DiskBalancerSettingRequestProto.newBuilder().setKey(key).build();
            ClientDatanodeProtocolProtos.DiskBalancerSettingResponseProto response = this.rpcProxy.getDiskBalancerSetting(NULL_CONTROLLER, request);
            return response.hasValue() ? response.getValue() : null;
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public List<DatanodeVolumeInfo> getVolumeReport() throws IOException {
        try {
            ArrayList<DatanodeVolumeInfo> volumeInfoList = new ArrayList<DatanodeVolumeInfo>();
            ClientDatanodeProtocolProtos.GetVolumeReportResponseProto volumeReport = this.rpcProxy.getVolumeReport(NULL_CONTROLLER, VOID_GET_DATANODE_STORAGE_INFO);
            List<HdfsProtos.DatanodeVolumeInfoProto> volumeProtoList = volumeReport.getVolumeInfoList();
            for (HdfsProtos.DatanodeVolumeInfoProto proto : volumeProtoList) {
                volumeInfoList.add(new DatanodeVolumeInfo(proto.getPath(), proto.getUsedSpace(), proto.getFreeSpace(), proto.getReservedSpace(), proto.getReservedSpaceForReplicas(), proto.getNumBlocks(), PBHelperClient.convertStorageType(proto.getStorageType())));
            }
            return volumeInfoList;
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }
}

